/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.xinput;

import jpen.provider.xinput.XiDevice;
import jpen.provider.xinput.XinputProvider;

final class XiBus {
    private final int cellIndex;
    private XiDevice xiDevice;

    XiBus() throws Exception {
        XinputProvider.loadLibrary();
        this.cellIndex = XiBus.create();
        if (this.cellIndex == -1) {
            throw new Exception(XiBus.getError());
        }
    }

    public static native int getNativeBuild();

    private static native int create();

    private static native String getError();

    public synchronized int getXiDevicesSize() {
        return XiBus.getDevicesSize(this.cellIndex);
    }

    private static native int getDevicesSize(int var0);

    public synchronized String getXiDeviceName(int xiDeviceIndex) {
        return XiBus.getDeviceName(this.cellIndex, xiDeviceIndex);
    }

    private static native String getDeviceName(int var0, int var1);

    public synchronized XiDevice getXiDevice() {
        return this.xiDevice;
    }

    public synchronized void setXiDevice(int xiDeviceIndex) throws Exception {
        if (xiDeviceIndex == -1) {
            this.xiDevice = null;
            return;
        }
        int xiDeviceCellIndex = XiBus.setDevice(this.cellIndex, xiDeviceIndex);
        if (xiDeviceCellIndex < 0) {
            throw new Exception(XiBus.getError());
        }
        this.xiDevice = new XiDevice(this, xiDeviceCellIndex, xiDeviceIndex);
    }

    private static native int setDevice(int var0, int var1);

    public synchronized void refreshXiDeviceInfo() {
        if (XiBus.refreshDeviceInfo(this.cellIndex) != 0) {
            throw new IllegalStateException(XiBus.getError());
        }
    }

    private static native int refreshDeviceInfo(int var0);

    protected synchronized void finalize() {
        if (this.cellIndex != -1) {
            XiBus.destroy(this.cellIndex);
        }
    }

    static native int destroy(int var0);

    public String toString() {
        return "{Bus: xiDevice=" + this.xiDevice + "}";
    }
}

