/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcPopupInterface;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

class AlcColorPicker
extends JMenuItem
implements MouseListener,
AlcConstants {
    private BufferedImage colorArray;
    private AlcPopupInterface parent;
    private boolean background = false;
    private BufferedImage[] screenShots;
    private GraphicsDevice[] devices;
    private int currentDevice = 0;
    private JDialog eyeDropperWindow;
    private Timer eyeDropperTimer;
    private boolean eyeDropperActive = false;

    AlcColorPicker(AlcPopupInterface parent) {
        this.setup(parent);
    }

    AlcColorPicker(AlcPopupInterface parent, boolean background) {
        this.setup(parent);
        this.background = background;
    }

    private void setup(AlcPopupInterface parent) {
        this.parent = parent;
        this.setPreferredSize(new Dimension(100, 115));
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.colorArray = AlcUtil.getBufferedImage("color-picker.png");
        this.setCursor(CURSOR_CIRCLE);
        this.addMouseListener(this);
    }

    Color getColor(int x, int y) {
        return new Color(this.colorArray.getRGB(x, y));
    }

    public boolean isEyeDropperActive() {
        return this.eyeDropperActive;
    }

    void startEyeDropper() {
        Alchemy.canvas.setAutoToggleToolBar(false);
        this.devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        this.screenShots = new BufferedImage[this.devices.length];
        for (int i = 0; i < this.devices.length; ++i) {
            try {
                GraphicsConfiguration gc = this.devices[i].getDefaultConfiguration();
                Rectangle screenBounds = gc.getBounds();
                Robot robot = new Robot(this.devices[i]);
                Rectangle newBounds = new Rectangle(0, 0, screenBounds.width, screenBounds.height);
                this.screenShots[i] = robot.createScreenCapture(newBounds);
                continue;
            }
            catch (Exception ex) {
                System.err.println("Error creating a screenshot for the eye dropper");
                ex.printStackTrace();
            }
        }
        this.eyeDropperWindow = new JDialog((Frame)Alchemy.window, false);
        this.eyeDropperWindow.setUndecorated(true);
        this.eyeDropperWindow.setBounds(new Rectangle(12, 12));
        this.eyeDropperWindow.setCursor(CURSOR_EYEDROPPER);
        if (Alchemy.OS == 2) {
            this.eyeDropperWindow.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
        }
        this.eyeDropperWindow.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                AlcColorPicker.this.stopEyeDropper();
                AlcColorPicker.this.eyeDropperActive = false;
            }
        });
        this.eyeDropperTimer = new Timer(5, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AlcColorPicker.this.updateEyeDropper();
            }
        });
        JPanel imagePanel = new JPanel(){

            public void paintComponent(Graphics g) {
                Point pos = this.getLocationOnScreen();
                Point offset = new Point(-pos.x, -pos.y);
                Rectangle bounds = AlcColorPicker.this.devices[AlcColorPicker.this.currentDevice].getDefaultConfiguration().getBounds();
                Point origin = bounds.getLocation();
                if (origin.x == 0 && origin.y == 0) {
                    g.drawImage(AlcColorPicker.this.screenShots[AlcColorPicker.this.currentDevice], offset.x, offset.y, null);
                } else {
                    g.drawImage(AlcColorPicker.this.screenShots[AlcColorPicker.this.currentDevice], offset.x + origin.x, offset.y + origin.y, null);
                }
            }
        };
        this.eyeDropperWindow.setContentPane(imagePanel);
        if (Alchemy.OS != 2) {
            this.eyeDropperWindow.setFocusableWindowState(false);
        }
        this.eyeDropperTimer.start();
        this.eyeDropperWindow.setVisible(true);
    }

    private void updateEyeDropper() {
        if (this.eyeDropperWindow != null) {
            PointerInfo info = MouseInfo.getPointerInfo();
            GraphicsDevice device = info.getDevice();
            Point mouseLoc = info.getLocation();
            this.eyeDropperWindow.setLocation(mouseLoc.x - 6, mouseLoc.y - 6);
            for (int i = 0; i < this.devices.length; ++i) {
                if (!this.devices[i].equals(device)) continue;
                this.currentDevice = i;
            }
            this.eyeDropperWindow.repaint();
        }
    }

    void stopEyeDropper() {
        if (this.eyeDropperWindow != null) {
            try {
                PointerInfo info = MouseInfo.getPointerInfo();
                Point mouseLoc = info.getLocation();
                Rectangle bounds = this.devices[this.currentDevice].getDefaultConfiguration().getBounds();
                Point origin = bounds.getLocation();
                Color c = origin.x == 0 && origin.y == 0 ? new Color(this.screenShots[this.currentDevice].getRGB(mouseLoc.x - 6, mouseLoc.y + 6)) : new Color(this.screenShots[this.currentDevice].getRGB(mouseLoc.x - origin.x - 6, mouseLoc.y - origin.y + 6));
                if (this.background) {
                    Alchemy.canvas.setBackgroundColor(c);
                } else {
                    Alchemy.canvas.setForegroundColor(c);
                }
                Alchemy.toolBar.refreshColorButton();
                if (this.eyeDropperTimer.isRunning()) {
                    this.eyeDropperTimer.stop();
                }
                this.eyeDropperWindow.setVisible(false);
                this.eyeDropperWindow.dispose();
                this.screenShots = null;
                this.devices = null;
                Alchemy.canvas.restoreCursor();
                Alchemy.canvas.setAutoToggleToolBar(true);
            }
            catch (Exception ex) {
                System.err.println("Error selecting color from the eye dropper");
                ex.printStackTrace();
            }
        }
    }

    private void startColorSelector() {
        ActionListener colorAction = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (AlcColorPicker.this.background) {
                    Alchemy.canvas.setBackgroundColor(Alchemy.colorSelector.getColor());
                } else {
                    Alchemy.canvas.setForegroundColor(Alchemy.colorSelector.getColor());
                }
                Alchemy.toolBar.refreshColorButton();
            }
        };
        Color color = this.background ? Alchemy.canvas.getBackgroundColor() : Alchemy.canvas.getColor();
        Alchemy.colorSelector.show(colorAction, null, color);
    }

    protected void paintComponent(Graphics g) {
        this.setOpaque(true);
        Rectangle size = this.getBounds();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, size.width, size.height);
        g.drawImage(this.colorArray, 0, 0, null);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x >= 60 && x < 80 && y <= 20) {
            if (!Alchemy.preferences.paletteAttached) {
                Alchemy.toolBar.setToolBarVisible(false);
            }
            Timer initialDelay = new Timer(50, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (!AlcColorPicker.this.eyeDropperActive) {
                        AlcColorPicker.this.eyeDropperActive = true;
                        AlcColorPicker.this.startEyeDropper();
                    }
                }
            });
            initialDelay.setRepeats(false);
            initialDelay.start();
        } else if (e.getX() >= 80 && e.getY() <= 20) {
            this.startColorSelector();
        } else {
            if (this.background) {
                Alchemy.canvas.setBackgroundColor(this.getColor(e.getX(), e.getY()));
            } else {
                Alchemy.canvas.setForegroundColor(this.getColor(e.getX(), e.getY()));
            }
            if (Alchemy.OS == 2) {
                Alchemy.canvas.restoreCursor();
                Alchemy.toolBar.setCursor(CURSOR_ARROW);
                this.setCursor(CURSOR_ARROW);
            }
            Alchemy.toolBar.refreshColorButton();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (Alchemy.OS == 2) {
            Alchemy.canvas.setTempCursor(CURSOR_CIRCLE);
            Alchemy.toolBar.setCursor(CURSOR_CIRCLE);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (Alchemy.OS == 2) {
            Alchemy.canvas.restoreCursor();
            Alchemy.toolBar.setCursor(CURSOR_ARROW);
        }
    }
}

