/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.util.Random;
import org.alchemy.core.AlcConstants;

public class AlcMath
implements AlcConstants {
    Random internalRandom;
    static final int PERLIN_YWRAPB = 4;
    static final int PERLIN_YWRAP = 16;
    static final int PERLIN_ZWRAPB = 8;
    static final int PERLIN_ZWRAP = 256;
    static final int PERLIN_SIZE = 4095;
    int perlin_octaves = 4;
    float perlin_amp_falloff = 0.5f;
    int perlin_TWOPI;
    int perlin_PI;
    float[] perlin_cosTable;
    float[] perlin;
    Random perlinRandom;

    AlcMath() {
    }

    public final float random(float howbig) {
        if (howbig == 0.0f) {
            return 0.0f;
        }
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        float value = 0.0f;
        while ((value = this.internalRandom.nextFloat() * howbig) == howbig) {
        }
        return value;
    }

    public final float random(float howsmall, float howbig) {
        if (howsmall >= howbig) {
            return howsmall;
        }
        float diff = howbig - howsmall;
        return this.random(diff) + howsmall;
    }

    public final void randomSeed(long what) {
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        this.internalRandom.setSeed(what);
    }

    public float noise(float x) {
        return this.noise(x, 0.0f, 0.0f);
    }

    public float noise(float x, float y) {
        return this.noise(x, y, 0.0f);
    }

    public final float noise(float x, float y, float z) {
        int i;
        float SINCOS_PRECISION = 0.5f;
        int SINCOS_LENGTH = (int)(360.0f / SINCOS_PRECISION);
        float[] sinLUT = new float[SINCOS_LENGTH];
        float[] cosLUT = new float[SINCOS_LENGTH];
        for (i = 0; i < SINCOS_LENGTH; ++i) {
            sinLUT[i] = (float)Math.sin((float)i * ((float)Math.PI / 180) * SINCOS_PRECISION);
            cosLUT[i] = (float)Math.cos((float)i * ((float)Math.PI / 180) * SINCOS_PRECISION);
        }
        if (this.perlin == null) {
            if (this.perlinRandom == null) {
                this.perlinRandom = new Random();
            }
            this.perlin = new float[4096];
            for (i = 0; i < 4096; ++i) {
                this.perlin[i] = this.perlinRandom.nextFloat();
            }
            this.perlin_cosTable = cosLUT;
            this.perlin_TWOPI = this.perlin_PI = SINCOS_LENGTH;
            this.perlin_PI >>= 1;
        }
        if (x < 0.0f) {
            x = -x;
        }
        if (y < 0.0f) {
            y = -y;
        }
        if (z < 0.0f) {
            z = -z;
        }
        int xi = (int)x;
        int yi = (int)y;
        int zi = (int)z;
        float xf = x - (float)xi;
        float yf = y - (float)yi;
        float zf = z - (float)zi;
        float r = 0.0f;
        float ampl = 0.5f;
        for (int i2 = 0; i2 < this.perlin_octaves; ++i2) {
            int of = xi + (yi << 4) + (zi << 8);
            float rxf = this.noise_fsc(xf);
            float ryf = this.noise_fsc(yf);
            float n1 = this.perlin[of & 0xFFF];
            n1 += rxf * (this.perlin[of + 1 & 0xFFF] - n1);
            float n2 = this.perlin[of + 16 & 0xFFF];
            n2 += rxf * (this.perlin[of + 16 + 1 & 0xFFF] - n2);
            n1 += ryf * (n2 - n1);
            n2 = this.perlin[(of += 256) & 0xFFF];
            n2 += rxf * (this.perlin[of + 1 & 0xFFF] - n2);
            float n3 = this.perlin[of + 16 & 0xFFF];
            n3 += rxf * (this.perlin[of + 16 + 1 & 0xFFF] - n3);
            n2 += ryf * (n3 - n2);
            n1 += this.noise_fsc(zf) * (n2 - n1);
            r += n1 * ampl;
            ampl *= this.perlin_amp_falloff;
            xi <<= 1;
            xf *= 2.0f;
            yi <<= 1;
            yf *= 2.0f;
            zi <<= 1;
            zf *= 2.0f;
            if (xf >= 1.0f) {
                ++xi;
                xf -= 1.0f;
            }
            if (yf >= 1.0f) {
                ++yi;
                yf -= 1.0f;
            }
            if (!(zf >= 1.0f)) continue;
            ++zi;
            zf -= 1.0f;
        }
        return r;
    }

    private final float noise_fsc(float i) {
        return 0.5f * (1.0f - this.perlin_cosTable[(int)(i * (float)this.perlin_PI) % this.perlin_TWOPI]);
    }

    public final void noiseDetail(int lod) {
        if (lod > 0) {
            this.perlin_octaves = lod;
        }
    }

    public final void noiseDetail(int lod, float falloff) {
        if (lod > 0) {
            this.perlin_octaves = lod;
        }
        if (falloff > 0.0f) {
            this.perlin_amp_falloff = falloff;
        }
    }

    public final void noiseSeed(long what) {
        if (this.perlinRandom == null) {
            this.perlinRandom = new Random();
        }
        this.perlinRandom.setSeed(what);
        this.perlin = null;
    }

    public static final double mean(int[] p) {
        int sum = 0;
        for (int i = 0; i < p.length; ++i) {
            sum += p[i];
        }
        return sum / p.length;
    }

    public static final float map(float value, float istart, float istop, float ostart, float ostop) {
        return ostart + (ostop - ostart) * ((value - istart) / (istop - istart));
    }

    public static final int constrain(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static final float constrain(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static final float distance(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt(AlcMath.sq(x2 - x1) + AlcMath.sq(y2 - y1));
    }

    public static final float sq(float num) {
        return num * num;
    }
}

