/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import org.alchemy.core.AlcMicInterface;

public class AlcMicrophone {
    private Thread micThread;
    private byte[] audioBytes;
    private int[] audioSamples;
    private int lengthInSamples;
    private boolean running = false;
    private boolean firstRun = true;
    private AudioFormat audioFormat;
    private TargetDataLine targetDataLine;
    AlcMicInterface parent;

    public AlcMicrophone(int bufferSize) {
        this.setup(null, bufferSize);
    }

    public AlcMicrophone(AlcMicInterface parent, int bufferSize) {
        this.setup(parent, bufferSize);
    }

    public AlcMicrophone(AlcMicInterface parent) {
        this.setup(parent, -1);
    }

    private void setup(AlcMicInterface parent, int bufferSize) {
        if (parent != null) {
            this.parent = parent;
        }
        this.audioFormat = this.getAudioFormat();
        System.out.println("Selected Format: " + this.audioFormat);
        if (bufferSize > 0) {
            this.setBuffer(bufferSize);
        }
    }

    public void setBuffer(int bufferSize) {
        this.audioBytes = new byte[bufferSize];
        this.lengthInSamples = bufferSize / 2;
        this.audioSamples = new int[this.lengthInSamples];
        if (this.firstRun) {
            this.openLine();
        }
    }

    public void openLine() {
        try {
            DataLine.Info dataLineInfo = new DataLine.Info(TargetDataLine.class, this.audioFormat);
            this.targetDataLine = (TargetDataLine)AudioSystem.getLine(dataLineInfo);
            this.targetDataLine.open(this.audioFormat);
            this.targetDataLine.start();
            this.firstRun = false;
        }
        catch (LineUnavailableException ex) {
            System.err.println("ERROR opening the audio line: " + ex);
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void closeLine() {
        this.stop();
        this.targetDataLine.stop();
        this.targetDataLine = null;
        this.firstRun = true;
    }

    public void start() {
        this.running = true;
        this.micThread = new Thread(){

            public void run() {
                try {
                    while (AlcMicrophone.this.running) {
                        int cnt = AlcMicrophone.this.targetDataLine.read(AlcMicrophone.this.audioBytes, 0, AlcMicrophone.this.audioBytes.length);
                        if (cnt <= 0) continue;
                        AlcMicrophone.this.convertToSamples();
                        if (AlcMicrophone.this.parent == null) continue;
                        AlcMicrophone.this.parent.microphoneEvent();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.micThread.start();
    }

    public void stop() {
        this.running = false;
        this.micThread = null;
    }

    private void convertToSamples() {
        if (this.audioFormat.isBigEndian()) {
            for (int i = 0; i < this.audioSamples.length; ++i) {
                byte MSB = this.audioBytes[2 * i];
                byte LSB = this.audioBytes[2 * i + 1];
                this.audioSamples[i] = MSB << 8 | 0xFF & LSB;
            }
        } else {
            for (int i = 0; i < this.audioSamples.length; ++i) {
                byte LSB = this.audioBytes[2 * i];
                byte MSB = this.audioBytes[2 * i + 1];
                this.audioSamples[i] = MSB << 8 | 0xFF & LSB;
            }
        }
    }

    public double getMicLevel() {
        double sum = 0.0;
        for (int i = 0; i < this.audioSamples.length; ++i) {
            sum += (double)Math.abs(this.audioSamples[i]);
        }
        double average = sum / (double)this.audioSamples.length / 100.0;
        return average;
    }

    public byte[] getBuffer() {
        return this.audioBytes;
    }

    public int[] getSamples() {
        return this.audioSamples;
    }

    private AudioFormat getAudioFormat() {
        Mixer.Info[] mi = AudioSystem.getMixerInfo();
        block2: for (int i = 0; i < mi.length; ++i) {
            Mixer m = AudioSystem.getMixer(mi[i]);
            Line.Info[] tli = m.getTargetLineInfo();
            for (int j = 0; j < tli.length; ++j) {
                try {
                    AudioFormat[] formats = ((DataLine.Info)tli[j]).getFormats();
                    for (int k = 0; k < formats.length; ++k) {
                        AudioFormat thisFormat = formats[k];
                        if (thisFormat.getChannels() != 1 || thisFormat.getFrameSize() != 2 || thisFormat.getSampleSizeInBits() != 16) continue;
                        this.audioFormat = thisFormat;
                        break block2;
                    }
                    continue;
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
        }
        if (this.audioFormat.getSampleRate() == -1.0f) {
            System.out.println("Sample Rate not specified, assigning 441000hz");
            this.audioFormat = new AudioFormat(41000.0f, this.audioFormat.getSampleSizeInBits(), this.audioFormat.getChannels(), true, this.audioFormat.isBigEndian());
        }
        if (this.audioFormat == null) {
            this.audioFormat = new AudioFormat(44100.0f, 16, 1, true, false);
            System.err.println("No audio format found, assigning the default format");
        }
        return this.audioFormat;
    }
}

