/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcPalette;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

class AlcPaletteTitleBar
extends JPanel
implements AlcConstants {
    private int originalX;
    private int originalY;

    AlcPaletteTitleBar(final AlcPalette parent) {
        this.setBackground(Color.LIGHT_GRAY);
        this.setPreferredSize(new Dimension(12, 88));
        JButton closeButton = new JButton(AlcUtil.getImageIcon("palette.png"));
        closeButton.setRolloverIcon(AlcUtil.getImageIcon("palette-over.png"));
        closeButton.setToolTipText("Close the palette and restore the toolbar to the main window");
        closeButton.setMargin(new Insets(0, 0, 0, 0));
        closeButton.setBorderPainted(false);
        closeButton.setContentAreaFilled(false);
        closeButton.setFocusPainted(false);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.window.setPalette(false);
            }
        });
        this.add(closeButton);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                AlcPaletteTitleBar.this.originalX = e.getX();
                AlcPaletteTitleBar.this.originalY = e.getY();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                parent.shiftPalette(e.getX() - AlcPaletteTitleBar.this.originalX, e.getY() - AlcPaletteTitleBar.this.originalY);
            }
        });
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, COLOR_UI_HIGHLIGHT, this.getWidth(), 0.0f, new Color(208, 208, 208), true);
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(gradientPaint);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setPaint(COLOR_UI_LINE);
            int widthMinusOne = this.getWidth() - 1;
            g2.drawLine(widthMinusOne, 0, widthMinusOne, this.getHeight());
        }
    }
}

