/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Arrays;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcModule;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;
import org.alchemy.core.PluginComparator;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.standard.StandardPluginLocation;

class AlcPlugins
implements AlcConstants {
    AlcModule[] creates;
    AlcModule[] affects;
    int currentCreate = 0;
    boolean[] currentAffects;
    private int numberOfCurrentAffects = 0;
    private PluginManager pluginManager = ObjectFactory.newInstance().createManager();
    private int numberOfPlugins;
    private int numberOfCreateModules = 0;
    private int numberOfAffectModules = 0;

    AlcPlugins() {
        File[] plugins;
        File pluginsDir = new File("modules");
        if (!pluginsDir.exists()) {
            AlcUtil.showConfirmDialogFromBundle("noModulesDialogTitle", "noModulesDialogMessage");
            System.exit(0);
        }
        if ((plugins = pluginsDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".zip");
            }
        })).length <= 0) {
            AlcUtil.showConfirmDialogFromBundle("noModulesDialogTitle", "noModulesDialogMessage");
            System.exit(0);
        }
        boolean coreExists = false;
        for (int i = 0; i < plugins.length; ++i) {
            if (plugins[i].getName().indexOf("org.alchemy.core") == -1) continue;
            coreExists = true;
            break;
        }
        if (!coreExists) {
            AlcUtil.showConfirmDialogFromBundle("noCoreModuleDialogTitle", "noCoreModuleDialogMessage");
            System.exit(0);
        }
        try {
            PluginManager.PluginLocation[] locations = new PluginManager.PluginLocation[plugins.length];
            this.numberOfPlugins = plugins.length - 1;
            for (int i = 0; i < plugins.length; ++i) {
                locations[i] = StandardPluginLocation.create(plugins[i]);
                if (plugins[i].getName().startsWith("org.alchemy.create")) {
                    ++this.numberOfCreateModules;
                    continue;
                }
                if (!plugins[i].getName().startsWith("org.alchemy.affect")) continue;
                ++this.numberOfAffectModules;
            }
            this.pluginManager.publishPlugins(locations);
        }
        catch (Exception ex) {
            System.err.println("ERROR - Problem publishing plugins to the pluginManager");
            ex.printStackTrace();
        }
        if (this.getNumberOfAffectModules() > 0) {
            this.currentAffects = new boolean[this.getNumberOfAffectModules()];
            String[] affectsOrder = new String[]{"Displace", "Gradient", "Mirror", "Blindness", "Random"};
            this.affects = this.addPlugins("Affect", this.getNumberOfAffectModules(), 2, affectsOrder);
        }
        if (this.getNumberOfCreateModules() > 0) {
            String[] createsOrder = new String[]{"Shapes", "Mic Shapes", "Speed Shapes"};
            this.creates = this.addPlugins("Create", this.getNumberOfCreateModules(), 1, createsOrder);
        } else {
            AlcUtil.showConfirmDialogFromBundle("noCreateModulesDialogTitle", "noCreateModulesDialogMessage");
            System.exit(0);
        }
    }

    void initialiseModules() {
        int i;
        for (i = 0; i < this.creates.length; ++i) {
            this.creates[i].setGlobals(Alchemy.canvas, Alchemy.toolBar, Alchemy.math, Alchemy.colorSelector);
        }
        if (this.getNumberOfAffectModules() > 0) {
            for (i = 0; i < this.affects.length; ++i) {
                this.affects[i].setGlobals(Alchemy.canvas, Alchemy.toolBar, Alchemy.math, Alchemy.colorSelector);
            }
        }
        this.currentCreate = 0;
        this.creates[this.currentCreate].setup();
    }

    AlcModule[] addPlugins(String pointName, int numberOfModules, int moduleType, String[] order) {
        AlcModule[] plugins = new AlcModule[numberOfModules];
        AlcModule[] pluginsSorted = new AlcModule[numberOfModules];
        int index = 0;
        int noMatchCount = 0;
        try {
            PluginDescriptor core = this.pluginManager.getRegistry().getPluginDescriptor("org.alchemy.core");
            ExtensionPoint point = this.pluginManager.getRegistry().getExtensionPoint(core.getId(), pointName);
            for (Extension ext : point.getConnectedExtensions()) {
                PluginDescriptor descr = ext.getDeclaringPluginDescriptor();
                this.pluginManager.activatePlugin(descr.getId());
                System.out.println(descr.getId());
                PluginClassLoader classLoader = this.pluginManager.getPluginClassLoader(descr);
                Class<?> pluginCls = classLoader.loadClass(ext.getParameter("class").valueAsString());
                AlcModule currentPlugin = (AlcModule)pluginCls.newInstance();
                AlcModule currentPluginSorted = (AlcModule)pluginCls.newInstance();
                String descriptionParam = ext.getParameter("description").valueAsString();
                String iconParam = ext.getParameter("icon").valueAsString();
                String nameParam = ext.getParameter("name").valueAsString();
                int sortIndex = -1;
                for (int i = 0; i < order.length; ++i) {
                    if (!nameParam.equals(order[i])) continue;
                    sortIndex = i;
                }
                if (sortIndex == -1) {
                    sortIndex = 100 + ++noMatchCount;
                }
                plugins[index] = currentPlugin;
                pluginsSorted[index] = currentPluginSorted;
                URL iconUrl = null;
                if (iconParam != null) {
                    iconUrl = classLoader.getResource(iconParam);
                    plugins[index].setIconUrl(iconUrl);
                    pluginsSorted[index].setIconUrl(iconUrl);
                }
                plugins[index].setModuleType(moduleType);
                plugins[index].setName(nameParam);
                plugins[index].setIconName(iconParam);
                plugins[index].setDescription(descriptionParam);
                plugins[index].setIndex(index);
                plugins[index].setClassLoader(classLoader);
                pluginsSorted[index].setModuleType(moduleType);
                pluginsSorted[index].setName(nameParam);
                pluginsSorted[index].setIconName(iconParam);
                pluginsSorted[index].setDescription(descriptionParam);
                pluginsSorted[index].setSortOrderIndex(sortIndex);
                pluginsSorted[index].setClassLoader(classLoader);
                ++index;
            }
        }
        catch (Exception ex) {
            System.err.println("ERROR - Problem activating and initialising plugins");
            ex.printStackTrace();
        }
        try {
            Arrays.sort(pluginsSorted, new PluginComparator());
            for (int i = 0; i < pluginsSorted.length; ++i) {
                pluginsSorted[i].setIndex(i);
            }
            return pluginsSorted;
        }
        catch (Exception ex) {
            System.err.println("ERROR - Problem sorting plugins, defaulting to unsorted ordering");
            ex.printStackTrace();
            return plugins;
        }
    }

    int getNumberOfPlugins() {
        return this.numberOfPlugins;
    }

    int getNumberOfCreateModules() {
        return this.numberOfCreateModules;
    }

    int getNumberOfAffectModules() {
        return this.numberOfAffectModules;
    }

    boolean hasCurrentAffects() {
        return this.numberOfCurrentAffects > 0;
    }

    void setCurrentCreate(int i) {
        this.creates[this.currentCreate].deselect();
        this.currentCreate = i;
        if (this.creates[i].getLoaded()) {
            this.creates[i].reselect();
        } else {
            this.creates[i].setLoaded(true);
            this.creates[i].setup();
        }
    }

    void addAffect(int i) {
        ++this.numberOfCurrentAffects;
        this.currentAffects[i] = true;
        if (this.affects[i].getLoaded()) {
            this.affects[i].reselect();
        } else {
            this.affects[i].setLoaded(true);
            this.affects[i].setup();
        }
    }

    void removeAffect(int i) {
        --this.numberOfCurrentAffects;
        this.currentAffects[i] = false;
        this.affects[i].deselect();
    }
}

