/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcModule;
import org.alchemy.core.AlcShape;
import org.alchemy.core.AlcToggleButton;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

class AlcPreferences
implements AlcConstants {
    static Preferences prefs;
    public final int FORMAT_PDF = 0;
    public final int FORMAT_SVG = 1;
    private JDialog prefsWindow;
    private JPanel bgPanel;
    private JPanel generalPanel;
    private JPanel sessionPanel;
    private final int GENERAL = 1;
    private final int SESSION = 2;
    private int currentTab = 1;
    private JButton okButton;
    private final Dimension prefsWindowSize = new Dimension(500, 450);
    private final int tabPanelHeight = 65;
    private AlcToggleButton generalTabButton;
    private JComboBox interfaceBox;
    private JCheckBox recordOnStartUp;
    private JTextField sessionDirectoryTextField;
    private JLabel sessionFileRenameOutput;
    private JTextField sessionFileRenamePre;
    private JTextField sessionFileRenameDate;
    private JScrollPane scrollPane;
    private boolean modulesSet;
    private JPanel modulesPanel;
    final String modulePrefix = "Module - ";
    private boolean changeModules = false;
    boolean sessionRecordingState;
    boolean sessionRecordingWarning;
    String sessionPath;
    int sessionRecordingInterval;
    boolean sessionAutoClear;
    boolean sessionLink;
    String sessionFilePreName;
    String sessionFileDateFormat;
    private final String defaultSessionFilePreName = "Alchemy-";
    private final String defaultSessionFileDateFormat = "yyyy-MM-dd-HH-mm-ss";
    String shapesPath;
    String switchVectorApp;
    int switchVectorFormat;
    String switchBitmapApp;
    boolean paletteAttached;
    Point paletteLocation;
    Point canvasLocation;
    Dimension canvasSize;
    boolean transparentFullscreen;
    boolean simpleToolBar;
    boolean smoothing;
    boolean lineSmoothing;
    int bgColor;
    int color;
    String exportDirectory;

    AlcPreferences() {
        this.loadPreferences();
    }

    private void loadPreferences() {
        prefs = Preferences.userNodeForPackage(this.getClass());
        this.modulesSet = prefs.getBoolean("Modules Set", false);
        this.sessionRecordingState = prefs.getBoolean("Recording State", false);
        this.sessionRecordingWarning = prefs.getBoolean("Recording Warning", true);
        this.sessionPath = prefs.get("Session Path", DIR_DESKTOP);
        this.sessionRecordingInterval = prefs.getInt("Recording Interval", 30000);
        this.sessionAutoClear = prefs.getBoolean("Auto Clear Canvas", false);
        this.sessionLink = prefs.getBoolean("Link to Current Session", true);
        this.sessionFilePreName = prefs.get("Session File Pre Name", "Alchemy-");
        this.sessionFileDateFormat = prefs.get("Session File Date Format", "yyyy-MM-dd-HH-mm-ss");
        this.shapesPath = prefs.get("Shapes Path", new File("shapes").getAbsolutePath());
        this.switchVectorApp = prefs.get("Switch Vector Application", null);
        this.switchVectorFormat = prefs.getInt("Switch Vector Format", 0);
        this.switchBitmapApp = prefs.get("Switch Bitmap Application", null);
        this.paletteAttached = prefs.getBoolean("Palette Attached", false);
        this.paletteLocation = AlcPreferences.stringToPoint(prefs.get("Palette Location", null));
        this.canvasLocation = AlcPreferences.stringToPoint(prefs.get("Canvas Location", null));
        this.canvasSize = AlcPreferences.stringToDimension(prefs.get("Canvas Size", null));
        this.transparentFullscreen = prefs.getBoolean("Transparent Fullscreen", false);
        this.simpleToolBar = prefs.getBoolean("Simple ToolBar", false);
        this.smoothing = prefs.getBoolean("Smoothing", true);
        this.lineSmoothing = prefs.getBoolean("Line Smoothing", true);
        this.bgColor = prefs.getInt("Background Color", 0xFFFFFF);
        this.color = prefs.getInt("Color", 0);
        this.exportDirectory = prefs.get("Export Directory", DIR_DESKTOP);
    }

    void writeChanges() {
        prefs.putBoolean("Modules Set", this.modulesSet);
        prefs.putBoolean("Recording State", this.sessionRecordingState);
        prefs.putBoolean("Recording Warning", this.sessionRecordingWarning);
        prefs.put("Session Path", this.sessionPath);
        prefs.putInt("Recording Interval", this.sessionRecordingInterval);
        prefs.putBoolean("Auto Clear Canvas", this.sessionAutoClear);
        prefs.putBoolean("Link to Current Session", this.sessionLink);
        prefs.put("Session File Pre Name", this.sessionFilePreName);
        prefs.put("Session File Date Format", this.sessionFileDateFormat);
        prefs.put("Shapes Path", this.shapesPath);
        prefs.putBoolean("Palette Attached", this.paletteAttached);
        prefs.putBoolean("Smoothing", Alchemy.canvas.isSmoothing());
        prefs.putBoolean("Line Smoothing", AlcShape.isLineSmoothing());
        prefs.putBoolean("Simple ToolBar", this.simpleToolBar);
        prefs.putBoolean("Transparent Fullscreen", this.transparentFullscreen);
        prefs.putInt("Background Color", Alchemy.canvas.getBackgroundColor().getRGB());
        prefs.putInt("Color", Alchemy.canvas.getForegroundColor().getRGB());
        prefs.put("Export Directory", this.exportDirectory);
        if (this.switchVectorApp != null) {
            prefs.put("Switch Vector Application", this.switchVectorApp);
        }
        prefs.putInt("Switch Vector Format", this.switchVectorFormat);
        if (this.switchBitmapApp != null) {
            prefs.put("Switch Bitmap Application", this.switchBitmapApp);
        }
        if (this.paletteLocation != null) {
            prefs.put("Palette Location", AlcPreferences.pointToString(this.paletteLocation));
        }
        if (this.canvasLocation != null) {
            prefs.put("Canvas Location", AlcPreferences.pointToString(this.canvasLocation));
        }
        if (this.canvasSize != null) {
            prefs.put("Canvas Size", AlcPreferences.dimensionToString(this.canvasSize));
        }
    }

    private void removePreferences() {
        try {
            prefs.removeNode();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    private void resetPreferences() {
        try {
            prefs.removeNode();
            this.loadPreferences();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    private boolean exportPreferences(File file) {
        boolean result = false;
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            prefs.exportSubtree(outputStream);
            if (file.exists()) {
                if (file.canRead()) {
                    String dtd = "http://java.sun.com/dtd/preferences.dtd";
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    builder.setEntityResolver(new EntityResolver(){

                        public InputSource resolveEntity(String publicId, String systemId) {
                            if (systemId.equals("http://java.sun.com/dtd/preferences.dtd")) {
                                return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                            }
                            return null;
                        }
                    });
                    InputSource in = new InputSource(new FileInputStream(file));
                    Document doc = builder.parse(in);
                    Transformer tf = TransformerFactory.newInstance().newTransformer();
                    tf.setOutputProperty("indent", "yes");
                    tf.setOutputProperty("doctype-system", "http://java.sun.com/dtd/preferences.dtd");
                    tf.transform(new DOMSource(doc), new StreamResult(file));
                    System.out.println("Preferences saved to file.");
                    result = true;
                } else {
                    System.out.println("Error reading preferences file");
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error creating the preferences file");
            ex.printStackTrace();
        }
        return result;
    }

    private void resetModules(AlcModule[] modules) {
        for (int i = 0; i < modules.length; ++i) {
            AlcModule currentModule = modules[i];
            String moduleName = currentModule.getName();
            String moduleNodeName = "Module - " + moduleName;
            prefs.putBoolean(moduleNodeName, true);
        }
    }

    void setupWindow() {
        this.prefsWindow = this.getPrefsWindow();
        JPanel masterPanel = new JPanel();
        masterPanel.setLayout(null);
        masterPanel.add(this.getTabPanel());
        this.bgPanel = new JPanel();
        this.bgPanel.setOpaque(true);
        int bgPanelHeightOffset = 32;
        if (Alchemy.OS == 2) {
            bgPanelHeightOffset = 22;
        } else if (Alchemy.OS == 3) {
            bgPanelHeightOffset = 0;
        }
        int bgPanelWidthOffset = 0;
        if (Alchemy.OS == 1) {
            bgPanelWidthOffset = 4;
        }
        this.bgPanel.setBounds(0, 65, this.prefsWindowSize.width + bgPanelWidthOffset, this.prefsWindowSize.height - 65 - bgPanelHeightOffset);
        this.bgPanel.setLayout(new BorderLayout());
        this.bgPanel.setBackground(COLOR_UI_HIGHLIGHT);
        this.bgPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        masterPanel.add(this.bgPanel);
        this.generalPanel = this.getGeneralPanel();
        this.sessionPanel = this.getSessionPanel();
        this.bgPanel.add((Component)this.generalPanel, "First");
        this.prefsWindow.setTitle(Alchemy.bundle.getString("generalTitle"));
        this.bgPanel.add((Component)this.getButtonPanel(), "Last");
        this.prefsWindow.getContentPane().add(masterPanel);
        this.prefsWindow.pack();
    }

    void showWindow() {
        this.changeModules = false;
        Point loc = AlcUtil.calculateCenter(this.prefsWindow);
        this.prefsWindow.setLocation(loc.x, loc.y);
        this.prefsWindow.setVisible(true);
    }

    void hideWindow() {
        this.prefsWindow.setVisible(false);
        this.refreshModulePanel();
        this.sessionFileRenamePre.setText(this.sessionFilePreName);
        this.sessionFileRenameDate.setText(this.sessionFileDateFormat);
        this.sessionDirectoryTextField.setText(this.sessionPath);
        this.recordOnStartUp.setSelected(this.sessionRecordingState);
        if (Alchemy.preferences.simpleToolBar) {
            this.interfaceBox.setSelectedIndex(1);
        } else {
            this.interfaceBox.setSelectedIndex(0);
        }
        if (this.currentTab == 2) {
            this.bgPanel.remove(this.sessionPanel);
            this.bgPanel.add((Component)this.generalPanel, "First");
            this.prefsWindow.setTitle(Alchemy.bundle.getString("generalTitle"));
            this.currentTab = 1;
            this.generalTabButton.setSelected(true);
        }
    }

    private JDialog getPrefsWindow() {
        JDialog w = new JDialog((Frame)Alchemy.window, true);
        w.setPreferredSize(this.prefsWindowSize);
        w.setResizable(false);
        AlcUtil.registerWindowCloseKeys(w.getRootPane(), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlcPreferences.this.hideWindow();
            }
        });
        return w;
    }

    private JPanel getTabPanel() {
        JPanel tabPanel = new JPanel(){
            final Color unifiedLineColor = new Color(64, 64, 64);

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (g instanceof Graphics2D) {
                    Graphics2D g2 = (Graphics2D)g;
                    int targetWidth = this.getRootPane().getSize().width;
                    int heightMinusOne = 64;
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, AlcConstants.COLOR_UI_START, 0.0f, 65.0f, AlcConstants.COLOR_UI_END, true);
                    g2.setPaint(gradientPaint);
                    g2.fillRect(0, 0, targetWidth, 65);
                    g2.setPaint(AlcConstants.COLOR_UI_LINE);
                    g2.drawLine(0, heightMinusOne, targetWidth, heightMinusOne);
                }
            }
        };
        tabPanel.setOpaque(false);
        tabPanel.setBounds(0, 0, this.prefsWindowSize.width, 65);
        tabPanel.setLayout(new FlowLayout(0));
        ButtonGroup tabButtons = new ButtonGroup();
        this.generalTabButton = new AlcToggleButton(Alchemy.bundle.getString("generalTitle"), null, AlcUtil.getUrlPath("preferences-general.png"), true);
        this.generalTabButton.setSelected(true);
        this.generalTabButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AlcPreferences.this.currentTab == 2) {
                    AlcPreferences.this.bgPanel.remove(AlcPreferences.this.sessionPanel);
                    AlcPreferences.this.bgPanel.add((Component)AlcPreferences.this.generalPanel, "First");
                    AlcPreferences.this.prefsWindow.setTitle(Alchemy.bundle.getString("generalTitle"));
                    AlcPreferences.this.currentTab = 1;
                    AlcPreferences.this.bgPanel.revalidate();
                    AlcPreferences.this.bgPanel.repaint();
                }
            }
        });
        tabButtons.add(this.generalTabButton);
        tabPanel.add(this.generalTabButton);
        AlcToggleButton sessionTabButton = new AlcToggleButton(Alchemy.bundle.getString("sessionTitle"), null, AlcUtil.getUrlPath("preferences-session.png"), true);
        sessionTabButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AlcPreferences.this.currentTab == 1) {
                    AlcPreferences.this.bgPanel.remove(AlcPreferences.this.generalPanel);
                    AlcPreferences.this.bgPanel.add((Component)AlcPreferences.this.sessionPanel, "First");
                    AlcPreferences.this.prefsWindow.setTitle(Alchemy.bundle.getString("sessionTitle"));
                    AlcPreferences.this.currentTab = 2;
                    AlcPreferences.this.bgPanel.revalidate();
                    AlcPreferences.this.bgPanel.repaint();
                }
            }
        });
        tabButtons.add(sessionTabButton);
        tabPanel.add(sessionTabButton);
        return tabPanel;
    }

    private JPanel getGeneralPanel() {
        JPanel gp = new JPanel();
        gp.setOpaque(false);
        gp.setLayout(new BoxLayout(gp, 3));
        JPanel interfaceSelector = new JPanel(new FlowLayout(1, 2, 2));
        interfaceSelector.setOpaque(false);
        interfaceSelector.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        interfaceSelector.add(new JLabel(Alchemy.bundle.getString("interface") + ": "));
        String[] interfaceType = new String[]{Alchemy.bundle.getString("standard"), Alchemy.bundle.getString("simple")};
        this.interfaceBox = new JComboBox<String>(interfaceType);
        if (Alchemy.preferences.simpleToolBar) {
            this.interfaceBox.setSelectedIndex(1);
        } else {
            this.interfaceBox.setSelectedIndex(0);
        }
        interfaceSelector.add(this.interfaceBox);
        JLabel restart = new JLabel("* " + Alchemy.bundle.getString("restartRequired"));
        restart.setFont(new Font("sansserif", 0, 10));
        restart.setForeground(Color.GRAY);
        interfaceSelector.add(restart);
        gp.add(interfaceSelector);
        JPanel modulesLabelPanel = new JPanel(new FlowLayout(0));
        modulesLabelPanel.setOpaque(false);
        modulesLabelPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JLabel modulesLabel = new JLabel(Alchemy.bundle.getString("modules") + ":");
        modulesLabelPanel.setOpaque(false);
        modulesLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        modulesLabelPanel.add(modulesLabel);
        JLabel restart2 = new JLabel("* " + Alchemy.bundle.getString("restartRequired"));
        restart2.setFont(FONT_SMALL);
        restart2.setForeground(Color.GRAY);
        restart2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        modulesLabelPanel.add(restart2);
        gp.add(modulesLabelPanel);
        gp.add(this.getModulesPane());
        return gp;
    }

    private JScrollPane getModulesPane() {
        this.modulesPanel = this.getModulesPanel();
        this.scrollPane = new JScrollPane(this.modulesPanel, 22, 30);
        this.scrollPane.setPreferredSize(new Dimension(this.prefsWindowSize.width - 30, 230));
        return this.scrollPane;
    }

    private JPanel getModulesPanel() {
        JPanel mp = new JPanel();
        mp.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        mp.setBackground(COLOR_UI_START);
        int plugins = Alchemy.plugins.creates.length + Alchemy.plugins.affects.length;
        mp.setLayout(new GridLayout(plugins, 1, 5, 5));
        this.setupModules(Alchemy.plugins.creates, mp);
        this.setupModules(Alchemy.plugins.affects, mp);
        this.modulesSet = true;
        return mp;
    }

    private void refreshModulePanel() {
        this.generalPanel.remove(this.scrollPane);
        this.generalPanel.add(this.getModulesPane());
        this.generalPanel.revalidate();
    }

    private JPanel getSessionPanel() {
        JPanel sp = new JPanel();
        sp.setOpaque(false);
        sp.setLayout(new BoxLayout(sp, 2));
        sp.add(Box.createHorizontalGlue());
        JPanel leftPanel = new JPanel();
        leftPanel.setOpaque(false);
        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
        leftPanel.setAlignmentY(0.0f);
        if (Alchemy.OS != 2) {
            leftPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        JLabel sessionRecording = new JLabel(Alchemy.bundle.getString("sessionRecording") + ":");
        sessionRecording.setAlignmentX(1.0f);
        leftPanel.add(sessionRecording);
        leftPanel.add(Box.createRigidArea(new Dimension(0, 22)));
        JLabel sessionDirectory = new JLabel(Alchemy.bundle.getString("sessionDirectory") + ":");
        sessionDirectory.setAlignmentX(1.0f);
        leftPanel.add(sessionDirectory);
        leftPanel.add(Box.createRigidArea(new Dimension(0, 55)));
        JLabel sessionPDFName = new JLabel(Alchemy.bundle.getString("sessionPDFName") + ":");
        sessionPDFName.setAlignmentX(1.0f);
        leftPanel.add(sessionPDFName);
        sp.add(leftPanel);
        sp.add(Box.createRigidArea(new Dimension(10, 0)));
        JPanel rightPanel = new JPanel();
        rightPanel.setOpaque(false);
        rightPanel.setLayout(new BoxLayout(rightPanel, 3));
        rightPanel.setAlignmentY(0.0f);
        this.recordOnStartUp = new JCheckBox(Alchemy.bundle.getString("recordOnStartUp"));
        this.recordOnStartUp.setAlignmentX(0.0f);
        this.recordOnStartUp.setOpaque(false);
        this.recordOnStartUp.setSelected(this.sessionRecordingState);
        rightPanel.add(this.recordOnStartUp);
        rightPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        this.sessionDirectoryTextField = new JTextField(this.sessionPath);
        this.sessionDirectoryTextField.setMaximumSize(new Dimension(300, 30));
        this.sessionDirectoryTextField.setEnabled(false);
        this.sessionDirectoryTextField.setAlignmentX(0.0f);
        rightPanel.add(this.sessionDirectoryTextField);
        rightPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JButton selectButton = new JButton(Alchemy.bundle.getString("select") + "...");
        selectButton.setAlignmentX(0.0f);
        selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = AlcUtil.showFileChooser(true, AlcPreferences.this.prefsWindow);
                if (file != null) {
                    AlcPreferences.this.sessionDirectoryTextField.setText(file.getPath());
                }
            }
        });
        rightPanel.add(selectButton);
        rightPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        JPanel sessionFileRenamePanel = new JPanel(new FlowLayout(0, 0, 0));
        sessionFileRenamePanel.setOpaque(false);
        this.sessionFileRenamePre = new JTextField(this.sessionFilePreName);
        int textHeight = this.sessionFileRenamePre.getPreferredSize().height;
        this.sessionFileRenamePre.setPreferredSize(new Dimension(100, textHeight));
        this.sessionFileRenamePre.setFont(FONT_MEDIUM);
        AbstractAction pdfNameActionUpdate = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcPreferences.this.refreshSessionPDFNameOutput();
            }
        };
        FocusAdapter pdfNameFocusUpdate = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AlcPreferences.this.refreshSessionPDFNameOutput();
            }
        };
        this.sessionFileRenamePre.addActionListener(pdfNameActionUpdate);
        this.sessionFileRenamePre.addFocusListener(pdfNameFocusUpdate);
        sessionFileRenamePanel.add(this.sessionFileRenamePre);
        this.sessionFileRenameDate = new JTextField(this.sessionFileDateFormat);
        this.sessionFileRenameDate.setToolTipText(this.getDateStampReference());
        this.sessionFileRenameDate.setPreferredSize(new Dimension(160, textHeight));
        this.sessionFileRenameDate.setFont(FONT_MEDIUM);
        this.sessionFileRenameDate.addActionListener(pdfNameActionUpdate);
        this.sessionFileRenameDate.addFocusListener(pdfNameFocusUpdate);
        sessionFileRenamePanel.add(this.sessionFileRenameDate);
        JLabel sessionFileRenameExt = new JLabel(".pdf");
        sessionFileRenameExt.setFont(FONT_MEDIUM);
        sessionFileRenamePanel.add(sessionFileRenameExt);
        sessionFileRenamePanel.setAlignmentX(0.0f);
        rightPanel.add(sessionFileRenamePanel);
        rightPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.sessionFileRenameOutput = new JLabel(Alchemy.bundle.getString("example") + ": " + this.sessionFilePreName + AlcUtil.dateStamp(this.sessionFileDateFormat) + ".pdf");
        this.sessionFileRenameOutput.setFont(FONT_SMALL);
        this.sessionFileRenameOutput.setForeground(Color.GRAY);
        rightPanel.add(this.sessionFileRenameOutput);
        sp.add(rightPanel);
        sp.add(Box.createHorizontalGlue());
        return sp;
    }

    private void refreshSessionPDFNameOutput() {
        try {
            String dateStamp = AlcUtil.dateStamp(this.sessionFileRenameDate.getText());
            this.sessionFileRenameOutput.setText(Alchemy.bundle.getString("output") + ": " + this.sessionFileRenamePre.getText() + dateStamp + ".pdf");
        }
        catch (Exception ex) {
            this.invalidDateFormat();
        }
    }

    private JPanel getButtonPanel() {
        JButton defaultButton = new JButton(Alchemy.bundle.getString("restoreDefaults"));
        defaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlcPreferences.this.resetModules(Alchemy.plugins.creates);
                AlcPreferences.this.resetModules(Alchemy.plugins.affects);
                AlcPreferences.this.refreshModulePanel();
                AlcPreferences.this.sessionFilePreName = "Alchemy-";
                AlcPreferences.this.sessionFileDateFormat = "yyyy-MM-dd-HH-mm-ss";
                AlcPreferences.this.sessionFileRenamePre.setText(AlcPreferences.this.sessionFilePreName);
                AlcPreferences.this.sessionFileRenameDate.setText(AlcPreferences.this.sessionFileDateFormat);
                AlcPreferences.this.sessionPath = AlcConstants.DIR_DESKTOP;
                AlcPreferences.this.sessionDirectoryTextField.setText(AlcPreferences.this.sessionPath);
                AlcPreferences.this.sessionRecordingState = false;
                AlcPreferences.this.recordOnStartUp.setSelected(AlcPreferences.this.sessionRecordingState);
                AlcPreferences.this.interfaceBox.setSelectedIndex(0);
            }
        });
        JButton cancelButton = new JButton(Alchemy.bundle.getString("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlcPreferences.this.hideWindow();
            }
        });
        this.okButton = new JButton(Alchemy.bundle.getString("ok"));
        this.okButton.setMnemonic(10);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean restart = false;
                boolean bl = Alchemy.preferences.simpleToolBar = AlcPreferences.this.interfaceBox.getSelectedIndex() == 1;
                if (!AlcPreferences.this.sessionFileRenamePre.getText().equals(AlcPreferences.this.sessionFilePreName) || !AlcPreferences.this.sessionFileRenameDate.getText().equals(AlcPreferences.this.sessionFileDateFormat)) {
                    try {
                        String dateFormat = AlcUtil.dateStamp(AlcPreferences.this.sessionFileRenameDate.getText());
                        if (!AlcPreferences.this.sessionFileRenamePre.getText().equals("") && !dateFormat.equals("")) {
                            AlcPreferences.this.sessionFilePreName = AlcPreferences.this.sessionFileRenamePre.getText();
                            AlcPreferences.this.sessionFileDateFormat = AlcPreferences.this.sessionFileRenameDate.getText();
                            restart = true;
                        }
                    }
                    catch (Exception ex) {
                        AlcPreferences.this.invalidDateFormat();
                        return;
                    }
                }
                if (!AlcPreferences.this.sessionDirectoryTextField.getText().equals(AlcPreferences.this.sessionPath)) {
                    AlcPreferences.this.sessionPath = AlcPreferences.this.sessionDirectoryTextField.getText();
                    restart = true;
                }
                if (restart) {
                    Alchemy.session.restartSession();
                }
                if (AlcPreferences.this.sessionRecordingState != AlcPreferences.this.recordOnStartUp.isSelected()) {
                    AlcPreferences.this.sessionRecordingState = AlcPreferences.this.recordOnStartUp.isSelected();
                }
                AlcPreferences.this.prefsWindow.setVisible(false);
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        buttonPane.add(defaultButton);
        buttonPane.add(Box.createHorizontalGlue());
        if (Alchemy.OS == 2) {
            buttonPane.add(cancelButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(this.okButton);
        } else {
            buttonPane.add(this.okButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(cancelButton);
        }
        return buttonPane;
    }

    private void invalidDateFormat() {
        this.sessionFileRenameDate.setBackground(Color.PINK);
        this.sessionFileRenameDate.setText(Alchemy.bundle.getString("invalidDateFormat"));
        Timer timer = new Timer(1500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlcPreferences.this.sessionFileRenameDate.setBackground(Color.WHITE);
                AlcPreferences.this.sessionFileRenameDate.setText(AlcPreferences.this.sessionFileDateFormat);
            }
        });
        timer.start();
        timer.setRepeats(false);
    }

    private String getDateStampReference() {
        Date today = new Date();
        String[] dateFormats = new String[]{"EEEE, MMMM dd, yyyy", "hha '- Alchemy Time!'", "E, MMM d, yyyy", "yyyy.MM.dd 'at' HH.mm.ss"};
        String dates = "<html>" + Alchemy.bundle.getString("example") + ":<br>";
        for (int i = 0; i < dateFormats.length; ++i) {
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormats[i], LOCALE);
            dates = dates + dateFormats[i];
            dates = dates + " : ";
            dates = dates + "<font color=#333333>" + formatter.format(today) + "</font>";
            dates = dates + "<br>";
        }
        dates = dates + "</html>";
        return dates;
    }

    private void setupModules(AlcModule[] modules, JPanel panel) {
        for (int i = 0; i < modules.length; ++i) {
            AlcModule currentModule = modules[i];
            String moduleName = currentModule.getName();
            String moduleNodeName = "Module - " + moduleName;
            JCheckBox checkBox = new JCheckBox(moduleName);
            checkBox.setBackground(COLOR_UI_START);
            checkBox.setFont(FONT_MEDIUM);
            checkBox.setSelected(prefs.getBoolean(moduleNodeName, true));
            checkBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AlcPreferences.this.changeModules = true;
                }
            });
            panel.add(checkBox);
        }
    }

    private void changeModules() {
        if (this.changeModules) {
            Component[] components = this.modulesPanel.getComponents();
            int creates = Alchemy.plugins.getNumberOfCreateModules();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof JCheckBox)) continue;
                JCheckBox checkBox = (JCheckBox)components[i];
                String moduleName = i < creates ? Alchemy.plugins.creates[i].getName() : Alchemy.plugins.affects[i - creates].getName();
                String moduleNodeName = "Module - " + moduleName;
                prefs.putBoolean(moduleNodeName, checkBox.isSelected());
            }
        }
    }

    private static Point stringToPoint(String string) {
        if (string != null) {
            String[] splitString = string.split(",", 2);
            int x = new Integer(splitString[0]);
            int y = new Integer(splitString[1]);
            Point point = new Point(x, y);
            return point;
        }
        return null;
    }

    private static String pointToString(Point point) {
        if (point != null) {
            String x = String.valueOf(point.x);
            String y = String.valueOf(point.y);
            String xy = x + "," + y;
            return xy;
        }
        return null;
    }

    private static Dimension stringToDimension(String string) {
        if (string != null) {
            String[] splitString = string.split(",", 2);
            int width = new Integer(splitString[0]);
            int height = new Integer(splitString[1]);
            Dimension dimension = new Dimension(width, height);
            return dimension;
        }
        return null;
    }

    private static String dimensionToString(Dimension dimension) {
        if (dimension != null) {
            String width = String.valueOf(dimension.width);
            String height = String.valueOf(dimension.height);
            String widthHeight = width + "," + height;
            return widthHeight;
        }
        return null;
    }
}

