/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcPreferences;
import org.alchemy.core.AlcShortcutInterface;
import org.alchemy.core.AlcShortcutMapper;
import org.alchemy.core.AlcToolBar;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.AlcWindow;
import org.alchemy.core.Alchemy;

class AlcShortcuts
extends JDialog
implements AlcConstants {
    private ArrayList<AlcShortcutMapper> userShortcuts = new ArrayList(50);
    private ArrayList<AlcShortcutMapper> defaultShortcuts = new ArrayList(50);
    private JTextField[] textfields;
    private int index = 0;
    private boolean listenerActive = false;
    private JButton okButton;
    private boolean reloadShortcuts = false;
    private static final Font shortcutFont = new Font("sansserif", 0, 12);
    private JPanel shortcutPanel;

    AlcShortcuts(AlcWindow owner) {
        super(owner, Alchemy.bundle.getString("keyboardShortcutsWindowTitle"), true);
        this.setPreferredSize(new Dimension(400, 300));
    }

    void setupWindow() {
        this.refreshInterfaceElements();
        JPanel masterPanel = new JPanel();
        masterPanel.setLayout(new BoxLayout(masterPanel, 3));
        masterPanel.setOpaque(true);
        masterPanel.setBackground(AlcToolBar.COLOR_UI_HIGHLIGHT);
        masterPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.shortcutPanel = this.setupShortcutPanel();
        JScrollPane scrollPane = new JScrollPane(this.shortcutPanel);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setPreferredSize(new Dimension(500, 300));
        masterPanel.add(scrollPane);
        JButton defaultButton = new JButton(Alchemy.bundle.getString("restoreDefaults"));
        defaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlcShortcuts.this.userShortcuts = new ArrayList(AlcShortcuts.this.defaultShortcuts);
                AlcShortcuts.this.reloadShortcuts();
                AlcShortcuts.this.refreshTextfields();
                AlcShortcuts.this.okButton.requestFocus();
                AlcShortcuts.this.reloadShortcuts = true;
            }
        });
        JButton cancelButton = new JButton(Alchemy.bundle.getString("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlcShortcuts.this.setVisible(false);
            }
        });
        this.okButton = new JButton(Alchemy.bundle.getString("ok"));
        this.okButton.setMnemonic(10);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AlcShortcuts.this.reloadShortcuts) {
                    AlcShortcuts.this.reloadShortcuts();
                    AlcShortcuts.this.saveShortcuts();
                    AlcShortcuts.this.refreshInterfaceElements();
                }
                AlcShortcuts.this.reloadShortcuts = false;
                AlcShortcuts.this.setVisible(false);
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        buttonPane.add(defaultButton);
        buttonPane.add(Box.createHorizontalGlue());
        if (Alchemy.OS == 2) {
            buttonPane.add(cancelButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(this.okButton);
        } else {
            buttonPane.add(this.okButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(cancelButton);
        }
        masterPanel.add(buttonPane);
        AlcUtil.registerWindowCloseKeys(this.getRootPane(), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlcShortcuts.this.setVisible(false);
            }
        });
        this.getContentPane().add(masterPanel);
        this.pack();
    }

    void showWindow() {
        Point loc = AlcUtil.calculateCenter(this);
        this.setLocation(loc.x, loc.y);
        this.setVisible(true);
    }

    JPanel setupShortcutPanel() {
        this.textfields = new JTextField[this.userShortcuts.size()];
        JPanel panel = new JPanel();
        panel.setOpaque(true);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        panel.setBackground(AlcToolBar.COLOR_UI_START);
        panel.setLayout(new GridLayout(this.userShortcuts.size(), 2, 5, 5));
        for (int i = 0; i < this.userShortcuts.size(); ++i) {
            final AlcShortcutMapper shortcut = this.userShortcuts.get(i);
            JLabel label = new JLabel(shortcut.title);
            label.setFont(shortcutFont);
            panel.add(label);
            final String originalShortcut = AlcShortcuts.getShortcutString(shortcut.key, shortcut.modifier);
            final JTextField textfield = new JTextField(originalShortcut);
            textfield.setBackground(Color.WHITE);
            textfield.setFont(shortcutFont);
            textfield.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    AlcShortcuts.this.listenerActive = true;
                    textfield.setText("");
                    textfield.setBackground(AlcToolBar.COLOR_UI_BG);
                }
            });
            textfield.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (AlcShortcuts.this.listenerActive) {
                        int key = e.getKeyCode();
                        int modifier = e.getModifiers();
                        String shortcutString = AlcShortcuts.getShortcutString(key, modifier);
                        int changeShortcut = AlcShortcuts.this.validateShortcut(key, modifier, shortcut.index);
                        if (changeShortcut == 0) {
                            textfield.setText(shortcutString);
                            shortcut.key = key;
                            shortcut.modifier = modifier;
                            AlcShortcuts.this.reloadShortcuts = true;
                            textfield.setBackground(Color.WHITE);
                        } else {
                            textfield.setBackground(Color.PINK);
                            if (changeShortcut == 1) {
                                textfield.setText(Alchemy.bundle.getString("invalidKeyError"));
                            } else if (changeShortcut == 2) {
                                textfield.setText(Alchemy.bundle.getString("keyAlreadyAssignedError"));
                            }
                            Timer timer = new Timer(1500, new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    textfield.setBackground(Color.WHITE);
                                    textfield.setText(originalShortcut);
                                }
                            });
                            timer.start();
                            timer.setRepeats(false);
                        }
                        AlcShortcuts.this.listenerActive = false;
                        AlcShortcuts.this.okButton.requestFocus();
                    }
                }
            });
            textfield.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (textfield.getText().equals("")) {
                        textfield.setText(originalShortcut);
                        textfield.setBackground(Color.WHITE);
                    }
                }
            });
            this.textfields[i] = textfield;
            panel.add(textfield);
        }
        return panel;
    }

    private int validateShortcut(int key, int modifier, int index) {
        if (modifier == 0 && (key == 157 || key == 18 || key == 17 || key == 16)) {
            return 1;
        }
        for (int i = 0; i < this.userShortcuts.size(); ++i) {
            AlcShortcutMapper shortcut = this.userShortcuts.get(i);
            if (i == index || shortcut.modifier != modifier || shortcut.key != key) continue;
            return 2;
        }
        return 0;
    }

    private void refreshTextfields() {
        for (int i = 0; i < this.textfields.length; ++i) {
            AlcShortcutMapper shortcut = this.userShortcuts.get(i);
            String shortcutString = AlcShortcuts.getShortcutString(shortcut.key, shortcut.modifier);
            this.textfields[i].setText(shortcutString);
            this.textfields[i].setBackground(Color.WHITE);
        }
    }

    int setShortcut(JComponent component, int key, String title, Action action) {
        return this.setShortcut(component, key, title, action, 0);
    }

    int setShortcut(JComponent component, int key, String title, Action action, int modifier) {
        String bundleTitleEn;
        String bundleTitle;
        try {
            bundleTitle = Alchemy.bundle.getString(title);
            bundleTitleEn = Alchemy.bundleEn.getString(title);
        }
        catch (Exception e) {
            bundleTitle = title;
            bundleTitleEn = title;
        }
        this.defaultShortcuts.add(new AlcShortcutMapper(component, this.index, key, bundleTitle, bundleTitleEn, action, modifier));
        int userKey = AlcPreferences.prefs.getInt(bundleTitleEn, key);
        int modifierKey = AlcPreferences.prefs.getInt(bundleTitleEn + " Modifier", modifier);
        this.userShortcuts.add(new AlcShortcutMapper(component, this.index, userKey, bundleTitle, bundleTitleEn, action, modifierKey));
        ++this.index;
        Alchemy.window.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(userKey, modifierKey), bundleTitleEn);
        Alchemy.palette.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(userKey, modifierKey), bundleTitleEn);
        Alchemy.window.getRootPane().getActionMap().put(bundleTitleEn, action);
        Alchemy.palette.getRootPane().getActionMap().put(bundleTitleEn, action);
        return userKey;
    }

    private void reloadShortcuts() {
        Alchemy.window.getRootPane().resetKeyboardActions();
        Alchemy.palette.getRootPane().resetKeyboardActions();
        for (int i = 0; i < this.userShortcuts.size(); ++i) {
            AlcShortcutMapper shortcut = this.userShortcuts.get(i);
            Alchemy.window.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(shortcut.key, shortcut.modifier), shortcut.titleEn);
            Alchemy.palette.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(shortcut.key, shortcut.modifier), shortcut.titleEn);
            Alchemy.window.getRootPane().getActionMap().put(shortcut.titleEn, shortcut.action);
            Alchemy.palette.getRootPane().getActionMap().put(shortcut.titleEn, shortcut.action);
        }
    }

    private void saveShortcuts() {
        for (int i = 0; i < this.userShortcuts.size(); ++i) {
            AlcShortcutMapper shortcut = this.userShortcuts.get(i);
            AlcPreferences.prefs.putInt(shortcut.titleEn, shortcut.key);
            AlcPreferences.prefs.putInt(shortcut.titleEn + " Modifier", shortcut.modifier);
        }
    }

    private void refreshInterfaceElements() {
        for (int i = 0; i < this.userShortcuts.size(); ++i) {
            AlcShortcutMapper shortcut = this.userShortcuts.get(i);
            if (shortcut.component == null || !(shortcut.component instanceof AlcShortcutInterface)) continue;
            AlcShortcutInterface shortcutComponent = (AlcShortcutInterface)((Object)shortcut.component);
            shortcutComponent.refreshShortcut(shortcut.key, shortcut.modifier);
        }
    }

    static String getShortcutString(int key, int modifier) {
        String keyText = KeyEvent.getKeyText(key).toUpperCase();
        String keyModifier = KeyEvent.getKeyModifiersText(modifier);
        if (Alchemy.OS == 2) {
            switch (modifier) {
                case 4: {
                    keyModifier = Alchemy.KEY_MODIFIER_STRING;
                    break;
                }
                case 1: {
                    keyModifier = Alchemy.KEY_SHIFT_STRING;
                    break;
                }
                case 8: {
                    keyModifier = Alchemy.KEY_ALT_STRING;
                }
            }
            if (key == 32) {
                keyText = "SPACE";
            }
        }
        if (modifier > 0) {
            keyModifier = keyModifier + "+";
        }
        return keyModifier + keyText;
    }

    static String getShortcutString(int key, int modifier, String title) {
        return title + " (" + AlcShortcuts.getShortcutString(key, modifier) + ")";
    }
}

