/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import com.sun.pdfview.PDFCmd;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFRenderer;
import com.sun.pdfview.PDFShapeCmd;
import eu.medsea.util.MimeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcFileChooser;
import org.alchemy.core.AlcShape;
import org.alchemy.core.Alchemy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlcUtil
implements AlcConstants {
    private static final Clipboard CLIPBOARD = TOOLKIT.getSystemClipboard();
    static String openLauncher;

    public static File addFileExtension(File file, String ext) {
        String filePath = file.getPath();
        if (filePath.endsWith("." + ext)) {
            return file;
        }
        if (!filePath.endsWith(".")) {
            filePath = filePath + ".";
        }
        System.out.println(filePath + ext);
        return new File(filePath + ext);
    }

    public static String getClassName(Object object) {
        String classString = object.getClass().getName();
        int dotIndex = classString.lastIndexOf(".");
        return classString.substring(dotIndex + 1);
    }

    public static URL appendStringToUrl(URL url, String append) {
        String urlString = url.toString();
        URL newUrl = null;
        int dot = url.toString().lastIndexOf(".");
        if (dot == -1) {
            try {
                newUrl = new URL(urlString + append);
            }
            catch (MalformedURLException ex) {
                System.err.println(ex);
            }
        } else {
            try {
                newUrl = new URL(urlString.substring(0, dot) + append + urlString.substring(dot));
            }
            catch (MalformedURLException ex) {
                System.err.println(ex);
            }
        }
        return newUrl;
    }

    public static String dateStamp(String format) throws IllegalArgumentException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, LOCALE);
        Date today = new Date();
        return formatter.format(today);
    }

    public static String zeroPad(int i, int len) {
        String s = Integer.toString(i);
        if (s.length() > len) {
            return s.substring(0, len);
        }
        if (s.length() < len) {
            return "000000000000000000000000000".substring(0, len - s.length()) + s;
        }
        return s;
    }

    public static URL getUrlPath(String path) {
        return AlcUtil.getUrlPath(path, null);
    }

    public static URL getUrlPath(String path, ClassLoader classLoader) {
        URL resourceUrl = null;
        resourceUrl = classLoader == null ? Alchemy.class.getResource("/org/alchemy/data/" + path) : classLoader.getResource(path);
        if (resourceUrl != null) {
            return resourceUrl;
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static ImageIcon getImageIcon(String name) {
        URL imgUrl = Alchemy.class.getResource("/org/alchemy/data/" + name);
        if (imgUrl != null) {
            return AlcUtil.getImageIcon(imgUrl);
        }
        System.err.println("Couldn't find file: " + name);
        return null;
    }

    public static ImageIcon getImageIcon(URL imgUrl) {
        ImageIcon icon;
        if (imgUrl != null && (icon = new ImageIcon(imgUrl)).getIconWidth() > 0) {
            return icon;
        }
        return null;
    }

    public static Image getImage(String name) {
        URL imgUrl = Alchemy.class.getResource("/org/alchemy/data/" + name);
        if (imgUrl != null) {
            return AlcUtil.getImageIcon(imgUrl).getImage();
        }
        System.err.println("Couldn't find file: " + name);
        return null;
    }

    public static Image getImage(URL imgUrl) {
        ImageIcon icon;
        if (imgUrl != null && (icon = new ImageIcon(imgUrl)).getIconWidth() > 0) {
            return icon.getImage();
        }
        return null;
    }

    public static BufferedImage getBufferedImage(URL imgUrl) {
        Image image = AlcUtil.getImage(imgUrl);
        if (image != null) {
            return AlcUtil.getBufferedImage(image);
        }
        return null;
    }

    public static BufferedImage getBufferedImage(String name) {
        Image image = AlcUtil.getImage(name);
        if (image != null) {
            return AlcUtil.getBufferedImage(image);
        }
        return null;
    }

    public static BufferedImage getBufferedImage(Image image) {
        if (image != null) {
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D g2 = bufferedImage.createGraphics();
            g2.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
            g2.dispose();
            return bufferedImage;
        }
        return null;
    }

    public static Cursor getCursor(String name) {
        Cursor customCursor;
        Image smallCursor = AlcUtil.getImage(name);
        if (smallCursor == null) {
            return Cursor.getDefaultCursor();
        }
        Dimension smallCursorSize = new Dimension(smallCursor.getWidth(null), smallCursor.getHeight(null));
        Dimension cursorSize = TOOLKIT.getBestCursorSize(smallCursorSize.width, smallCursorSize.height);
        if (cursorSize.equals(smallCursorSize) || cursorSize.width <= 0 || cursorSize.height <= 0) {
            customCursor = TOOLKIT.createCustomCursor(smallCursor, new Point(smallCursorSize.width / 2, smallCursorSize.height / 2), "CustomCursor");
        } else {
            int leftGap = (cursorSize.width - smallCursorSize.width) / 2;
            int topGap = (cursorSize.height - smallCursorSize.height) / 2;
            BufferedImage bigCursor = new BufferedImage(cursorSize.width, cursorSize.height, 2);
            Graphics2D g2 = bigCursor.createGraphics();
            g2.drawImage(smallCursor, leftGap, topGap, null);
            g2.dispose();
            customCursor = TOOLKIT.createCustomCursor(bigCursor, new Point(cursorSize.width / 2, cursorSize.height / 2), "CustomCursor");
        }
        return customCursor;
    }

    public static AlcShape[] getShapes() {
        ArrayList<AlcShape> shapes = new ArrayList<AlcShape>();
        File shapesDir = new File("shapes");
        FilenameFilter pdfFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                String mime = MimeUtil.getMimeType(file.getAbsoluteFile());
                return mime.equals("application/pdf");
            }
        };
        File[] pdfs = AlcUtil.listFilesAsArray(shapesDir, pdfFilter, true);
        for (int i = 0; i < pdfs.length; ++i) {
            shapes.addAll(AlcUtil.getPDFShapes(pdfs[i], true));
        }
        if (shapes.size() > 0) {
            AlcShape[] arr = new AlcShape[shapes.size()];
            return shapes.toArray(arr);
        }
        AlcUtil.showNoShapesDialog();
        return null;
    }

    public static void showNoShapesDialog() {
        String message = Alchemy.bundle.getString("noShapesMessage1") + "<br>" + Alchemy.preferences.shapesPath + "<br>" + Alchemy.bundle.getString("noShapesMessage2");
        AlcUtil.showConfirmDialog(Alchemy.bundle.getString("noShapesTitle"), message);
    }

    public static AlcShape[] getPDFShapesAsArray(File file, boolean resetLocation) {
        Collection<AlcShape> shapes = AlcUtil.getPDFShapes(file, resetLocation);
        if (shapes != null) {
            AlcShape[] arr = new AlcShape[shapes.size()];
            return shapes.toArray(arr);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<AlcShape> getPDFShapes(File file, boolean resetLocation) {
        PDFFile pdfFile = null;
        PDFPage pdfPage = null;
        int totalPages = 0;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            FileChannel channel = raf.getChannel();
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            pdfFile = new PDFFile(buf);
            totalPages = pdfFile.getNumPages();
        }
        catch (Exception ex) {
            System.err.println("Failed to load file");
            ex.printStackTrace();
            return null;
        }
        ArrayList<AlcShape> shapeList = new ArrayList<AlcShape>(totalPages * 10);
        for (int p = 0; p < totalPages; ++p) {
            pdfPage = pdfFile.getPage(p);
            int size = 1;
            BufferedImage buffImage = new BufferedImage(size, size, 2);
            Graphics2D g2 = buffImage.createGraphics();
            PDFRenderer renderer = new PDFRenderer(pdfPage, g2, new Rectangle(0, 0, size, size), null, null);
            Rectangle pageBounds = new Rectangle(0, 0, (int)pdfPage.getWidth(), (int)pdfPage.getHeight());
            try {
                pdfPage.waitForFinish();
                renderer.run();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            int totalCommands = pdfPage.getCommandCount();
            try {
                for (int c = 0; c < totalCommands; ++c) {
                    PDFCmd command = pdfPage.getCommand(c);
                    if (!(command instanceof PDFShapeCmd)) continue;
                    PDFShapeCmd shapeCommand = (PDFShapeCmd)command;
                    Class<?> shapeClass = shapeCommand.getClass();
                    Field pathField = shapeClass.getDeclaredField("gp");
                    pathField.setAccessible(true);
                    GeneralPath gp = (GeneralPath)pathField.get(shapeCommand);
                    Rectangle gpBounds = gp.getBounds();
                    Field styleField = shapeClass.getDeclaredField("style");
                    styleField.setAccessible(true);
                    int style = (Integer)styleField.get(shapeCommand);
                    if (style == 4 || gpBounds.width >= pageBounds.width || gpBounds.height >= pageBounds.height || pageBounds.equals(gpBounds)) continue;
                    AffineTransform verticalReflection = new AffineTransform();
                    int axis = gpBounds.y * 2 + gpBounds.height;
                    if (resetLocation) {
                        verticalReflection.translate(0 - gpBounds.x, axis - gpBounds.y);
                    } else {
                        verticalReflection.translate(0.0, axis);
                    }
                    verticalReflection.scale(1.0, -1.0);
                    GeneralPath reflectedPath = (GeneralPath)gp.createTransformedShape(verticalReflection);
                    AlcShape shape = new AlcShape(reflectedPath);
                    shape.recalculateTotalPoints();
                    if (style == 3) {
                        shape.setStyle(2);
                    } else {
                        shape.setStyle(style);
                    }
                    shapeList.add(shape);
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Collection<AlcShape> collection = null;
                return collection;
            }
            finally {
                g2.dispose();
            }
        }
        if (shapeList.size() > 0) {
            return shapeList;
        }
        return null;
    }

    public static void copyFile(InputStream in, File dst) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static File[] listFilesAsArray(File directory, FilenameFilter filter, boolean recurse) {
        Collection<File> files = AlcUtil.listFiles(directory, filter, recurse);
        File[] arr = new File[files.size()];
        return files.toArray(arr);
    }

    private static Collection<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries;
        ArrayList<File> files = new ArrayList<File>();
        for (File entry : entries = directory.listFiles()) {
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(AlcUtil.listFiles(entry, filter, recurse));
        }
        return files;
    }

    public static Point calculateCenter(Container popup) {
        return AlcUtil.calculateCenter(popup, false);
    }

    public static Point calculateCenter(Container popup, boolean palette) {
        GraphicsConfiguration grapConfig = popup.getGraphicsConfiguration();
        Rectangle mainWindowBounds = grapConfig.getBounds();
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Rectangle popupBounds = popup.getBounds();
        Rectangle parentBounds = Alchemy.window.getBounds();
        if (palette && Alchemy.preferences.paletteAttached) {
            parentBounds = Alchemy.palette.getBounds();
        }
        Rectangle windowBounds = null;
        if (devices.length > 1) {
            for (int i = 0; i < devices.length; ++i) {
                Rectangle screenBounds = devices[i].getDefaultConfiguration().getBounds();
                if (!screenBounds.contains(parentBounds.x + parentBounds.width / 2, parentBounds.y + parentBounds.height / 2)) continue;
                windowBounds = screenBounds;
            }
        }
        if (windowBounds == null) {
            windowBounds = mainWindowBounds;
        }
        int x = windowBounds.x + (windowBounds.width - popupBounds.width) / 2;
        int y = windowBounds.y + (windowBounds.height - popupBounds.height) / 2;
        Point center = new Point(x, y);
        return center;
    }

    public static void openURL(String url) {
        String errMsg = "Error attempting to launch web browser";
        try {
            if (Alchemy.OS == 2) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (Alchemy.OS == 1) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else if (Alchemy.OS == 3) {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            System.err.println("Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }

    public static void openPDF(File pdf) {
        block12: {
            String errMsg = "Error attempting to launch pdf";
            try {
                Process p;
                if (Alchemy.OS == 2) {
                    Runtime.getRuntime().exec("open " + pdf.getAbsolutePath());
                    break block12;
                }
                if (Alchemy.OS == 1) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + pdf.getAbsolutePath());
                    break block12;
                }
                if (Alchemy.OS != 3) break block12;
                if (openLauncher == null) {
                    try {
                        p = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                        p.waitFor();
                        openLauncher = "gnome-open";
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (openLauncher == null) {
                    try {
                        p = Runtime.getRuntime().exec(new String[]{"kde-open"});
                        p.waitFor();
                        openLauncher = "kde-open";
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (openLauncher == null) {
                    System.err.println("Could not find gnome-open or kde-open, the command may not work.");
                }
                if (openLauncher != null) {
                    Runtime.getRuntime().exec(openLauncher + " " + pdf.getAbsolutePath());
                }
            }
            catch (Exception e) {
                System.err.println("Error attempting to launch pdf:\n" + e.getLocalizedMessage());
            }
        }
    }

    public static boolean setClipboard(Transferable contents, ClipboardOwner owner) {
        boolean result = true;
        try {
            CLIPBOARD.setContents(contents, owner);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static boolean showConfirmDialog(String title, String message) {
        int result;
        if (Alchemy.OS == 2) {
            message = "<html>" + UIManager.get("OptionPane.css") + "<b>" + title + "</b>" + "<p>" + message;
            title = "";
        }
        return (result = JOptionPane.showOptionDialog(Alchemy.window, message, title, 2, 3, null, null, null)) == 0;
    }

    public static boolean showConfirmDialogFromBundle(String title, String message) {
        String bundleTitle = Alchemy.bundle.getString(title);
        String bundleMessage = Alchemy.bundle.getString(message);
        return AlcUtil.showConfirmDialog(bundleTitle, bundleMessage);
    }

    public static boolean showConfirmDialog(String winTitle, String winMessage, String macTitle, String macMessage) {
        if (Alchemy.OS == 2) {
            return AlcUtil.showConfirmDialog(macTitle, macMessage);
        }
        return AlcUtil.showConfirmDialog(winTitle, winMessage);
    }

    public static boolean showConfirmDialogFromBundle(String winTitle, String winMessage, String macTitle, String macMessage) {
        if (Alchemy.OS == 2) {
            return AlcUtil.showConfirmDialogFromBundle(macTitle, macMessage);
        }
        return AlcUtil.showConfirmDialogFromBundle(winTitle, winMessage);
    }

    public static File showFileChooser() {
        return AlcUtil.showFileChooser(null, null, false, null);
    }

    public static File showFileChooser(String title) {
        return AlcUtil.showFileChooser(title, null, false, null);
    }

    public static File showFileChooser(File defaultDir) {
        return AlcUtil.showFileChooser(null, defaultDir, false, null);
    }

    public static File showFileChooser(boolean foldersOnly) {
        return AlcUtil.showFileChooser(null, null, foldersOnly, null);
    }

    public static File showFileChooser(boolean foldersOnly, Component parent) {
        return AlcUtil.showFileChooser(null, null, foldersOnly, parent);
    }

    public static File showFileChooser(File defaultDir, boolean foldersOnly) {
        return AlcUtil.showFileChooser(null, defaultDir, foldersOnly, null);
    }

    public static File showFileChooser(String title, boolean foldersOnly) {
        return AlcUtil.showFileChooser(title, null, foldersOnly, null);
    }

    public static File showFileChooser(String title, File defaultDir) {
        return AlcUtil.showFileChooser(title, defaultDir, false, null);
    }

    public static File showFileChooser(String title, File defaultDir, boolean foldersOnly, Component parent) {
        int returnVal;
        AlcFileChooser fc = null;
        fc = defaultDir != null && defaultDir.exists() ? new AlcFileChooser(defaultDir) : new AlcFileChooser();
        if (foldersOnly) {
            fc.setFileSelectionMode(1);
        }
        if (title != null) {
            fc.setDialogTitle(title);
        }
        int n = returnVal = parent == null ? fc.showOpenDialog(Alchemy.window) : fc.showOpenDialog(parent);
        if (returnVal == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static void registerWindowCloseKeys(JRootPane root, Action closeAction) {
        root.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Close Window");
        root.getInputMap(2).put(KeyStroke.getKeyStroke(87, KEY_MODIFIER), "Close Window");
        root.getActionMap().put("Close Window", closeAction);
    }

    public static void drawSoftRect(Graphics g, int x, int y, int width, int height) {
        g.setColor(COLOR_UI_LINE_ALPHA);
        g.drawLine(x, y, x, y);
        g.drawLine(x + width - 1, y, x + width - 1, y);
        g.drawLine(x, y + height - 1, x, y + height - 1);
        g.drawLine(x + width - 1, y + height - 1, x + width - 1, y + height - 1);
        g.setColor(COLOR_UI_LINE);
        g.drawLine(x + 1, y, x + width - 2, y);
        g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 2);
        g.drawLine(x + width - 2, y + height - 1, x + 1, y + height - 1);
        g.drawLine(x, y + height - 2, x, y + 1);
    }

    public static int getColorBrightness(int rgb) {
        int oldR = rgb >>> 16 & 0xFF;
        int oldG = rgb >>> 8 & 0xFF;
        int oldB = rgb >>> 0 & 0xFF;
        return (222 * oldR + 707 * oldG + 71 * oldB) / 1000;
    }

    public static String hex(byte i) {
        return AlcUtil.hex(i, 2);
    }

    public static String hex(char c) {
        return AlcUtil.hex(c, 4);
    }

    public static String hex(int i) {
        return AlcUtil.hex(i, 8);
    }

    public static String hex(int i, int digits) {
        String stuff = Integer.toHexString(i).toUpperCase();
        int length = stuff.length();
        if (length > digits) {
            return stuff.substring(length - digits);
        }
        if (length < digits) {
            return "00000000".substring(8 - (digits - length)) + stuff;
        }
        return stuff;
    }

    public static int unhex(String s) {
        return (int)Long.parseLong(s, 16);
    }

    public static void printFloatArray(float[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.println("Array [" + String.valueOf(i) + "] = " + String.valueOf(array[i]));
        }
    }

    public static void printStringArray(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.println("Array [" + String.valueOf(i) + "] = " + array[i]);
        }
    }
}

