/** @file oyConnectorImaging_s_.c

   [Template file inheritance graph]
   +-> oyConnectorImaging_s_.template.c
   |
   +-> oyConnector_s_.template.c
   |
   +-- Base_s_.c

 *  Oyranos is an open source Colour Management System
 *
 *  @par Copyright:
 *            2004-2012 (C) Kai-Uwe Behrmann
 *
 *  @author   Kai-Uwe Behrmann <ku.b@gmx.de>
 *  @par License:
 *            new BSD - see: http://www.opensource.org/licenses/bsd-license.php
 *  @date     2012/10/24
 */



  
#include "oyConnectorImaging_s.h"
#include "oyConnectorImaging_s_.h"


#include "oyConnector_s_.h"




#include "oyObject_s.h"
#include "oyranos_object_internal.h"


  


/* Include "ConnectorImaging.private_custom_definitions.c" { */
/** Function    oyConnectorImaging_Release__Members
 *  @memberof   oyConnectorImaging_s
 *  @brief      Custom ConnectorImaging destructor
 *  @internal
 *
 *  This function will free up all memmory allocated by the
 *  input object. First all object members witch have their
 *  own release method are deallocated. Then the deallocateFunc_
 *  of the oy_ object is used to release the rest of the members
 *  that were allocated with oy_->allocateFunc_.
 *
 *  @param[in]  connectorimaging  the ConnectorImaging object
 *
 *  @version Oyranos: x.x.x
 *  @since   YYYY/MM/DD (Oyranos: x.x.x)
 *  @date    YYYY/MM/DD
 */
void oyConnectorImaging_Release__Members( oyConnectorImaging_s_ * connectorimaging )
{
  /* Deallocate members here
   * E.g: oyXXX_Release( &connectorimaging->member );
   */

  if(connectorimaging->oy_->deallocateFunc_)
  {
    oyDeAlloc_f deallocateFunc = connectorimaging->oy_->deallocateFunc_;

    /* Deallocate members of basic type here
     * E.g.: deallocateFunc( connectorimaging->member );
     */
    if(connectorimaging->data_types)
      deallocateFunc( connectorimaging->data_types );
    connectorimaging->data_types = 0;
    connectorimaging->data_types_n = 0;

    if(connectorimaging->channel_types)
      deallocateFunc( connectorimaging->channel_types );
    connectorimaging->channel_types = 0;
    connectorimaging->channel_types_n = 0;
  }
}

/** Function    oyConnectorImaging_Init__Members
 *  @memberof   oyConnectorImaging_s
 *  @brief      Custom ConnectorImaging constructor 
 *  @internal
 *
 *  This function will allocate all memmory for the input object.
 *  For the basic member types this is done using the allocateFunc_
 *  of the attatced (oyObject_s)oy_ object.
 *
 *  @param[in]  connectorimaging  the ConnectorImaging object
 *
 *  @version Oyranos: x.x.x
 *  @since   YYYY/MM/DD (Oyranos: x.x.x)
 *  @date    YYYY/MM/DD
 */
int oyConnectorImaging_Init__Members( oyConnectorImaging_s_ * connectorimaging )
{
  connectorimaging->max_colour_offset = -1;
  connectorimaging->min_channels_count = -1;
  connectorimaging->max_channels_count = -1;
  connectorimaging->min_colour_count = -1;
  connectorimaging->max_colour_count = -1;
  connectorimaging->can_planar = -1;
  connectorimaging->can_interwoven = -1;
  connectorimaging->can_swap = -1;
  connectorimaging->can_swap_bytes = -1;
  connectorimaging->can_revert = -1;
  connectorimaging->can_premultiplied_alpha = -1;
  connectorimaging->can_nonpremultiplied_alpha = -1;
  connectorimaging->can_subpixel = -1;

  return 0;
}

/** Function    oyConnectorImaging_Copy__Members
 *  @memberof   oyConnectorImaging_s
 *  @brief      Custom ConnectorImaging copy constructor
 *  @internal
 *
 *  This function makes a copy of all values from the input
 *  to the output object. The destination object and all of its
 *  members should already be allocated.
 *
 *  @param[in]   src  the oyConnectorImaging_s_ input object
 *  @param[out]  dst  the output oyConnectorImaging_s_ object
 *
 *  @version Oyranos: x.x.x
 *  @since   YYYY/MM/DD (Oyranos: x.x.x)
 *  @date    YYYY/MM/DD
 */
int oyConnectorImaging_Copy__Members( oyConnectorImaging_s_ * dst, oyConnectorImaging_s_ * src)
{
  int error = 0;
  oyAlloc_f allocateFunc_ = 0;
#if 0
  oyDeAlloc_f deallocateFunc_ = 0;
#endif

  if(!dst || !src)
    return 1;

  allocateFunc_ = dst->oy_->allocateFunc_;
#if 0
  deallocateFunc_ = dst->oy_->deallocateFunc_;
#endif

  /* Copy each value of src to dst here */
  if(src->data_types_n)
  {
    dst->data_types = allocateFunc_( src->data_types_n * sizeof(oyDATATYPE_e) );
    error = !dst->data_types;
    if(!error)
      error = !memcpy( dst->data_types, src->data_types,
                       src->data_types_n * sizeof(oyDATATYPE_e) );
    if(error <= 0)
      dst->data_types_n = src->data_types_n;
  }

  dst->max_colour_offset = src->max_colour_offset;
  dst->min_channels_count = src->min_channels_count;
  dst->max_channels_count = src->max_channels_count;
  dst->min_colour_count = src->min_colour_count;
  dst->max_colour_count = src->max_colour_count;
  dst->can_planar = src->can_planar;
  dst->can_interwoven = src->can_interwoven;
  dst->can_swap = src->can_swap;
  dst->can_swap_bytes = src->can_swap_bytes;
  dst->can_revert = src->can_revert;
  dst->can_premultiplied_alpha = src->can_premultiplied_alpha;
  dst->can_nonpremultiplied_alpha = src->can_nonpremultiplied_alpha;
  dst->can_subpixel = src->can_subpixel;

  if(src->channel_types_n)
  {
    int n = src->channel_types_n;

    dst->channel_types = allocateFunc_( n * sizeof(oyCHANNELTYPE_e) );
    error = !dst->channel_types;
    if(!error)
      error = !memcpy( dst->channel_types, src->channel_types,
                       n * sizeof(oyCHANNELTYPE_e) );
    if(error <= 0)
      dst->channel_types_n = n;
  }

  dst->is_mandatory = src->is_mandatory;

  return error;
}

/* } Include "ConnectorImaging.private_custom_definitions.c" */



/** @internal
 *  Function oyConnectorImaging_New_
 *  @memberof oyConnectorImaging_s_
 *  @brief   allocate a new oyConnectorImaging_s_  object
 *
 *  @version Oyranos: 
 *  @since   2010/04/26 (Oyranos: 0.1.10)
 *  @date    2010/04/26
 */
oyConnectorImaging_s_ * oyConnectorImaging_New_ ( oyObject_s object )
{
  /* ---- start of common object constructor ----- */
  oyOBJECT_e type = oyOBJECT_CONNECTOR_IMAGING_S;
  int error = 0;
  oyObject_s    s_obj = oyObject_NewFrom( object );
  oyConnectorImaging_s_ * s = 0;

  if(s_obj)
    s = (oyConnectorImaging_s_*)s_obj->allocateFunc_(sizeof(oyConnectorImaging_s_));

  if(!s || !s_obj)
  {
    WARNc_S(_("MEM Error."));
    return NULL;
  }

  error = !memset( s, 0, sizeof(oyConnectorImaging_s_) );
  if(error)
    WARNc_S( "memset failed" );

  s->type_ = type;
  s->copy = (oyStruct_Copy_f) oyConnectorImaging_Copy;
  s->release = (oyStruct_Release_f) oyConnectorImaging_Release;

  s->oy_ = s_obj;

  
  
  /* ---- start of custom Connector constructor ----- */
  error += !oyObject_SetParent( s_obj, oyOBJECT_CONNECTOR_S, (oyPointer)s );
  /* ---- end of custom Connector constructor ------- */
  /* ---- start of custom ConnectorImaging constructor ----- */
  error += !oyObject_SetParent( s_obj, oyOBJECT_CONNECTOR_IMAGING_S, (oyPointer)s );
  /* ---- end of custom ConnectorImaging constructor ------- */
  
  
  
  /* ---- end of common object constructor ------- */
  if(error)
    WARNc_S( "oyObject_SetParent failed" );


  
  

  
  
  /* ---- start of custom Connector constructor ----- */
  error += oyConnector_Init__Members( (oyConnector_s_*)s );
  /* ---- end of custom Connector constructor ------- */
  /* ---- start of custom ConnectorImaging constructor ----- */
  error += oyConnectorImaging_Init__Members( s );
  /* ---- end of custom ConnectorImaging constructor ------- */
  
  
  

  if(error)
    WARNc1_S("%d", error);

  return s;
}

/** @internal
 *  Function oyConnectorImaging_Copy__
 *  @memberof oyConnectorImaging_s_
 *  @brief   real copy a ConnectorImaging object
 *
 *  @param[in]     connectorimaging                 ConnectorImaging struct object
 *  @param         object              the optional object
 *
 *  @version Oyranos: 
 *  @since   2010/04/26 (Oyranos: 0.1.10)
 *  @date    2010/04/26
 */
oyConnectorImaging_s_ * oyConnectorImaging_Copy__ ( oyConnectorImaging_s_ *connectorimaging, oyObject_s object )
{
  oyConnectorImaging_s_ *s = 0;
  int error = 0;

  if(!connectorimaging || !object)
    return s;

  s = (oyConnectorImaging_s_*) oyConnectorImaging_New( object );
  error = !s;

  if(!error) {
    
    
    /* ---- start of custom Connector copy constructor ----- */
    error = oyConnector_Copy__Members( (oyConnector_s_*)s, (oyConnector_s_*)connectorimaging );
    /* ---- end of custom Connector copy constructor ------- */
    /* ---- start of custom ConnectorImaging copy constructor ----- */
    error = oyConnectorImaging_Copy__Members( s, connectorimaging );
    /* ---- end of custom ConnectorImaging copy constructor ------- */
    
    
    
    
    
  }

  if(error)
    oyConnectorImaging_Release_( &s );

  return s;
}

/** @internal
 *  Function oyConnectorImaging_Copy_
 *  @memberof oyConnectorImaging_s_
 *  @brief   copy or reference a ConnectorImaging object
 *
 *  @param[in]     connectorimaging                 ConnectorImaging struct object
 *  @param         object              the optional object
 *
 *  @version Oyranos: 
 *  @since   2010/04/26 (Oyranos: 0.1.10)
 *  @date    2010/04/26
 */
oyConnectorImaging_s_ * oyConnectorImaging_Copy_ ( oyConnectorImaging_s_ *connectorimaging, oyObject_s object )
{
  oyConnectorImaging_s_ *s = connectorimaging;

  if(!connectorimaging)
    return 0;

  if(connectorimaging && !object)
  {
    s = connectorimaging;
    
    oyObject_Copy( s->oy_ );
    return s;
  }

  s = oyConnectorImaging_Copy__( connectorimaging, object );

  return s;
}
 
/** @internal
 *  Function oyConnectorImaging_Release_
 *  @memberof oyConnectorImaging_s_
 *  @brief   release and possibly deallocate a ConnectorImaging object
 *
 *  @param[in,out] connectorimaging                 ConnectorImaging struct object
 *
 *  @version Oyranos: 
 *  @since   2010/04/26 (Oyranos: 0.1.10)
 *  @date    2010/04/26
 */
int oyConnectorImaging_Release_( oyConnectorImaging_s_ **connectorimaging )
{
  /* ---- start of common object destructor ----- */
  oyConnectorImaging_s_ *s = 0;

  if(!connectorimaging || !*connectorimaging)
    return 0;

  s = *connectorimaging;

  *connectorimaging = 0;

  if(oyObject_UnRef(s->oy_))
    return 0;
  /* ---- end of common object destructor ------- */

  
  
  /* ---- start of custom Connector destructor ----- */
  oyConnector_Release__Members( (oyConnector_s_*)s );
  /* ---- end of custom Connector destructor ------- */
  /* ---- start of custom ConnectorImaging destructor ----- */
  oyConnectorImaging_Release__Members( s );
  /* ---- end of custom ConnectorImaging destructor ------- */
  
  
  



  if(s->oy_->deallocateFunc_)
  {
    oyDeAlloc_f deallocateFunc = s->oy_->deallocateFunc_;

    oyObject_Release( &s->oy_ );

    deallocateFunc( s );
  }

  return 0;
}



/* Include "ConnectorImaging.private_methods_definitions.c" { */

/* } Include "ConnectorImaging.private_methods_definitions.c" */

