// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "ImagerySection.pypp.hpp"

namespace bp = boost::python;

void register_ImagerySection_class(){

    { //::CEGUI::ImagerySection
        typedef bp::class_< CEGUI::ImagerySection > ImagerySection_exposer_t;
        ImagerySection_exposer_t ImagerySection_exposer = ImagerySection_exposer_t( "ImagerySection", "*!\n\
        \n\
            Class that encapsulates a re-usable collection of imagery specifications.\n\
        *\n", bp::init< >("*!\n\
        \n\
            Constructor.\n\
        *\n") );
        bp::scope ImagerySection_scope( ImagerySection_exposer );
        ImagerySection_exposer.def( bp::init< CEGUI::String const & >(( bp::arg("name") ), "*!\n\
                \n\
                    ImagerySection constructor.  Name must be supplied, masterColours are set to 0xFFFFFFFF\
                    by default.\n\
        \n\
                @param name\n\
                    Name of the new ImagerySection.\n\
                *\n") );
        bp::implicitly_convertible< CEGUI::String const &, CEGUI::ImagerySection >();
        { //::CEGUI::ImagerySection::addFrameComponent
        
            typedef void ( ::CEGUI::ImagerySection::*addFrameComponent_function_type )( ::CEGUI::FrameComponent const & ) ;
            
            ImagerySection_exposer.def( 
                "addFrameComponent"
                , addFrameComponent_function_type( &::CEGUI::ImagerySection::addFrameComponent )
                , ( bp::arg("frame") )
                , "*!\n\
                    \n\
                        Add a FrameComponent to this ImagerySection.\n\
            \n\
                    @param frame\n\
                        FrameComponent to be added to the section (a copy is made)\n\
            \n\
                    @return\n\
                        Nothing\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::addImageryComponent
        
            typedef void ( ::CEGUI::ImagerySection::*addImageryComponent_function_type )( ::CEGUI::ImageryComponent const & ) ;
            
            ImagerySection_exposer.def( 
                "addImageryComponent"
                , addImageryComponent_function_type( &::CEGUI::ImagerySection::addImageryComponent )
                , ( bp::arg("img") )
                , "*!\n\
                    \n\
                        Add an ImageryComponent to this ImagerySection.\n\
            \n\
                    @param img\n\
                        ImageryComponent to be added to the section (a copy is made)\n\
            \n\
                    @return\n\
                        Nothing\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::addTextComponent
        
            typedef void ( ::CEGUI::ImagerySection::*addTextComponent_function_type )( ::CEGUI::TextComponent const & ) ;
            
            ImagerySection_exposer.def( 
                "addTextComponent"
                , addTextComponent_function_type( &::CEGUI::ImagerySection::addTextComponent )
                , ( bp::arg("text") )
                , "*!\n\
                    \n\
                        Add a TextComponent to this ImagerySection.\n\
            \n\
                    @param text\n\
                        TextComponent to be added to the section (a copy is made)\n\
            \n\
                    @return\n\
                        Nothing\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::clearFrameComponents
        
            typedef void ( ::CEGUI::ImagerySection::*clearFrameComponents_function_type )(  ) ;
            
            ImagerySection_exposer.def( 
                "clearFrameComponents"
                , clearFrameComponents_function_type( &::CEGUI::ImagerySection::clearFrameComponents )
                , "*!\n\
                    \n\
                        Clear all FrameComponents from this ImagerySection.\n\
            \n\
                    @return\n\
                        Nothing\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::clearImageryComponents
        
            typedef void ( ::CEGUI::ImagerySection::*clearImageryComponents_function_type )(  ) ;
            
            ImagerySection_exposer.def( 
                "clearImageryComponents"
                , clearImageryComponents_function_type( &::CEGUI::ImagerySection::clearImageryComponents )
                , "*!\n\
                    \n\
                        Clear all ImageryComponents from this ImagerySection.\n\
            \n\
                    @return\n\
                        Nothing\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::clearTextComponents
        
            typedef void ( ::CEGUI::ImagerySection::*clearTextComponents_function_type )(  ) ;
            
            ImagerySection_exposer.def( 
                "clearTextComponents"
                , clearTextComponents_function_type( &::CEGUI::ImagerySection::clearTextComponents )
                , "*!\n\
                    \n\
                        Clear all TextComponents from this ImagerySection.\n\
            \n\
                    @return\n\
                        Nothing\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::getBoundingRect
        
            typedef ::CEGUI::Rect ( ::CEGUI::ImagerySection::*getBoundingRect_function_type )( ::CEGUI::Window const & ) const;
            
            ImagerySection_exposer.def( 
                "getBoundingRect"
                , getBoundingRect_function_type( &::CEGUI::ImagerySection::getBoundingRect )
                , ( bp::arg("wnd") )
                , "*!\n\
            \n\
                Return smallest Rect that could contain all imagery within this section.\n\
            *\n" );
        
        }
        { //::CEGUI::ImagerySection::getBoundingRect
        
            typedef ::CEGUI::Rect ( ::CEGUI::ImagerySection::*getBoundingRect_function_type )( ::CEGUI::Window const &,::CEGUI::Rect const & ) const;
            
            ImagerySection_exposer.def( 
                "getBoundingRect"
                , getBoundingRect_function_type( &::CEGUI::ImagerySection::getBoundingRect )
                , ( bp::arg("wnd"), bp::arg("rect") )
                , "*!\n\
            \n\
                Return smallest Rect that could contain all imagery within this section.\n\
            *\n" );
        
        }
        { //::CEGUI::ImagerySection::getMasterColours
        
            typedef ::CEGUI::ColourRect const & ( ::CEGUI::ImagerySection::*getMasterColours_function_type )(  ) const;
            
            ImagerySection_exposer.def( 
                "getMasterColours"
                , getMasterColours_function_type( &::CEGUI::ImagerySection::getMasterColours )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                    \n\
                        Return the current master colours set for this ImagerySection.\n\
            \n\
                    @return\n\
                        ColourRect describing the master colour values in use for this ImagerySection.\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::getName
        
            typedef ::CEGUI::String const & ( ::CEGUI::ImagerySection::*getName_function_type )(  ) const;
            
            ImagerySection_exposer.def( 
                "getName"
                , getName_function_type( &::CEGUI::ImagerySection::getName )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                    \n\
                        Return the name of this ImagerySection.\n\
            \n\
                    @return\n\
                        String object holding the name of the ImagerySection.\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::getTextComponent
        
            typedef ::CEGUI::TextComponent const & ( ::CEGUI::ImagerySection::*getTextComponent_function_type )( ::size_t const ) const;
            
            ImagerySection_exposer.def( 
                "getTextComponent"
                , getTextComponent_function_type( &::CEGUI::ImagerySection::getTextComponent )
                , ( bp::arg("idx") )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! return a reference to a TextComponent (via index).\n" );
        
        }
        { //::CEGUI::ImagerySection::getTextComponentCount
        
            typedef ::size_t ( ::CEGUI::ImagerySection::*getTextComponentCount_function_type )(  ) const;
            
            ImagerySection_exposer.def( 
                "getTextComponentCount"
                , getTextComponentCount_function_type( &::CEGUI::ImagerySection::getTextComponentCount )
                , "! return number of TextComponents in the ImagerySection.\n" );
        
        }
        { //::CEGUI::ImagerySection::render
        
            typedef void ( ::CEGUI::ImagerySection::*render_function_type )( ::CEGUI::Window &,::CEGUI::ColourRect const *,::CEGUI::Rect const *,bool ) const;
            
            ImagerySection_exposer.def( 
                "render"
                , render_function_type( &::CEGUI::ImagerySection::render )
                , ( bp::arg("srcWindow"), bp::arg("modColours")=bp::object(), bp::arg("clipper")=bp::object(), bp::arg("clipToDisplay")=(bool)(false) )
                , "*!\n\
                    \n\
                        Render the ImagerySection.\n\
            \n\
                    @param srcWindow\n\
                        Window object to be used when calculating pixel values from BaseDim values.\n\
            \n\
                    @param modColours\n\
                        ColourRect specifying colours to be modulated with the ImagerySection's master colours.\
                        May be 0.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::render
        
            typedef void ( ::CEGUI::ImagerySection::*render_function_type )( ::CEGUI::Window &,::CEGUI::Rect const &,::CEGUI::ColourRect const *,::CEGUI::Rect const *,bool ) const;
            
            ImagerySection_exposer.def( 
                "render"
                , render_function_type( &::CEGUI::ImagerySection::render )
                , ( bp::arg("srcWindow"), bp::arg("baseRect"), bp::arg("modColours")=bp::object(), bp::arg("clipper")=bp::object(), bp::arg("clipToDisplay")=(bool)(false) )
                , "*!\n\
                    \n\
                        Render the ImagerySection.\n\
            \n\
                    @param srcWindow\n\
                        Window object to be used when calculating pixel values from BaseDim values.\n\
            \n\
                    @param baseRect\n\
                        Rect object to be used when calculating pixel values from BaseDim values.\n\
            \n\
                    @param modColours\n\
                        ColourRect specifying colours to be modulated with the ImagerySection's master colours.\
                        May be 0.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::setMasterColours
        
            typedef void ( ::CEGUI::ImagerySection::*setMasterColours_function_type )( ::CEGUI::ColourRect const & ) ;
            
            ImagerySection_exposer.def( 
                "setMasterColours"
                , setMasterColours_function_type( &::CEGUI::ImagerySection::setMasterColours )
                , ( bp::arg("cols") )
                , "*!\n\
                    \n\
                        Set the master colours to be used for this ImagerySection.\n\
            \n\
                    @param cols\n\
                        ColourRect describing the colours to be set as the master colours for this\
                        ImagerySection.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::setMasterColoursPropertyIsColourRect
        
            typedef void ( ::CEGUI::ImagerySection::*setMasterColoursPropertyIsColourRect_function_type )( bool ) ;
            
            ImagerySection_exposer.def( 
                "setMasterColoursPropertyIsColourRect"
                , setMasterColoursPropertyIsColourRect_function_type( &::CEGUI::ImagerySection::setMasterColoursPropertyIsColourRect )
                , ( bp::arg("setting")=(bool)(true) )
                , "*!\n\
                    \n\
                        Set whether the master colours property source represents a full ColourRect.\n\
            \n\
                    @param setting\n\
                        - true if the master colours property will access a ColourRect object.\n\
                        - false if the master colours property will access a colour object.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::setMasterColoursPropertySource
        
            typedef void ( ::CEGUI::ImagerySection::*setMasterColoursPropertySource_function_type )( ::CEGUI::String const & ) ;
            
            ImagerySection_exposer.def( 
                "setMasterColoursPropertySource"
                , setMasterColoursPropertySource_function_type( &::CEGUI::ImagerySection::setMasterColoursPropertySource )
                , ( bp::arg("property") )
                , "*!\n\
                    \n\
                        Set the name of the property where master colour values can be obtained.\n\
            \n\
                    @param property\n\
                        String containing the name of the property.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::ImagerySection::writeXMLToStream
        
            typedef void ( ::CEGUI::ImagerySection::*writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            ImagerySection_exposer.def( 
                "writeXMLToStream"
                , writeXMLToStream_function_type( &::CEGUI::ImagerySection::writeXMLToStream )
                , ( bp::arg("xml_stream") )
                , "*!\n\
                    \n\
                        Writes an xml representation of this ImagerySection to  out_stream.\n\
            \n\
                    @param xml_stream\n\
                        Stream where xml data should be output.\n\
            \n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
    }

}
