# Stefan Achatz 2012
#
# Tries to find gtk and its dependencies and sets following variables according to found capabilities:
#
# GTK_FOUND
# GTK_INCLUDE_DIRS
# GTK_LIBRARIES

FIND_PACKAGE(ATK)
FIND_PACKAGE(CAIRO)
FIND_PACKAGE(GDK)
FIND_PACKAGE(GLIB2)
FIND_PACKAGE(GTK2)
FIND_PACKAGE(PANGO)

SET(GTK_INCLUDE_DIRS
  ${ATK_INCLUDE_DIRS}
  ${CAIRO_INCLUDE_DIRS}
  ${GDK_INCLUDE_DIRS}
  ${GLIB2_INCLUDE_DIRS}
  ${GTK2_INCLUDE_DIRS}
  ${PANGO_INCLUDE_DIRS}
)

SET(GTK_LIBRARIES
  ${ATK_LIBRARIES}
  ${CAIRO_LIBRARIES}
  ${GDK_LIBRARIES}
  ${GLIB2_LIBRARIES}
  ${GTK2_LIBRARIES}
  ${PANGO_LIBRARIES}
)

IF(ATK_FOUND AND CAIRO_FOUND AND GDK_FOUND AND GLIB2_FOUND AND GTK2_FOUND AND PANGO_FOUND)
  SET(GTK_FOUND true)
ENDIF()

IF(GTK_FIND_REQUIRED AND NOT GTK_FOUND)
  MESSAGE(FATAL_ERROR "Could not find GTK")
ENDIF()
