/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.gui.nodeviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import org.apache.zookeeper.inspector.gui.ZooInspectorIconResources;
import org.apache.zookeeper.inspector.gui.nodeviewer.ZooInspectorNodeViewer;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.ZooInspectorNodeManager;

public class NodeViewerData
extends ZooInspectorNodeViewer {
    private ZooInspectorNodeManager zooInspectorManager;
    private final JTextPane dataArea;
    private final JToolBar toolbar;
    private String selectedNode;

    public NodeViewerData() {
        this.setLayout(new BorderLayout());
        this.dataArea = new JTextPane();
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        JScrollPane scroller = new JScrollPane(this.dataArea);
        scroller.setHorizontalScrollBarPolicy(31);
        this.add((Component)scroller, "Center");
        this.add((Component)this.toolbar, "North");
        JButton saveButton = new JButton(ZooInspectorIconResources.getSaveIcon());
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NodeViewerData.this.selectedNode != null && JOptionPane.showConfirmDialog(NodeViewerData.this, "Are you sure you want to save this node? (this action cannot be reverted)", "Confirm Save", 0, 2) == 0) {
                    NodeViewerData.this.zooInspectorManager.setData(NodeViewerData.this.selectedNode, NodeViewerData.this.dataArea.getText());
                }
            }
        });
        this.toolbar.add(saveButton);
    }

    @Override
    public String getTitle() {
        return "Node Data";
    }

    @Override
    public void nodeSelectionChanged(List<String> selectedNodes) {
        if (selectedNodes.size() > 0) {
            this.selectedNode = selectedNodes.get(0);
            SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

                @Override
                protected String doInBackground() throws Exception {
                    return NodeViewerData.this.zooInspectorManager.getData(NodeViewerData.this.selectedNode);
                }

                @Override
                protected void done() {
                    String data = "";
                    try {
                        data = (String)this.get();
                    }
                    catch (InterruptedException e) {
                        LoggerFactory.getLogger().error("Error retrieving data for node: " + NodeViewerData.this.selectedNode, (Throwable)e);
                    }
                    catch (ExecutionException e) {
                        LoggerFactory.getLogger().error("Error retrieving data for node: " + NodeViewerData.this.selectedNode, (Throwable)e);
                    }
                    NodeViewerData.this.dataArea.setText(data);
                }
            };
            worker.execute();
        }
    }

    @Override
    public void setZooInspectorManager(ZooInspectorNodeManager zooInspectorManager) {
        this.zooInspectorManager = zooInspectorManager;
    }
}

