/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import javax.servlet.Servlet;
import org.apache.zookeeper.graph.MergedLogSource;
import org.apache.zookeeper.graph.servlets.FileLoader;
import org.apache.zookeeper.graph.servlets.Fs;
import org.apache.zookeeper.graph.servlets.GraphData;
import org.apache.zookeeper.graph.servlets.NumEvents;
import org.apache.zookeeper.graph.servlets.StaticContent;
import org.apache.zookeeper.graph.servlets.Throughput;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class LogServer
extends ServletContextHandler {
    public LogServer(MergedLogSource src) throws Exception {
        super(1);
        this.setContextPath("/");
        this.addServlet(new ServletHolder((Servlet)new StaticContent()), "/graph/*");
        this.addServlet(new ServletHolder((Servlet)new Fs()), "/fs");
        this.addServlet(new ServletHolder((Servlet)new GraphData(src)), "/data");
        this.addServlet(new ServletHolder((Servlet)new FileLoader(src)), "/loadfile");
        this.addServlet(new ServletHolder((Servlet)new NumEvents(src)), "/info");
        this.addServlet(new ServletHolder((Servlet)new Throughput(src)), "/throughput");
    }

    public static void main(String[] args) {
        try {
            MergedLogSource src = new MergedLogSource(args);
            System.out.println(src);
            Server server = new Server(8182);
            server.setHandler((Handler)new LogServer(src));
            server.start();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

