/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph.servlets;

import org.apache.zookeeper.graph.LogIterator;
import org.apache.zookeeper.graph.LogSource;
import org.apache.zookeeper.graph.servlets.JsonServlet;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumEvents
extends JsonServlet {
    private static final Logger LOG = LoggerFactory.getLogger(NumEvents.class);
    private static final int DEFAULT_PERIOD = 1000;
    private LogSource source = null;

    public NumEvents(LogSource src) throws Exception {
        this.source = src;
    }

    @Override
    String handleRequest(JsonServlet.JsonRequest request) throws Exception {
        String output = "";
        long starttime = 0L;
        long endtime = 0L;
        long period = 0L;
        starttime = request.getNumber("start", 0L);
        endtime = request.getNumber("end", 0L);
        period = request.getNumber("period", 0L);
        if (starttime == 0L) {
            starttime = this.source.getStartTime();
        }
        if (endtime == 0L) {
            endtime = period > 0L ? starttime + period : this.source.getEndTime();
        }
        LogIterator iter = this.source.iterator(starttime, endtime);
        JSONObject data = new JSONObject();
        data.put((Object)"startTime", (Object)starttime);
        data.put((Object)"endTime", (Object)endtime);
        long size = 0L;
        size = iter.size();
        data.put((Object)"numEntries", (Object)size);
        if (LOG.isDebugEnabled()) {
            LOG.debug("handle(start= " + starttime + ", end=" + endtime + ", numEntries=" + size + ")");
        }
        return JSONValue.toJSONString((Object)data);
    }
}

