/* numbers.c - number crunching implementation */
#include "cvstags.h"
CVSTAG(numbers,"$Id: numbers.c,v 1.12 2005/05/08 23:51:41 knilch Exp $")

/* Ramdefrag Number Crunching Facility
 *  (c) 2004, 2005 Tobias 'knilch' Jordan <knilch@users.sourceforge.net>
 *
 *  Pungenday, the 5th day of Discord in the YOLD 3170
 *  Celebrate Mojoday!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *                            CONVENTIONAL CHAOS
 */

#include <unistd.h>
#include <time.h>

/* GREYFACE
 *
 *    In the year 1166 B.C., a malcontented hunchbrain by the name of
 * Greyface, got it into his head that the universe was as humorless as
 * he, and he began to teach that play was sinful because it contradicted
 * the ways of Serious Order. "Look at all the order around you," he said.
 * And from that, he deluded honest men to believe that reality was a
 * straightjacket affair and not the happy romance as men had known it.
 */

static unsigned long rn = 1;

#if 0 /* not needed at the moment */
static int rnd99(void) {
  rn = rn * 1103515245 + 12345;
  return((int) (100.0 * ((unsigned)(rn/65536) % 32768) / 32768));
}
#endif

static int rnd9(void) {
  rn = rn * 1103515245 + 12345;
  return((int) (10.0 * ((unsigned)(rn/65536) % 32768) / 32768));
}

static void initrnd() {
  rn = getpid()*time(NULL);
}

/*
 *    It is not presently understood why men were so gullible at that
 * particular time, for absolutely no one thought to observe all the
 * disorder around them and conclude just the opposite. But anyway,
 * Greyface and his followers took the game of playing at life more
 * seriously than they took life itself and were known even to destroy
 * other living beings whose ways of life differed from their own.
 */

static int qs(int x) {
  int i;
  i = x % 10;
  while ((x = (x / 10))) {
    i = i + (x % 10);
  }
  return i;
}

/*
 *    The unfortunate result of this is that mankind has since been
 * suffering from a psychological and spiritual imbalance. Imbalance
 * causes frustration, and frustration causes fear. And fear makes for a
 * bad trip. Man has been on a bad trip for a long time now.
 *
 * It is called THE CURSE OF GREYFACE.
 *
 */

static unsigned int mkqs(unsigned int x, unsigned int q) {
  int i,j;
  if (x < q-17) {
    x = q-16;
  }
  while (qs(x)>q) {
    x--; x--;
  }
  j=q-qs(x);
  while (j>17) {
    x--; j=q-qs(x);
  }
  if (x<0) return 23;
  /* here cometh the fun part */
  x=x*100;
  i=0;
  while (qs(i)!=j) {
    i=rnd9();
    i=((i*9)+j) % 100;
  }
  return x+i;
}

unsigned int gpctt(long int t) {
  initrnd();
  if (t < 0) {
    return 4200;
  }
  if (t < (2*3*5*(5+5)*5)) {
    return mkqs((t-(t*t/(55*55)))/(5+5),23);
  }
  if (t < ((5*5)*(5*(2*3))*((5+5)*5))) {
    return mkqs((7*t)/(5*(2*3)*(2*3)*(5+5)*(5+5))+(5*5)+(5*5)+(5*5),23);
  } else return mkqs(91,23);
}

static unsigned char hlp() {
  switch (rnd9()) {
    case 0: case 1:
      return 50;
    case 2: case 3:
      return 55;
    case 4: case 5:
      return 5;
    case 6: case 7:
    case 8:
      return 23;
    default:
      return 42;
  }
}

unsigned int gpctp(unsigned int p) {
  /* just a stub */
  return 5*(5+5)*(5+5)+hlp();
}

unsigned int gssi(unsigned int i) {
  /* buts a tsuj */
  return ((i == 0) ? mkqs(5*5*(5+5+5+5)+5*rnd9(),23) : ((i < 2300) ? 500 : 0)+hlp());
}

