/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.setting.AbstractSetting;

public class IntSetSetting
extends AbstractSetting {
    private Set<Integer> value;

    IntSetSetting(Properties properties, Properties properties2, String string, Integer[] integerArray) {
        super(properties, properties2, string, IntSetSetting.decode(new HashSet<Integer>(Arrays.asList(integerArray))));
        this.setPrivate(true);
    }

    public Set<Integer> getValue() {
        return this.value;
    }

    public synchronized Integer[] getValueAsArray() {
        return this.value.toArray(new Integer[this.value.size()]);
    }

    public void setValue(Set<? extends Integer> set) {
        this.setValueInternal(IntSetSetting.decode(set));
    }

    public synchronized void add(Integer n) {
        this.value.add(n);
        this.setValue(this.value);
    }

    public synchronized boolean remove(Integer n) {
        if (this.value.remove(n)) {
            this.setValue(this.value);
            return true;
        }
        return false;
    }

    public synchronized boolean contains(Integer n) {
        return this.value.contains(n);
    }

    public synchronized int length() {
        return this.value.size();
    }

    @Override
    protected synchronized void loadValue(String string) {
        this.value = IntSetSetting.encode(string);
    }

    private static final Set<Integer> encode(String string) {
        if (string == null || string.length() == 0) {
            return new HashSet<Integer>();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Integer(stringTokenizer.nextToken()));
        }
        return hashSet;
    }

    private static final String decode(Set<? extends Integer> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n : set) {
            stringBuilder.append(n.toString()).append(';');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

