/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.jcip.annotations.Immutable;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

@Immutable
public final class MultihomePlainSocketFactory
implements SocketFactory {
    private static final MultihomePlainSocketFactory DEFAULT_FACTORY = new MultihomePlainSocketFactory();

    public static MultihomePlainSocketFactory getSocketFactory() {
        return DEFAULT_FACTORY;
    }

    private MultihomePlainSocketFactory() {
    }

    @Override
    public Socket createSocket() {
        return new Socket();
    }

    @Override
    public Socket connectSocket(Socket socket, String string, int n, InetAddress inetAddress, int n2, HttpParams httpParams) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters may not be null.");
        }
        if (socket == null) {
            socket = this.createSocket();
        }
        if (inetAddress != null || n2 > 0) {
            if (n2 < 0) {
                n2 = 0;
            }
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
            socket.bind(inetSocketAddress);
        }
        int n3 = HttpConnectionParams.getConnectionTimeout((HttpParams)httpParams);
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(inetAddressArray.length);
        arrayList.addAll(Arrays.asList(inetAddressArray));
        Collections.shuffle(arrayList);
        IOException iOException = null;
        for (InetAddress inetAddress2 : arrayList) {
            try {
                socket.connect(new InetSocketAddress(inetAddress2, n), n3);
                break;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new ConnectTimeoutException("Connect to " + inetAddress2 + " timed out");
            }
            catch (IOException iOException2) {
                socket = new Socket();
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        return socket;
    }

    @Override
    public final boolean isSecure(Socket socket) throws IllegalArgumentException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null.");
        }
        if (socket.getClass() != Socket.class) {
            throw new IllegalArgumentException("Socket not created by this factory.");
        }
        if (socket.isClosed()) {
            throw new IllegalArgumentException("Socket is closed.");
        }
        return false;
    }
}

