/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.routing;

import java.net.InetAddress;
import net.jcip.annotations.Immutable;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.RouteInfo;

@Immutable
public final class HttpRoute
implements RouteInfo,
Cloneable {
    private static final HttpHost[] EMPTY_HTTP_HOST_ARRAY = new HttpHost[0];
    private final HttpHost targetHost;
    private final InetAddress localAddress;
    private final HttpHost[] proxyChain;
    private final RouteInfo.TunnelType tunnelled;
    private final RouteInfo.LayerType layered;
    private final boolean secure;

    private HttpRoute(InetAddress inetAddress, HttpHost httpHost, HttpHost[] httpHostArray, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        if (httpHost == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (httpHostArray == null) {
            throw new IllegalArgumentException("Proxies may not be null.");
        }
        if (tunnelType == RouteInfo.TunnelType.TUNNELLED && httpHostArray.length == 0) {
            throw new IllegalArgumentException("Proxy required if tunnelled.");
        }
        if (tunnelType == null) {
            tunnelType = RouteInfo.TunnelType.PLAIN;
        }
        if (layerType == null) {
            layerType = RouteInfo.LayerType.PLAIN;
        }
        this.targetHost = httpHost;
        this.localAddress = inetAddress;
        this.proxyChain = httpHostArray;
        this.secure = bl;
        this.tunnelled = tunnelType;
        this.layered = layerType;
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost[] httpHostArray, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this(inetAddress, httpHost, HttpRoute.toChain(httpHostArray), bl, tunnelType, layerType);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost httpHost2, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this(inetAddress, httpHost, HttpRoute.toChain(httpHost2), bl, tunnelType, layerType);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, boolean bl) {
        this(inetAddress, httpHost, EMPTY_HTTP_HOST_ARRAY, bl, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
    }

    public HttpRoute(HttpHost httpHost) {
        this(null, httpHost, EMPTY_HTTP_HOST_ARRAY, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost httpHost2, boolean bl) {
        this(inetAddress, httpHost, HttpRoute.toChain(httpHost2), bl, bl ? RouteInfo.TunnelType.TUNNELLED : RouteInfo.TunnelType.PLAIN, bl ? RouteInfo.LayerType.LAYERED : RouteInfo.LayerType.PLAIN);
        if (httpHost2 == null) {
            throw new IllegalArgumentException("Proxy host may not be null.");
        }
    }

    private static HttpHost[] toChain(HttpHost httpHost) {
        if (httpHost == null) {
            return EMPTY_HTTP_HOST_ARRAY;
        }
        return new HttpHost[]{httpHost};
    }

    private static HttpHost[] toChain(HttpHost[] httpHostArray) {
        if (httpHostArray == null || httpHostArray.length < 1) {
            return EMPTY_HTTP_HOST_ARRAY;
        }
        for (HttpHost httpHost : httpHostArray) {
            if (httpHost != null) continue;
            throw new IllegalArgumentException("Proxy chain may not contain null elements.");
        }
        HttpHost[] httpHostArray2 = new HttpHost[httpHostArray.length];
        System.arraycopy(httpHostArray, 0, httpHostArray2, 0, httpHostArray.length);
        return httpHostArray2;
    }

    @Override
    public final HttpHost getTargetHost() {
        return this.targetHost;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public final int getHopCount() {
        return this.proxyChain.length + 1;
    }

    @Override
    public final HttpHost getHopTarget(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Hop index must not be negative: " + n);
        }
        int n2 = this.getHopCount();
        if (n >= n2) {
            throw new IllegalArgumentException("Hop index " + n + " exceeds route length " + n2);
        }
        HttpHost httpHost = null;
        httpHost = n < n2 - 1 ? this.proxyChain[n] : this.targetHost;
        return httpHost;
    }

    @Override
    public final HttpHost getProxyHost() {
        return this.proxyChain.length == 0 ? null : this.proxyChain[0];
    }

    @Override
    public final RouteInfo.TunnelType getTunnelType() {
        return this.tunnelled;
    }

    @Override
    public final boolean isTunnelled() {
        return this.tunnelled == RouteInfo.TunnelType.TUNNELLED;
    }

    @Override
    public final RouteInfo.LayerType getLayerType() {
        return this.layered;
    }

    @Override
    public final boolean isLayered() {
        return this.layered == RouteInfo.LayerType.LAYERED;
    }

    @Override
    public final boolean isSecure() {
        return this.secure;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HttpRoute)) {
            return false;
        }
        HttpRoute httpRoute = (HttpRoute)object;
        boolean bl = this.targetHost.equals((Object)httpRoute.targetHost);
        bl &= this.localAddress == httpRoute.localAddress || this.localAddress != null && this.localAddress.equals(httpRoute.localAddress);
        bl &= this.proxyChain == httpRoute.proxyChain || this.proxyChain.length == httpRoute.proxyChain.length;
        if ((bl &= this.secure == httpRoute.secure && this.tunnelled == httpRoute.tunnelled && this.layered == httpRoute.layered) && this.proxyChain != null) {
            for (int i = 0; bl && i < this.proxyChain.length; ++i) {
                bl = this.proxyChain[i].equals((Object)httpRoute.proxyChain[i]);
            }
        }
        return bl;
    }

    public final int hashCode() {
        int n = this.targetHost.hashCode();
        if (this.localAddress != null) {
            n ^= this.localAddress.hashCode();
        }
        n ^= this.proxyChain.length;
        for (HttpHost httpHost : this.proxyChain) {
            n ^= httpHost.hashCode();
        }
        if (this.secure) {
            n ^= 0x11111111;
        }
        n ^= this.tunnelled.hashCode();
        return n ^= this.layered.hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(50 + this.getHopCount() * 30);
        stringBuilder.append("HttpRoute[");
        if (this.localAddress != null) {
            stringBuilder.append(this.localAddress);
            stringBuilder.append("->");
        }
        stringBuilder.append('{');
        if (this.tunnelled == RouteInfo.TunnelType.TUNNELLED) {
            stringBuilder.append('t');
        }
        if (this.layered == RouteInfo.LayerType.LAYERED) {
            stringBuilder.append('l');
        }
        if (this.secure) {
            stringBuilder.append('s');
        }
        stringBuilder.append("}->");
        for (HttpHost httpHost : this.proxyChain) {
            stringBuilder.append(httpHost);
            stringBuilder.append("->");
        }
        stringBuilder.append(this.targetHost);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

