/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.cookie;

import java.util.Locale;
import net.jcip.annotations.Immutable;

@Immutable
public final class CookieOrigin {
    private final String host;
    private final int port;
    private final String path;
    private final boolean secure;

    public CookieOrigin(String string, int n, String string2, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        this.host = string.toLowerCase(Locale.ENGLISH);
        this.port = n;
        this.path = string2.trim().length() != 0 ? string2 : "/";
        this.secure = bl;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (this.secure) {
            stringBuilder.append("(secure)");
        }
        stringBuilder.append(this.host);
        stringBuilder.append(':');
        stringBuilder.append(Integer.toString(this.port));
        stringBuilder.append(this.path);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

