/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import net.jcip.annotations.Immutable;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private final int retryCount;
    private final boolean requestSentRetryEnabled;

    public DefaultHttpRequestRetryHandler(int n, boolean bl) {
        this.retryCount = n;
        this.requestSentRetryEnabled = bl;
    }

    public DefaultHttpRequestRetryHandler() {
        this(3, false);
    }

    @Override
    public boolean retryRequest(IOException iOException, int n, HttpContext httpContext) {
        boolean bl;
        boolean bl2;
        if (iOException == null) {
            throw new IllegalArgumentException("Exception parameter may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        if (n > this.retryCount) {
            return false;
        }
        if (iOException instanceof NoHttpResponseException) {
            return true;
        }
        if (iOException instanceof InterruptedIOException) {
            return false;
        }
        if (iOException instanceof UnknownHostException) {
            return false;
        }
        if (iOException instanceof ConnectException) {
            return false;
        }
        if (iOException instanceof SSLHandshakeException) {
            return false;
        }
        HttpRequest httpRequest = (HttpRequest)httpContext.getAttribute("http.request");
        boolean bl3 = bl2 = !(httpRequest instanceof HttpEntityEnclosingRequest);
        if (bl2) {
            return true;
        }
        Boolean bl4 = (Boolean)httpContext.getAttribute("http.request_sent");
        boolean bl5 = bl = bl4 != null && bl4 != false;
        return !bl || this.requestSentRetryEnabled;
    }

    public boolean isRequestSentRetryEnabled() {
        return this.requestSentRetryEnabled;
    }

    public int getRetryCount() {
        return this.retryCount;
    }
}

