/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import net.jcip.annotations.Immutable;
import org.apache.http.impl.conn.Wire;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class LoggingSessionOutputBuffer
implements SessionOutputBuffer {
    private final SessionOutputBuffer out;
    private final Wire wire;

    public LoggingSessionOutputBuffer(SessionOutputBuffer sessionOutputBuffer, Wire wire) {
        this.out = sessionOutputBuffer;
        this.wire = wire;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        if (this.wire.enabled()) {
            this.wire.output(byArray, n, n2);
        }
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        if (this.wire.enabled()) {
            this.wire.output(n);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
        if (this.wire.enabled()) {
            this.wire.output(byArray);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void writeLine(CharArrayBuffer charArrayBuffer) throws IOException {
        this.out.writeLine(charArrayBuffer);
        if (this.wire.enabled()) {
            String string = new String(charArrayBuffer.buffer(), 0, charArrayBuffer.length());
            this.wire.output(string + "[EOL]");
        }
    }

    public void writeLine(String string) throws IOException {
        this.out.writeLine(string);
        if (this.wire.enabled()) {
            this.wire.output(string + "[EOL]");
        }
    }

    public HttpTransportMetrics getMetrics() {
        return this.out.getMetrics();
    }
}

