/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import net.jcip.annotations.Immutable;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.AbstractCookieAttributeHandler;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        if (setCookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (string == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (string.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            setCookie.setVersion(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedCookieException("Invalid version: " + numberFormatException.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookie.getVersion() < 0) {
            throw new MalformedCookieException("Cookie version may not be negative");
        }
    }
}

