/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.ant.gettext;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;
import org.xnap.commons.ant.gettext.AbstractGettextGenerateTask;

public class GenerateDefaultBundleTask
extends AbstractGettextGenerateTask {
    protected String msginitCmd = "msginit";
    protected String potFile = null;

    public void setMsgenCmd(String string) {
        this.msginitCmd = string;
    }

    public void setPotFile(String string) {
        this.potFile = string;
    }

    @Override
    protected void checkPreconditions() {
        super.checkPreconditions();
        if (this.potFile == null) {
            throw new BuildException("potFile must be specified: <... potFile=\"po/keys.pot\"");
        }
    }

    public void execute() {
        this.checkPreconditions();
        File file = this.createDefaultBundle();
        AbstractGettextGenerateTask.CommandlineFactory commandlineFactory = this.getCommandlineFactory();
        Commandline commandline = commandlineFactory.createCommandline(file, null);
        this.log("Executing: " + commandline.toString(), 4);
        this.runCommandLineAndWait(commandline);
        file.delete();
    }

    private File createDefaultBundle() {
        try {
            File file = File.createTempFile("default", ".po");
            file.delete();
            Commandline commandline = new Commandline();
            commandline.setExecutable(this.msginitCmd);
            commandline.createArgument().setValue("--no-translator");
            commandline.createArgument().setValue("-i");
            commandline.createArgument().setValue(this.potFile);
            commandline.createArgument().setValue("-o");
            commandline.createArgument().setFile(file);
            this.log("Generating default po file: " + commandline.toString(), 2);
            this.runCommandLineAndWait(commandline);
            return file;
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }
}

