/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import org.apache.lucene.analysis.CharFilter;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.util.ArrayUtil;

public abstract class BaseCharFilter
extends CharFilter {
    private int[] offsets;
    private int[] diffs;
    private int size = 0;

    public BaseCharFilter(CharStream charStream) {
        super(charStream);
    }

    @Override
    protected int correct(int n) {
        if (this.offsets == null || n < this.offsets[0]) {
            return n;
        }
        int n2 = this.size - 1;
        if (n >= this.offsets[n2]) {
            return n + this.diffs[n2];
        }
        int n3 = 0;
        int n4 = -1;
        while (n2 >= n3) {
            n4 = n3 + n2 >>> 1;
            if (n < this.offsets[n4]) {
                n2 = n4 - 1;
                continue;
            }
            if (n > this.offsets[n4]) {
                n3 = n4 + 1;
                continue;
            }
            return n + this.diffs[n4];
        }
        if (n < this.offsets[n4]) {
            return n4 == 0 ? n : n + this.diffs[n4 - 1];
        }
        return n + this.diffs[n4];
    }

    protected int getLastCumulativeDiff() {
        return this.offsets == null ? 0 : this.diffs[this.size - 1];
    }

    protected void addOffCorrectMap(int n, int n2) {
        if (this.offsets == null) {
            this.offsets = new int[64];
            this.diffs = new int[64];
        } else if (this.size == this.offsets.length) {
            this.offsets = ArrayUtil.grow(this.offsets);
            this.diffs = ArrayUtil.grow(this.diffs);
        }
        this.offsets[this.size] = n;
        this.diffs[this.size++] = n2;
    }
}

