/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.CharacterUtils;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.VirtualMethod;

public abstract class CharTokenizer
extends Tokenizer {
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private int finalOffset = 0;
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 4096;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final CharacterUtils charUtils;
    private final CharacterUtils.CharacterBuffer ioBuffer = CharacterUtils.newCharacterBuffer(4096);
    @Deprecated
    private final boolean useOldAPI;
    @Deprecated
    private static final VirtualMethod<CharTokenizer> isTokenCharMethod = new VirtualMethod<CharTokenizer>(CharTokenizer.class, "isTokenChar", Character.TYPE);
    @Deprecated
    private static final VirtualMethod<CharTokenizer> normalizeMethod = new VirtualMethod<CharTokenizer>(CharTokenizer.class, "normalize", Character.TYPE);

    public CharTokenizer(Version version, Reader reader) {
        super(reader);
        this.charUtils = CharacterUtils.getInstance(version);
        this.useOldAPI = this.useOldAPI(version);
    }

    public CharTokenizer(Version version, AttributeSource attributeSource, Reader reader) {
        super(attributeSource, reader);
        this.charUtils = CharacterUtils.getInstance(version);
        this.useOldAPI = this.useOldAPI(version);
    }

    public CharTokenizer(Version version, AttributeSource.AttributeFactory attributeFactory, Reader reader) {
        super(attributeFactory, reader);
        this.charUtils = CharacterUtils.getInstance(version);
        this.useOldAPI = this.useOldAPI(version);
    }

    @Deprecated
    public CharTokenizer(Reader reader) {
        this(Version.LUCENE_30, reader);
    }

    @Deprecated
    public CharTokenizer(AttributeSource attributeSource, Reader reader) {
        this(Version.LUCENE_30, attributeSource, reader);
    }

    @Deprecated
    public CharTokenizer(AttributeSource.AttributeFactory attributeFactory, Reader reader) {
        this(Version.LUCENE_30, attributeFactory, reader);
    }

    @Deprecated
    protected boolean isTokenChar(char c) {
        return this.isTokenChar((int)c);
    }

    @Deprecated
    protected char normalize(char c) {
        return (char)this.normalize((int)c);
    }

    protected boolean isTokenChar(int n) {
        throw new UnsupportedOperationException("since LUCENE_31 subclasses of CharTokenizer must implement isTokenChar(int)");
    }

    protected int normalize(int n) {
        return n;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (this.useOldAPI) {
            return this.incrementTokenOld();
        }
        int n = 0;
        int n2 = -1;
        char[] cArray = this.termAtt.buffer();
        while (true) {
            if (this.bufferIndex >= this.dataLen) {
                this.offset += this.dataLen;
                if (!this.charUtils.fill(this.ioBuffer, this.input)) {
                    this.dataLen = 0;
                    if (n <= 0) {
                        this.finalOffset = this.correctOffset(this.offset);
                        return false;
                    }
                    break;
                }
                this.dataLen = this.ioBuffer.getLength();
                this.bufferIndex = 0;
            }
            int n3 = this.charUtils.codePointAt(this.ioBuffer.getBuffer(), this.bufferIndex);
            this.bufferIndex += Character.charCount(n3);
            if (this.isTokenChar(n3)) {
                if (n == 0) {
                    assert (n2 == -1);
                    n2 = this.offset + this.bufferIndex - 1;
                } else if (n >= cArray.length - 1) {
                    cArray = this.termAtt.resizeBuffer(2 + n);
                }
                if ((n += Character.toChars(this.normalize(n3), cArray, n)) < 255) continue;
                break;
            }
            if (n > 0) break;
        }
        this.termAtt.setLength(n);
        assert (n2 != -1);
        this.finalOffset = this.correctOffset(n2 + n);
        this.offsetAtt.setOffset(this.correctOffset(n2), this.finalOffset);
        return true;
    }

    @Deprecated
    private boolean incrementTokenOld() throws IOException {
        int n = 0;
        int n2 = -1;
        char[] cArray = this.termAtt.buffer();
        char[] cArray2 = this.ioBuffer.getBuffer();
        while (true) {
            char c;
            if (this.bufferIndex >= this.dataLen) {
                this.offset += this.dataLen;
                this.dataLen = this.input.read(cArray2);
                if (this.dataLen == -1) {
                    this.dataLen = 0;
                    if (n <= 0) {
                        this.finalOffset = this.correctOffset(this.offset);
                        return false;
                    }
                    break;
                }
                this.bufferIndex = 0;
            }
            if (this.isTokenChar(c = cArray2[this.bufferIndex++])) {
                if (n == 0) {
                    assert (n2 == -1);
                    n2 = this.offset + this.bufferIndex - 1;
                } else if (n == cArray.length) {
                    cArray = this.termAtt.resizeBuffer(1 + n);
                }
                cArray[n++] = this.normalize(c);
                if (n != 255) continue;
                break;
            }
            if (n > 0) break;
        }
        this.termAtt.setLength(n);
        assert (n2 != -1);
        this.offsetAtt.setOffset(this.correctOffset(n2), this.correctOffset(n2 + n));
        return true;
    }

    @Override
    public final void end() {
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }

    @Override
    public void reset(Reader reader) throws IOException {
        super.reset(reader);
        this.bufferIndex = 0;
        this.offset = 0;
        this.dataLen = 0;
        this.finalOffset = 0;
        this.ioBuffer.reset();
    }

    @Deprecated
    private boolean useOldAPI(Version version) {
        Class<?> clazz = this.getClass();
        if (version.onOrAfter(Version.LUCENE_31) && (isTokenCharMethod.isOverriddenAsOf(clazz) || normalizeMethod.isOverriddenAsOf(clazz))) {
            throw new IllegalArgumentException("For matchVersion >= LUCENE_31, CharTokenizer subclasses must not override isTokenChar(char) or normalize(char).");
        }
        return !version.onOrAfter(Version.LUCENE_31);
    }
}

