/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.util.Version;

public final class KeywordMarkerFilter
extends TokenFilter {
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final CharArraySet keywordSet;

    public KeywordMarkerFilter(TokenStream tokenStream, CharArraySet charArraySet) {
        super(tokenStream);
        this.keywordSet = charArraySet;
    }

    public KeywordMarkerFilter(TokenStream tokenStream, Set<?> set) {
        this(tokenStream, set instanceof CharArraySet ? (CharArraySet)set : CharArraySet.copy(Version.LUCENE_31, set));
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.keywordSet.contains(this.termAtt.buffer(), 0, this.termAtt.length())) {
                this.keywordAttr.setKeyword(true);
            }
            return true;
        }
        return false;
    }
}

