/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LimitTokenCountFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;

public final class LimitTokenCountAnalyzer
extends Analyzer {
    private final Analyzer delegate;
    private final int maxTokenCount;

    public LimitTokenCountAnalyzer(Analyzer analyzer, int n) {
        this.delegate = analyzer;
        this.maxTokenCount = n;
    }

    @Override
    public TokenStream tokenStream(String string, Reader reader) {
        return new LimitTokenCountFilter(this.delegate.tokenStream(string, reader), this.maxTokenCount);
    }

    @Override
    public TokenStream reusableTokenStream(String string, Reader reader) throws IOException {
        return new LimitTokenCountFilter(this.delegate.reusableTokenStream(string, reader), this.maxTokenCount);
    }

    @Override
    public int getPositionIncrementGap(String string) {
        return this.delegate.getPositionIncrementGap(string);
    }

    @Override
    public int getOffsetGap(Fieldable fieldable) {
        return this.delegate.getOffsetGap(fieldable);
    }

    public String toString() {
        return "LimitTokenCountAnalyzer(" + this.delegate.toString() + ", maxTokenCount=" + this.maxTokenCount + ")";
    }
}

