/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.CharArrayMap;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public class WordlistLoader {
    private static final int INITITAL_CAPACITY = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharArraySet getWordSet(Reader reader, CharArraySet charArraySet) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = WordlistLoader.getBufferedReader(reader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                charArraySet.add(string.trim());
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(bufferedReader);
            throw throwable;
        }
        IOUtils.close(bufferedReader);
        return charArraySet;
    }

    public static CharArraySet getWordSet(Reader reader, Version version) throws IOException {
        return WordlistLoader.getWordSet(reader, new CharArraySet(version, 16, false));
    }

    public static CharArraySet getWordSet(Reader reader, String string, Version version) throws IOException {
        return WordlistLoader.getWordSet(reader, string, new CharArraySet(version, 16, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharArraySet getWordSet(Reader reader, String string, CharArraySet charArraySet) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = WordlistLoader.getBufferedReader(reader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith(string)) continue;
                charArraySet.add(string2.trim());
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(bufferedReader);
            throw throwable;
        }
        IOUtils.close(bufferedReader);
        return charArraySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharArraySet getSnowballWordSet(Reader reader, CharArraySet charArraySet) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = WordlistLoader.getBufferedReader(reader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(124);
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                String[] stringArray = string.split("\\s+");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].length() <= 0) continue;
                    charArraySet.add(stringArray[i]);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(bufferedReader);
            throw throwable;
        }
        IOUtils.close(bufferedReader);
        return charArraySet;
    }

    public static CharArraySet getSnowballWordSet(Reader reader, Version version) throws IOException {
        return WordlistLoader.getSnowballWordSet(reader, new CharArraySet(version, 16, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharArrayMap<String> getStemDict(Reader reader, CharArrayMap<String> charArrayMap) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = WordlistLoader.getBufferedReader(reader);
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("\t", 2);
                charArrayMap.put(stringArray[0], stringArray[1]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(bufferedReader);
            throw throwable;
        }
        IOUtils.close(bufferedReader);
        return charArrayMap;
    }

    private static BufferedReader getBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }
}

