/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.Version;

public class StandardFilter
extends TokenFilter {
    private final Version matchVersion;
    private static final String APOSTROPHE_TYPE = ClassicTokenizer.TOKEN_TYPES[1];
    private static final String ACRONYM_TYPE = ClassicTokenizer.TOKEN_TYPES[2];
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    @Deprecated
    public StandardFilter(TokenStream tokenStream) {
        this(Version.LUCENE_30, tokenStream);
    }

    public StandardFilter(Version version, TokenStream tokenStream) {
        super(tokenStream);
        this.matchVersion = version;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            return this.input.incrementToken();
        }
        return this.incrementTokenClassic();
    }

    public final boolean incrementTokenClassic() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] cArray = this.termAtt.buffer();
        int n = this.termAtt.length();
        String string = this.typeAtt.type();
        if (string == APOSTROPHE_TYPE && n >= 2 && cArray[n - 2] == '\'' && (cArray[n - 1] == 's' || cArray[n - 1] == 'S')) {
            this.termAtt.setLength(n - 2);
        } else if (string == ACRONYM_TYPE) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                if (c == '.') continue;
                cArray[n2++] = c;
            }
            this.termAtt.setLength(n2);
        }
        return true;
    }
}

