/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.ByteBlockPool;

final class ByteSliceWriter {
    private byte[] slice;
    private int upto;
    private final ByteBlockPool pool;
    int offset0;

    public ByteSliceWriter(ByteBlockPool byteBlockPool) {
        this.pool = byteBlockPool;
    }

    public void init(int n) {
        this.slice = this.pool.buffers[n >> 15];
        assert (this.slice != null);
        this.upto = n & Short.MAX_VALUE;
        this.offset0 = n;
        assert (this.upto < this.slice.length);
    }

    public void writeByte(byte by) {
        assert (this.slice != null);
        if (this.slice[this.upto] != 0) {
            this.upto = this.pool.allocSlice(this.slice, this.upto);
            this.slice = this.pool.buffer;
            this.offset0 = this.pool.byteOffset;
            assert (this.slice != null);
        }
        this.slice[this.upto++] = by;
        assert (this.upto != this.slice.length);
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            if (this.slice[this.upto] != 0) {
                this.upto = this.pool.allocSlice(this.slice, this.upto);
                this.slice = this.pool.buffer;
                this.offset0 = this.pool.byteOffset;
            }
            this.slice[this.upto++] = byArray[n++];
            assert (this.upto != this.slice.length);
        }
    }

    public int getAddress() {
        return this.upto + (this.offset0 & Short.MIN_VALUE);
    }

    public void writeVInt(int n) {
        while ((n & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(n & 0x7F | 0x80));
            n >>>= 7;
        }
        this.writeByte((byte)n);
    }
}

