/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.StringHelper;

public class CheckIndex {
    private PrintStream infoStream;
    private Directory dir;
    private static boolean assertsOn;

    public CheckIndex(Directory directory) {
        this.dir = directory;
        this.infoStream = null;
    }

    public void setInfoStream(PrintStream printStream) {
        this.infoStream = printStream;
    }

    private void msg(String string) {
        if (this.infoStream != null) {
            this.infoStream.println(string);
        }
    }

    public Status checkIndex() throws IOException {
        return this.checkIndex(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status checkIndex(List<String> list) throws IOException {
        Object object;
        Object object222;
        NumberFormat numberFormat = NumberFormat.getInstance();
        SegmentInfos segmentInfos = new SegmentInfos();
        Status status = new Status();
        status.dir = this.dir;
        try {
            segmentInfos.read(this.dir);
        }
        catch (Throwable throwable) {
            this.msg("ERROR: could not read any segments file in directory");
            status.missingSegments = true;
            if (this.infoStream != null) {
                throwable.printStackTrace(this.infoStream);
            }
            return status;
        }
        Object object3 = Integer.toString(Integer.MAX_VALUE);
        Object object4 = Integer.toString(Integer.MIN_VALUE);
        String string = null;
        boolean bl = false;
        Comparator<String> comparator = StringHelper.getVersionComparator();
        for (Object object222 : segmentInfos) {
            object = ((SegmentInfo)object222).getVersion();
            if (object == null) {
                string = "pre-3.1";
                continue;
            }
            if (((String)object).equals("2.x")) {
                string = "2.x";
                continue;
            }
            bl = true;
            if (comparator.compare((String)object, (String)object3) < 0) {
                object3 = object;
            }
            if (comparator.compare((String)object, (String)object4) <= 0) continue;
            object4 = object;
        }
        int n = segmentInfos.size();
        object222 = segmentInfos.getCurrentSegmentFileName();
        object = null;
        try {
            object = this.dir.openInput((String)object222);
        }
        catch (Throwable throwable) {
            this.msg("ERROR: could not open segments file in directory");
            if (this.infoStream != null) {
                throwable.printStackTrace(this.infoStream);
            }
            status.cantOpenSegments = true;
            return status;
        }
        int n2 = 0;
        try {
            n2 = ((DataInput)object).readInt();
        }
        catch (Throwable throwable) {
            this.msg("ERROR: could not read segment file version in directory");
            if (this.infoStream != null) {
                throwable.printStackTrace(this.infoStream);
            }
            status.missingSegmentVersion = true;
            Status status2 = status;
            return status2;
        }
        finally {
            if (object != null) {
                ((IndexInput)object).close();
            }
        }
        String string2 = "";
        boolean bl2 = false;
        if (n2 == -1) {
            string2 = "FORMAT [Lucene Pre-2.1]";
        }
        if (n2 == -2) {
            string2 = "FORMAT_LOCKLESS [Lucene 2.1]";
        } else if (n2 == -3) {
            string2 = "FORMAT_SINGLE_NORM_FILE [Lucene 2.2]";
        } else if (n2 == -4) {
            string2 = "FORMAT_SHARED_DOC_STORE [Lucene 2.3]";
        } else if (n2 == -5) {
            string2 = "FORMAT_CHECKSUM [Lucene 2.4]";
        } else if (n2 == -6) {
            string2 = "FORMAT_DEL_COUNT [Lucene 2.4]";
        } else if (n2 == -7) {
            string2 = "FORMAT_HAS_PROX [Lucene 2.4]";
        } else if (n2 == -8) {
            string2 = "FORMAT_USER_DATA [Lucene 2.9]";
        } else if (n2 == -9) {
            string2 = "FORMAT_DIAGNOSTICS [Lucene 2.9]";
        } else if (n2 == -10) {
            string2 = "FORMAT_HAS_VECTORS [Lucene 3.1]";
        } else if (n2 == -11) {
            string2 = "FORMAT_3_1 [Lucene 3.1+]";
        } else {
            if (n2 == -11) {
                throw new RuntimeException("BUG: You should update this tool!");
            }
            if (n2 < -11) {
                string2 = "int=" + n2 + " [newer version of Lucene than this tool]";
                bl2 = true;
            } else {
                string2 = n2 + " [Lucene 1.3 or prior]";
            }
        }
        status.segmentsFileName = object222;
        status.numSegments = n;
        status.segmentFormat = string2;
        status.userData = segmentInfos.getUserData();
        String string3 = segmentInfos.getUserData().size() > 0 ? " userData=" + segmentInfos.getUserData() : "";
        String string4 = null;
        string4 = string != null ? (bl ? "versions=[" + string + " .. " + (String)object4 + "]" : "version=" + string) : (((String)object3).equals(object4) ? "version=" + (String)object3 : "versions=[" + (String)object3 + " .. " + (String)object4 + "]");
        this.msg("Segments file=" + (String)object222 + " numSegments=" + n + " " + string4 + " format=" + string2 + string3);
        if (list != null) {
            status.partial = true;
            if (this.infoStream != null) {
                this.infoStream.print("\nChecking only these segments:");
            }
            for (String object5 : list) {
                if (this.infoStream == null) continue;
                this.infoStream.print(" " + object5);
            }
            status.segmentsChecked.addAll(list);
            this.msg(":");
        }
        if (bl2) {
            this.msg("\nERROR: this index appears to be created by a newer version of Lucene than this tool was compiled on; please re-compile this tool on the matching version of Lucene; exiting");
            status.toolOutOfDate = true;
            return status;
        }
        status.newSegments = (SegmentInfos)segmentInfos.clone();
        status.newSegments.clear();
        status.maxSegmentName = -1;
        for (int i = 0; i < n; ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            int n3 = Integer.parseInt(segmentInfo.name.substring(1), 36);
            if (n3 > status.maxSegmentName) {
                status.maxSegmentName = n3;
            }
            if (list != null && !list.contains(segmentInfo.name)) continue;
            Status.SegmentInfoStatus segmentInfoStatus = new Status.SegmentInfoStatus();
            status.segmentInfos.add(segmentInfoStatus);
            this.msg("  " + (1 + i) + " of " + n + ": name=" + segmentInfo.name + " docCount=" + segmentInfo.docCount);
            segmentInfoStatus.name = segmentInfo.name;
            segmentInfoStatus.docCount = segmentInfo.docCount;
            int n4 = segmentInfo.docCount;
            IndexReader indexReader = null;
            try {
                int n5;
                String string5;
                int n6;
                this.msg("    compound=" + segmentInfo.getUseCompoundFile());
                segmentInfoStatus.compound = segmentInfo.getUseCompoundFile();
                this.msg("    hasProx=" + segmentInfo.getHasProx());
                segmentInfoStatus.hasProx = segmentInfo.getHasProx();
                this.msg("    numFiles=" + segmentInfo.files().size());
                segmentInfoStatus.numFiles = segmentInfo.files().size();
                segmentInfoStatus.sizeMB = (double)segmentInfo.sizeInBytes(true) / 1048576.0;
                this.msg("    size (MB)=" + numberFormat.format(segmentInfoStatus.sizeMB));
                Map<String, String> map = segmentInfo.getDiagnostics();
                segmentInfoStatus.diagnostics = map;
                if (map.size() > 0) {
                    this.msg("    diagnostics = " + map);
                }
                if ((n6 = segmentInfo.getDocStoreOffset()) != -1) {
                    this.msg("    docStoreOffset=" + n6);
                    segmentInfoStatus.docStoreOffset = n6;
                    this.msg("    docStoreSegment=" + segmentInfo.getDocStoreSegment());
                    segmentInfoStatus.docStoreSegment = segmentInfo.getDocStoreSegment();
                    this.msg("    docStoreIsCompoundFile=" + segmentInfo.getDocStoreIsCompoundFile());
                    segmentInfoStatus.docStoreCompoundFile = segmentInfo.getDocStoreIsCompoundFile();
                }
                if ((string5 = segmentInfo.getDelFileName()) == null) {
                    this.msg("    no deletions");
                    segmentInfoStatus.hasDeletions = false;
                } else {
                    this.msg("    has deletions [delFileName=" + string5 + "]");
                    segmentInfoStatus.hasDeletions = true;
                    segmentInfoStatus.deletionsFileName = string5;
                }
                if (this.infoStream != null) {
                    this.infoStream.print("    test: open reader.........");
                }
                indexReader = SegmentReader.get(true, segmentInfo, IndexReader.DEFAULT_TERMS_INDEX_DIVISOR);
                segmentInfoStatus.openReaderPassed = true;
                n4 = n5 = ((SegmentReader)indexReader).numDocs();
                if (((SegmentReader)indexReader).hasDeletions()) {
                    if (((SegmentReader)indexReader).deletedDocs.count() != segmentInfo.getDelCount()) {
                        throw new RuntimeException("delete count mismatch: info=" + segmentInfo.getDelCount() + " vs deletedDocs.count()=" + ((SegmentReader)indexReader).deletedDocs.count());
                    }
                    if (((SegmentReader)indexReader).deletedDocs.count() > ((SegmentReader)indexReader).maxDoc()) {
                        throw new RuntimeException("too many deleted docs: maxDoc()=" + ((SegmentReader)indexReader).maxDoc() + " vs deletedDocs.count()=" + ((SegmentReader)indexReader).deletedDocs.count());
                    }
                    if (segmentInfo.docCount - n5 != segmentInfo.getDelCount()) {
                        throw new RuntimeException("delete count mismatch: info=" + segmentInfo.getDelCount() + " vs reader=" + (segmentInfo.docCount - n5));
                    }
                    segmentInfoStatus.numDeleted = segmentInfo.docCount - n5;
                    this.msg("OK [" + segmentInfoStatus.numDeleted + " deleted docs]");
                } else {
                    if (segmentInfo.getDelCount() != 0) {
                        throw new RuntimeException("delete count mismatch: info=" + segmentInfo.getDelCount() + " vs reader=" + (segmentInfo.docCount - n5));
                    }
                    this.msg("OK");
                }
                if (((SegmentReader)indexReader).maxDoc() != segmentInfo.docCount) {
                    throw new RuntimeException("SegmentReader.maxDoc() " + ((SegmentReader)indexReader).maxDoc() + " != SegmentInfos.docCount " + segmentInfo.docCount);
                }
                if (this.infoStream != null) {
                    this.infoStream.print("    test: fields..............");
                }
                Collection<String> collection = ((SegmentReader)indexReader).getFieldNames(IndexReader.FieldOption.ALL);
                this.msg("OK [" + collection.size() + " fields]");
                segmentInfoStatus.numFields = collection.size();
                segmentInfoStatus.fieldNormStatus = this.testFieldNorms(collection, (SegmentReader)indexReader);
                segmentInfoStatus.termIndexStatus = this.testTermIndex(segmentInfo, (SegmentReader)indexReader);
                segmentInfoStatus.storedFieldStatus = this.testStoredFields(segmentInfo, (SegmentReader)indexReader, numberFormat);
                segmentInfoStatus.termVectorStatus = this.testTermVectors(segmentInfo, (SegmentReader)indexReader, numberFormat);
                if (segmentInfoStatus.fieldNormStatus.error != null) {
                    throw new RuntimeException("Field Norm test failed");
                }
                if (segmentInfoStatus.termIndexStatus.error != null) {
                    throw new RuntimeException("Term Index test failed");
                }
                if (segmentInfoStatus.storedFieldStatus.error != null) {
                    throw new RuntimeException("Stored Field test failed");
                }
                if (segmentInfoStatus.termVectorStatus.error != null) {
                    throw new RuntimeException("Term Vector test failed");
                }
                this.msg("");
            }
            catch (Throwable throwable) {
                this.msg("FAILED");
                String string6 = "fixIndex() would remove reference to this segment";
                this.msg("    WARNING: " + string6 + "; full exception:");
                if (this.infoStream != null) {
                    throwable.printStackTrace(this.infoStream);
                }
                this.msg("");
                status.totLoseDocCount += n4;
                ++status.numBadSegments;
                continue;
            }
            finally {
                if (indexReader != null) {
                    indexReader.close();
                }
            }
            status.newSegments.add((SegmentInfo)segmentInfo.clone());
        }
        if (0 == status.numBadSegments) {
            status.clean = true;
        } else {
            this.msg("WARNING: " + status.numBadSegments + " broken segments (containing " + status.totLoseDocCount + " documents) detected");
        }
        if (!(status.validCounter = status.maxSegmentName < segmentInfos.counter)) {
            status.clean = false;
            status.newSegments.counter = status.maxSegmentName + 1;
            this.msg("ERROR: Next segment name counter " + segmentInfos.counter + " is not greater than max segment name " + status.maxSegmentName);
        }
        if (status.clean) {
            this.msg("No problems were detected with this index.\n");
        }
        return status;
    }

    private Status.FieldNormStatus testFieldNorms(Collection<String> collection, SegmentReader segmentReader) {
        Status.FieldNormStatus fieldNormStatus;
        block4: {
            fieldNormStatus = new Status.FieldNormStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: field norms.........");
                }
                byte[] byArray = new byte[segmentReader.maxDoc()];
                for (String string : collection) {
                    if (!segmentReader.hasNorms(string)) continue;
                    segmentReader.norms(string, byArray, 0);
                    ++fieldNormStatus.totFields;
                }
                this.msg("OK [" + fieldNormStatus.totFields + " fields]");
            }
            catch (Throwable throwable) {
                this.msg("ERROR [" + String.valueOf(throwable.getMessage()) + "]");
                fieldNormStatus.error = throwable;
                if (this.infoStream == null) break block4;
                throwable.printStackTrace(this.infoStream);
            }
        }
        return fieldNormStatus;
    }

    private Status.TermIndexStatus testTermIndex(SegmentInfo segmentInfo, SegmentReader segmentReader) {
        Status.TermIndexStatus termIndexStatus;
        block25: {
            termIndexStatus = new Status.TermIndexStatus();
            IndexSearcher indexSearcher = new IndexSearcher(segmentReader);
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: terms, freq, prox...");
                }
                TermEnum termEnum = segmentReader.terms();
                TermPositions termPositions = segmentReader.termPositions();
                MySegmentTermDocs mySegmentTermDocs = new MySegmentTermDocs(segmentReader);
                int n = segmentReader.maxDoc();
                Term term = null;
                while (termEnum.next()) {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    Term term2;
                    ++termIndexStatus.termCount;
                    term = term2 = termEnum.term();
                    int n7 = termEnum.docFreq();
                    if (n7 <= 0) {
                        throw new RuntimeException("docfreq: " + n7 + " is out of bounds");
                    }
                    termPositions.seek(term2);
                    int n8 = -1;
                    int n9 = 0;
                    termIndexStatus.totFreq += (long)n7;
                    while (termPositions.next()) {
                        ++n9;
                        n6 = termPositions.doc();
                        n5 = termPositions.freq();
                        if (n6 <= n8) {
                            throw new RuntimeException("term " + term2 + ": doc " + n6 + " <= lastDoc " + n8);
                        }
                        if (n6 >= n) {
                            throw new RuntimeException("term " + term2 + ": doc " + n6 + " >= maxDoc " + n);
                        }
                        n8 = n6;
                        if (n5 <= 0) {
                            throw new RuntimeException("term " + term2 + ": doc " + n6 + ": freq " + n5 + " is out of bounds");
                        }
                        n4 = -1;
                        termIndexStatus.totPos += (long)n5;
                        for (n3 = 0; n3 < n5; ++n3) {
                            n2 = termPositions.nextPosition();
                            if (n2 < -1) {
                                throw new RuntimeException("term " + term2 + ": doc " + n6 + ": pos " + n2 + " is out of bounds");
                            }
                            if (n2 < n4) {
                                throw new RuntimeException("term " + term2 + ": doc " + n6 + ": pos " + n2 + " < lastPos " + n4);
                            }
                            n4 = n2;
                        }
                    }
                    for (n6 = 0; n6 < 7; ++n6) {
                        int n10;
                        n5 = (int)((long)(n6 + 1) * (long)n / 8L);
                        termPositions.seek(term2);
                        if (!termPositions.skipTo(n5)) break;
                        n4 = termPositions.doc();
                        if (n4 < n5) {
                            throw new RuntimeException("term " + term2 + ": skipTo(docID=" + n5 + ") returned docID=" + n4);
                        }
                        n3 = termPositions.freq();
                        if (n3 <= 0) {
                            throw new RuntimeException("termFreq " + n3 + " is out of bounds");
                        }
                        n2 = -1;
                        for (n10 = 0; n10 < n3; ++n10) {
                            int n11 = termPositions.nextPosition();
                            if (n11 < 0) {
                                throw new RuntimeException("position " + n11 + " is out of bounds");
                            }
                            if (n11 < n2) {
                                throw new RuntimeException("position " + n11 + " is < lastPosition " + n2);
                            }
                            n2 = n11;
                        }
                        if (!termPositions.next()) break;
                        n10 = termPositions.doc();
                        if (n10 > n4) continue;
                        throw new RuntimeException("term " + term2 + ": skipTo(docID=" + n5 + "), then .next() returned docID=" + n10 + " vs prev docID=" + n4);
                    }
                    if (segmentReader.hasDeletions()) {
                        mySegmentTermDocs.seek(term2);
                        while (mySegmentTermDocs.next()) {
                        }
                        n6 = mySegmentTermDocs.delCount;
                    } else {
                        n6 = 0;
                    }
                    if (n9 + n6 == n7) continue;
                    throw new RuntimeException("term " + term2 + " docFreq=" + n7 + " != num docs seen " + n9 + " + num docs deleted " + n6);
                }
                if (term != null) {
                    indexSearcher.search((Query)new TermQuery(term), 1);
                }
                try {
                    long l = segmentReader.getUniqueTermCount();
                    if (termIndexStatus.termCount != l) {
                        throw new RuntimeException("termCount mismatch " + l + " vs " + termIndexStatus.termCount);
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                this.msg("OK [" + termIndexStatus.termCount + " terms; " + termIndexStatus.totFreq + " terms/docs pairs; " + termIndexStatus.totPos + " tokens]");
            }
            catch (Throwable throwable) {
                this.msg("ERROR [" + String.valueOf(throwable.getMessage()) + "]");
                termIndexStatus.error = throwable;
                if (this.infoStream == null) break block25;
                throwable.printStackTrace(this.infoStream);
            }
        }
        return termIndexStatus;
    }

    private Status.StoredFieldStatus testStoredFields(SegmentInfo segmentInfo, SegmentReader segmentReader, NumberFormat numberFormat) {
        Status.StoredFieldStatus storedFieldStatus;
        block5: {
            storedFieldStatus = new Status.StoredFieldStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: stored fields.......");
                }
                for (int i = 0; i < segmentInfo.docCount; ++i) {
                    if (segmentReader.isDeleted(i)) continue;
                    ++storedFieldStatus.docCount;
                    Document document = segmentReader.document(i);
                    storedFieldStatus.totFields += (long)document.getFields().size();
                }
                if (storedFieldStatus.docCount != segmentReader.numDocs()) {
                    throw new RuntimeException("docCount=" + storedFieldStatus.docCount + " but saw " + storedFieldStatus.docCount + " undeleted docs");
                }
                this.msg("OK [" + storedFieldStatus.totFields + " total field count; avg " + numberFormat.format((float)storedFieldStatus.totFields / (float)storedFieldStatus.docCount) + " fields per doc]");
            }
            catch (Throwable throwable) {
                this.msg("ERROR [" + String.valueOf(throwable.getMessage()) + "]");
                storedFieldStatus.error = throwable;
                if (this.infoStream == null) break block5;
                throwable.printStackTrace(this.infoStream);
            }
        }
        return storedFieldStatus;
    }

    private Status.TermVectorStatus testTermVectors(SegmentInfo segmentInfo, SegmentReader segmentReader, NumberFormat numberFormat) {
        Status.TermVectorStatus termVectorStatus;
        block4: {
            termVectorStatus = new Status.TermVectorStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: term vectors........");
                }
                for (int i = 0; i < segmentInfo.docCount; ++i) {
                    if (segmentReader.isDeleted(i)) continue;
                    ++termVectorStatus.docCount;
                    TermFreqVector[] termFreqVectorArray = segmentReader.getTermFreqVectors(i);
                    if (termFreqVectorArray == null) continue;
                    termVectorStatus.totVectors += (long)termFreqVectorArray.length;
                }
                this.msg("OK [" + termVectorStatus.totVectors + " total vector count; avg " + numberFormat.format((float)termVectorStatus.totVectors / (float)termVectorStatus.docCount) + " term/freq vector fields per doc]");
            }
            catch (Throwable throwable) {
                this.msg("ERROR [" + String.valueOf(throwable.getMessage()) + "]");
                termVectorStatus.error = throwable;
                if (this.infoStream == null) break block4;
                throwable.printStackTrace(this.infoStream);
            }
        }
        return termVectorStatus;
    }

    public void fixIndex(Status status) throws IOException {
        if (status.partial) {
            throw new IllegalArgumentException("can only fix an index that was fully checked (this status checked a subset of segments)");
        }
        status.newSegments.changed();
        status.newSegments.commit(status.dir);
    }

    private static boolean testAsserts() {
        assertsOn = true;
        return true;
    }

    private static boolean assertsOn() {
        assert (CheckIndex.testAsserts());
        return assertsOn;
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        int n;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-fix")) {
                bl = true;
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-segment")) {
                if (n2 == stringArray.length - 1) {
                    System.out.println("ERROR: missing name for -segment option");
                    System.exit(1);
                }
                arrayList.add(stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (string != null) {
                System.out.println("ERROR: unexpected extra argument '" + stringArray[n2] + "'");
                System.exit(1);
            }
            string = stringArray[n2];
            ++n2;
        }
        if (string == null) {
            System.out.println("\nERROR: index path not specified");
            System.out.println("\nUsage: java org.apache.lucene.index.CheckIndex pathToIndex [-fix] [-segment X] [-segment Y]\n\n  -fix: actually write a new segments_N file, removing any problematic segments\n  -segment X: only check the specified segments.  This can be specified multiple\n              times, to check more than one segment, eg '-segment _2 -segment _a'.\n              You can't use this with the -fix option\n\n**WARNING**: -fix should only be used on an emergency basis as it will cause\ndocuments (perhaps many) to be permanently removed from the index.  Always make\na backup copy of your index before running this!  Do not run this tool on an index\nthat is actively being written to.  You have been warned!\n\nRun without -fix, this tool will open the index, report version information\nand report any exceptions it hits and what action it would take if -fix were\nspecified.  With -fix, this tool will remove any segments that have issues and\nwrite a new segments_N file.  This means all documents contained in the affected\nsegments will be removed.\n\nThis tool exits with exit code 1 if the index cannot be opened or has any\ncorruption, else 0.\n");
            System.exit(1);
        }
        if (!CheckIndex.assertsOn()) {
            System.out.println("\nNOTE: testing will be more thorough if you run java with '-ea:org.apache.lucene...', so assertions are enabled");
        }
        if (arrayList.size() == 0) {
            arrayList = null;
        } else if (bl) {
            System.out.println("ERROR: cannot specify both -fix and -segment");
            System.exit(1);
        }
        System.out.println("\nOpening index @ " + string + "\n");
        FSDirectory fSDirectory = null;
        try {
            fSDirectory = FSDirectory.open(new File(string));
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: could not open directory \"" + string + "\"; exiting");
            throwable.printStackTrace(System.out);
            System.exit(1);
        }
        CheckIndex checkIndex = new CheckIndex(fSDirectory);
        checkIndex.setInfoStream(System.out);
        Status status = checkIndex.checkIndex(arrayList);
        if (status.missingSegments) {
            System.exit(1);
        }
        if (!status.clean) {
            if (!bl) {
                System.out.println("WARNING: would write new segments file, and " + status.totLoseDocCount + " documents would be lost, if -fix were specified\n");
            } else {
                System.out.println("WARNING: " + status.totLoseDocCount + " documents will be lost\n");
                System.out.println("NOTE: will write new segments file in 5 seconds; this will remove " + status.totLoseDocCount + " docs from the index. THIS IS YOUR LAST CHANCE TO CTRL+C!");
                for (n = 0; n < 5; ++n) {
                    Thread.sleep(1000L);
                    System.out.println("  " + (5 - n) + "...");
                }
                System.out.println("Writing...");
                checkIndex.fixIndex(status);
                System.out.println("OK");
                System.out.println("Wrote new segments file \"" + status.newSegments.getCurrentSegmentFileName() + "\"");
            }
        }
        System.out.println("");
        n = status.clean ? 0 : 1;
        System.exit(n);
    }

    private static class MySegmentTermDocs
    extends SegmentTermDocs {
        int delCount;

        MySegmentTermDocs(SegmentReader segmentReader) {
            super(segmentReader);
        }

        @Override
        public void seek(Term term) throws IOException {
            super.seek(term);
            this.delCount = 0;
        }

        @Override
        protected void skippingDoc() throws IOException {
            ++this.delCount;
        }
    }

    public static class Status {
        public boolean clean;
        public boolean missingSegments;
        public boolean cantOpenSegments;
        public boolean missingSegmentVersion;
        public String segmentsFileName;
        public int numSegments;
        public String segmentFormat;
        public List<String> segmentsChecked = new ArrayList<String>();
        public boolean toolOutOfDate;
        public List<SegmentInfoStatus> segmentInfos = new ArrayList<SegmentInfoStatus>();
        public Directory dir;
        SegmentInfos newSegments;
        public int totLoseDocCount;
        public int numBadSegments;
        public boolean partial;
        public int maxSegmentName;
        public boolean validCounter;
        public Map<String, String> userData;

        public static final class TermVectorStatus {
            public int docCount = 0;
            public long totVectors = 0L;
            public Throwable error = null;
        }

        public static final class StoredFieldStatus {
            public int docCount = 0;
            public long totFields = 0L;
            public Throwable error = null;
        }

        public static final class TermIndexStatus {
            public long termCount = 0L;
            public long totFreq = 0L;
            public long totPos = 0L;
            public Throwable error = null;
        }

        public static final class FieldNormStatus {
            public long totFields = 0L;
            public Throwable error = null;
        }

        public static class SegmentInfoStatus {
            public String name;
            public int docCount;
            public boolean compound;
            public int numFiles;
            public double sizeMB;
            public int docStoreOffset = -1;
            public String docStoreSegment;
            public boolean docStoreCompoundFile;
            public boolean hasDeletions;
            public String deletionsFileName;
            public int numDeleted;
            public boolean openReaderPassed;
            int numFields;
            public boolean hasProx;
            public Map<String, String> diagnostics;
            public FieldNormStatus fieldNormStatus;
            public TermIndexStatus termIndexStatus;
            public StoredFieldStatus storedFieldStatus;
            public TermVectorStatus termVectorStatus;
        }
    }
}

