/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.index.DocFieldConsumer;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldProcessorPerThread;
import org.apache.lucene.index.DocInverterPerField;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.InvertedDocConsumer;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.InvertedDocConsumerPerThread;
import org.apache.lucene.index.InvertedDocEndConsumer;
import org.apache.lucene.index.InvertedDocEndConsumerPerField;
import org.apache.lucene.index.InvertedDocEndConsumerPerThread;
import org.apache.lucene.index.SegmentWriteState;

final class DocInverter
extends DocFieldConsumer {
    final InvertedDocConsumer consumer;
    final InvertedDocEndConsumer endConsumer;

    public DocInverter(InvertedDocConsumer invertedDocConsumer, InvertedDocEndConsumer invertedDocEndConsumer) {
        this.consumer = invertedDocConsumer;
        this.endConsumer = invertedDocEndConsumer;
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        super.setFieldInfos(fieldInfos);
        this.consumer.setFieldInfos(fieldInfos);
        this.endConsumer.setFieldInfos(fieldInfos);
    }

    @Override
    void flush(Map<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> map, SegmentWriteState segmentWriteState) throws IOException {
        HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>> hashMap = new HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>>();
        HashMap<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>> hashMap2 = new HashMap<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>>();
        for (Map.Entry<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> entry : map.entrySet()) {
            DocInverterPerThread docInverterPerThread = (DocInverterPerThread)entry.getKey();
            HashSet<InvertedDocConsumerPerField> hashSet = new HashSet<InvertedDocConsumerPerField>();
            HashSet<InvertedDocEndConsumerPerField> hashSet2 = new HashSet<InvertedDocEndConsumerPerField>();
            for (DocFieldConsumerPerField docFieldConsumerPerField : entry.getValue()) {
                DocInverterPerField docInverterPerField = (DocInverterPerField)docFieldConsumerPerField;
                hashSet.add(docInverterPerField.consumer);
                hashSet2.add(docInverterPerField.endConsumer);
            }
            hashMap.put(docInverterPerThread.consumer, hashSet);
            hashMap2.put(docInverterPerThread.endConsumer, hashSet2);
        }
        this.consumer.flush(hashMap, segmentWriteState);
        this.endConsumer.flush(hashMap2, segmentWriteState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void abort() {
        try {
            this.consumer.abort();
        }
        finally {
            this.endConsumer.abort();
        }
    }

    @Override
    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    @Override
    public DocFieldConsumerPerThread addThread(DocFieldProcessorPerThread docFieldProcessorPerThread) {
        return new DocInverterPerThread(docFieldProcessorPerThread, this);
    }
}

