/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.StringHelper;

final class FieldInfos {
    public static final int FORMAT_PRE = -1;
    public static final int FORMAT_START = -2;
    public static final int FORMAT_OMIT_POSITIONS = -3;
    static final int CURRENT_FORMAT = -3;
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte STORE_POSITIONS_WITH_TERMVECTOR = 4;
    static final byte STORE_OFFSET_WITH_TERMVECTOR = 8;
    static final byte OMIT_NORMS = 16;
    static final byte STORE_PAYLOADS = 32;
    static final byte OMIT_TERM_FREQ_AND_POSITIONS = 64;
    static final byte OMIT_POSITIONS = -128;
    private final ArrayList<FieldInfo> byNumber;
    private final HashMap<String, FieldInfo> byName;
    private int format;

    FieldInfos() {
        this.byNumber = new ArrayList();
        this.byName = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfos(Directory directory, String string) throws IOException {
        block8: {
            this.byNumber = new ArrayList();
            this.byName = new HashMap();
            IndexInput indexInput = directory.openInput(string);
            try {
                try {
                    this.read(indexInput, string);
                }
                catch (IOException iOException) {
                    if (this.format == -1) {
                        indexInput.seek(0L);
                        indexInput.setModifiedUTF8StringsMode();
                        this.byNumber.clear();
                        this.byName.clear();
                        try {
                            this.read(indexInput, string);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            throw iOException;
                        }
                    }
                    throw iOException;
                }
            }
            finally {
                indexInput.close();
            }
        }
    }

    public synchronized Object clone() {
        FieldInfos fieldInfos = new FieldInfos();
        int n = this.byNumber.size();
        for (int i = 0; i < n; ++i) {
            FieldInfo fieldInfo = (FieldInfo)this.byNumber.get(i).clone();
            fieldInfos.byNumber.add(fieldInfo);
            fieldInfos.byName.put(fieldInfo.name, fieldInfo);
        }
        return fieldInfos;
    }

    public synchronized void add(Document document) {
        List<Fieldable> list = document.getFields();
        for (Fieldable fieldable : list) {
            this.add(fieldable.name(), fieldable.isIndexed(), fieldable.isTermVectorStored(), fieldable.isStorePositionWithTermVector(), fieldable.isStoreOffsetWithTermVector(), fieldable.getOmitNorms(), false, fieldable.getIndexOptions());
        }
    }

    boolean hasProx() {
        int n = this.byNumber.size();
        for (int i = 0; i < n; ++i) {
            FieldInfo fieldInfo = this.fieldInfo(i);
            if (!fieldInfo.isIndexed || fieldInfo.indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) continue;
            return true;
        }
        return false;
    }

    public synchronized void addIndexed(Collection<String> collection, boolean bl, boolean bl2, boolean bl3) {
        for (String string : collection) {
            this.add(string, true, bl, bl2, bl3);
        }
    }

    public synchronized void add(Collection<String> collection, boolean bl) {
        for (String string : collection) {
            this.add(string, bl);
        }
    }

    public synchronized void add(String string, boolean bl) {
        this.add(string, bl, false, false, false, false);
    }

    public synchronized void add(String string, boolean bl, boolean bl2) {
        this.add(string, bl, bl2, false, false, false);
    }

    public synchronized void add(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.add(string, bl, bl2, bl3, bl4, false);
    }

    public synchronized void add(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.add(string, bl, bl2, bl3, bl4, bl5, false, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
    }

    public synchronized FieldInfo add(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, FieldInfo.IndexOptions indexOptions) {
        FieldInfo fieldInfo = this.fieldInfo(string);
        if (fieldInfo == null) {
            return this.addInternal(string, bl, bl2, bl3, bl4, bl5, bl6, indexOptions);
        }
        fieldInfo.update(bl, bl2, bl3, bl4, bl5, bl6, indexOptions);
        assert (fieldInfo.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS || !fieldInfo.storePayloads);
        return fieldInfo;
    }

    public synchronized FieldInfo add(FieldInfo fieldInfo) {
        return this.add(fieldInfo.name, fieldInfo.isIndexed, fieldInfo.storeTermVector, fieldInfo.storePositionWithTermVector, fieldInfo.storeOffsetWithTermVector, fieldInfo.omitNorms, fieldInfo.storePayloads, fieldInfo.indexOptions);
    }

    private FieldInfo addInternal(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, FieldInfo.IndexOptions indexOptions) {
        string = StringHelper.intern(string);
        FieldInfo fieldInfo = new FieldInfo(string, bl, this.byNumber.size(), bl2, bl3, bl4, bl5, bl6, indexOptions);
        this.byNumber.add(fieldInfo);
        this.byName.put(string, fieldInfo);
        return fieldInfo;
    }

    public int fieldNumber(String string) {
        FieldInfo fieldInfo = this.fieldInfo(string);
        return fieldInfo != null ? fieldInfo.number : -1;
    }

    public FieldInfo fieldInfo(String string) {
        return this.byName.get(string);
    }

    public String fieldName(int n) {
        FieldInfo fieldInfo = this.fieldInfo(n);
        return fieldInfo != null ? fieldInfo.name : "";
    }

    public FieldInfo fieldInfo(int n) {
        return n >= 0 ? this.byNumber.get(n) : null;
    }

    public int size() {
        return this.byNumber.size();
    }

    public boolean hasVectors() {
        boolean bl = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.fieldInfo((int)i).storeTermVector) continue;
            bl = true;
            break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Directory directory, String string) throws IOException {
        IndexOutput indexOutput = directory.createOutput(string);
        try {
            this.write(indexOutput);
        }
        finally {
            indexOutput.close();
        }
    }

    public void write(IndexOutput indexOutput) throws IOException {
        indexOutput.writeVInt(-3);
        indexOutput.writeVInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            FieldInfo fieldInfo = this.fieldInfo(i);
            assert (fieldInfo.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS || !fieldInfo.storePayloads);
            byte by = 0;
            if (fieldInfo.isIndexed) {
                by = (byte)(by | 1);
            }
            if (fieldInfo.storeTermVector) {
                by = (byte)(by | 2);
            }
            if (fieldInfo.storePositionWithTermVector) {
                by = (byte)(by | 4);
            }
            if (fieldInfo.storeOffsetWithTermVector) {
                by = (byte)(by | 8);
            }
            if (fieldInfo.omitNorms) {
                by = (byte)(by | 0x10);
            }
            if (fieldInfo.storePayloads) {
                by = (byte)(by | 0x20);
            }
            if (fieldInfo.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                by = (byte)(by | 0x40);
            } else if (fieldInfo.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS) {
                by = (byte)(by | 0xFFFFFF80);
            }
            indexOutput.writeString(fieldInfo.name);
            indexOutput.writeByte(by);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void read(IndexInput indexInput, String string) throws IOException {
        int n = indexInput.readVInt();
        this.format = n < 0 ? n : -1;
        if (this.format != -1 && this.format != -2 && this.format != -3) {
            throw new CorruptIndexException("unrecognized format " + this.format + " in file \"" + string + "\"");
        }
        int n2 = this.format == -1 ? n : indexInput.readVInt();
        for (int i = 0; i < n2; ++i) {
            FieldInfo.IndexOptions indexOptions;
            boolean bl;
            String string2 = StringHelper.intern(indexInput.readString());
            byte by = indexInput.readByte();
            boolean bl2 = (by & 1) != 0;
            boolean bl3 = (by & 2) != 0;
            boolean bl4 = (by & 4) != 0;
            boolean bl5 = (by & 8) != 0;
            boolean bl6 = (by & 0x10) != 0;
            boolean bl7 = bl = (by & 0x20) != 0;
            if ((by & 0x40) != 0) {
                indexOptions = FieldInfo.IndexOptions.DOCS_ONLY;
            } else if ((by & 0xFFFFFF80) != 0) {
                if (this.format > -3) throw new CorruptIndexException("Corrupt fieldinfos, OMIT_POSITIONS set but format=" + this.format + " (resource: " + indexInput + ")");
                indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS;
            } else {
                indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            if (indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                bl = false;
            }
            this.addInternal(string2, bl2, bl3, bl4, bl5, bl6, bl, indexOptions);
        }
        if (indexInput.getFilePointer() == indexInput.length()) return;
        throw new CorruptIndexException("did not read all bytes from file \"" + string + "\": read " + indexInput.getFilePointer() + " vs size " + indexInput.length() + " (resource: " + indexInput + ")");
    }
}

