/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.index.TermVectorEntry;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;

public class FieldSortedTermVectorMapper
extends TermVectorMapper {
    private Map<String, SortedSet<TermVectorEntry>> fieldToTerms = new HashMap<String, SortedSet<TermVectorEntry>>();
    private SortedSet<TermVectorEntry> currentSet;
    private String currentField;
    private Comparator<TermVectorEntry> comparator;

    public FieldSortedTermVectorMapper(Comparator<TermVectorEntry> comparator) {
        this(false, false, comparator);
    }

    public FieldSortedTermVectorMapper(boolean bl, boolean bl2, Comparator<TermVectorEntry> comparator) {
        super(bl, bl2);
        this.comparator = comparator;
    }

    @Override
    public void map(String string, int n, TermVectorOffsetInfo[] termVectorOffsetInfoArray, int[] nArray) {
        TermVectorEntry termVectorEntry = new TermVectorEntry(this.currentField, string, n, termVectorOffsetInfoArray, nArray);
        this.currentSet.add(termVectorEntry);
    }

    @Override
    public void setExpectations(String string, int n, boolean bl, boolean bl2) {
        this.currentSet = new TreeSet<TermVectorEntry>(this.comparator);
        this.currentField = string;
        this.fieldToTerms.put(string, this.currentSet);
    }

    public Map<String, SortedSet<TermVectorEntry>> getFieldToTerms() {
        return this.fieldToTerms;
    }

    public Comparator<TermVectorEntry> getComparator() {
        return this.comparator;
    }
}

