/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.FreqProxTermsWriterPerThread;
import org.apache.lucene.index.ParallelPostingsArray;
import org.apache.lucene.index.Payload;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashPerField;

final class FreqProxTermsWriterPerField
extends TermsHashConsumerPerField
implements Comparable<FreqProxTermsWriterPerField> {
    final FreqProxTermsWriterPerThread perThread;
    final TermsHashPerField termsHashPerField;
    final FieldInfo fieldInfo;
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState;
    FieldInfo.IndexOptions indexOptions;
    PayloadAttribute payloadAttribute;
    boolean hasPayloads;

    public FreqProxTermsWriterPerField(TermsHashPerField termsHashPerField, FreqProxTermsWriterPerThread freqProxTermsWriterPerThread, FieldInfo fieldInfo) {
        this.termsHashPerField = termsHashPerField;
        this.perThread = freqProxTermsWriterPerThread;
        this.fieldInfo = fieldInfo;
        this.docState = termsHashPerField.docState;
        this.fieldState = termsHashPerField.fieldState;
        this.indexOptions = fieldInfo.indexOptions;
    }

    @Override
    int getStreamCount() {
        if (this.fieldInfo.indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
            return 1;
        }
        return 2;
    }

    @Override
    void finish() {
    }

    @Override
    void skippingLongTerm() throws IOException {
    }

    @Override
    public int compareTo(FreqProxTermsWriterPerField freqProxTermsWriterPerField) {
        return this.fieldInfo.name.compareTo(freqProxTermsWriterPerField.fieldInfo.name);
    }

    void reset() {
        this.indexOptions = this.fieldInfo.indexOptions;
        this.payloadAttribute = null;
    }

    @Override
    boolean start(Fieldable[] fieldableArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (!fieldableArray[i].isIndexed()) continue;
            return true;
        }
        return false;
    }

    @Override
    void start(Fieldable fieldable) {
        this.payloadAttribute = this.fieldState.attributeSource.hasAttribute(PayloadAttribute.class) ? this.fieldState.attributeSource.getAttribute(PayloadAttribute.class) : null;
    }

    void writeProx(int n, int n2) {
        Payload payload = this.payloadAttribute == null ? null : this.payloadAttribute.getPayload();
        if (payload != null && payload.length > 0) {
            this.termsHashPerField.writeVInt(1, n2 << 1 | 1);
            this.termsHashPerField.writeVInt(1, payload.length);
            this.termsHashPerField.writeBytes(1, payload.data, payload.offset, payload.length);
            this.hasPayloads = true;
        } else {
            this.termsHashPerField.writeVInt(1, n2 << 1);
        }
        FreqProxPostingsArray freqProxPostingsArray = (FreqProxPostingsArray)this.termsHashPerField.postingsArray;
        freqProxPostingsArray.lastPositions[n] = this.fieldState.position;
    }

    @Override
    void newTerm(int n) {
        assert (this.docState.testPoint("FreqProxTermsWriterPerField.newTerm start"));
        FreqProxPostingsArray freqProxPostingsArray = (FreqProxPostingsArray)this.termsHashPerField.postingsArray;
        freqProxPostingsArray.lastDocIDs[n] = this.docState.docID;
        if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
            freqProxPostingsArray.lastDocCodes[n] = this.docState.docID;
        } else {
            freqProxPostingsArray.lastDocCodes[n] = this.docState.docID << 1;
            freqProxPostingsArray.docFreqs[n] = 1;
            if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                this.writeProx(n, this.fieldState.position);
            }
        }
        this.fieldState.maxTermFrequency = Math.max(1, this.fieldState.maxTermFrequency);
        ++this.fieldState.uniqueTermCount;
    }

    @Override
    void addTerm(int n) {
        assert (this.docState.testPoint("FreqProxTermsWriterPerField.addTerm start"));
        FreqProxPostingsArray freqProxPostingsArray = (FreqProxPostingsArray)this.termsHashPerField.postingsArray;
        assert (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY || freqProxPostingsArray.docFreqs[n] > 0);
        if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
            if (this.docState.docID != freqProxPostingsArray.lastDocIDs[n]) {
                assert (this.docState.docID > freqProxPostingsArray.lastDocIDs[n]);
                this.termsHashPerField.writeVInt(0, freqProxPostingsArray.lastDocCodes[n]);
                freqProxPostingsArray.lastDocCodes[n] = this.docState.docID - freqProxPostingsArray.lastDocIDs[n];
                freqProxPostingsArray.lastDocIDs[n] = this.docState.docID;
                ++this.fieldState.uniqueTermCount;
            }
        } else if (this.docState.docID != freqProxPostingsArray.lastDocIDs[n]) {
            assert (this.docState.docID > freqProxPostingsArray.lastDocIDs[n]);
            if (1 == freqProxPostingsArray.docFreqs[n]) {
                this.termsHashPerField.writeVInt(0, freqProxPostingsArray.lastDocCodes[n] | 1);
            } else {
                this.termsHashPerField.writeVInt(0, freqProxPostingsArray.lastDocCodes[n]);
                this.termsHashPerField.writeVInt(0, freqProxPostingsArray.docFreqs[n]);
            }
            freqProxPostingsArray.docFreqs[n] = 1;
            this.fieldState.maxTermFrequency = Math.max(1, this.fieldState.maxTermFrequency);
            freqProxPostingsArray.lastDocCodes[n] = this.docState.docID - freqProxPostingsArray.lastDocIDs[n] << 1;
            freqProxPostingsArray.lastDocIDs[n] = this.docState.docID;
            if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                this.writeProx(n, this.fieldState.position);
            }
            ++this.fieldState.uniqueTermCount;
        } else {
            int n2 = n;
            int n3 = freqProxPostingsArray.docFreqs[n2] + 1;
            freqProxPostingsArray.docFreqs[n2] = n3;
            this.fieldState.maxTermFrequency = Math.max(this.fieldState.maxTermFrequency, n3);
            if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                this.writeProx(n, this.fieldState.position - freqProxPostingsArray.lastPositions[n]);
            }
        }
    }

    @Override
    ParallelPostingsArray createPostingsArray(int n) {
        return new FreqProxPostingsArray(n);
    }

    public void abort() {
    }

    static final class FreqProxPostingsArray
    extends ParallelPostingsArray {
        int[] docFreqs;
        int[] lastDocIDs;
        int[] lastDocCodes;
        int[] lastPositions;

        public FreqProxPostingsArray(int n) {
            super(n);
            this.docFreqs = new int[n];
            this.lastDocIDs = new int[n];
            this.lastDocCodes = new int[n];
            this.lastPositions = new int[n];
        }

        @Override
        ParallelPostingsArray newInstance(int n) {
            return new FreqProxPostingsArray(n);
        }

        @Override
        void copyTo(ParallelPostingsArray parallelPostingsArray, int n) {
            assert (parallelPostingsArray instanceof FreqProxPostingsArray);
            FreqProxPostingsArray freqProxPostingsArray = (FreqProxPostingsArray)parallelPostingsArray;
            super.copyTo(parallelPostingsArray, n);
            System.arraycopy(this.docFreqs, 0, freqProxPostingsArray.docFreqs, 0, n);
            System.arraycopy(this.lastDocIDs, 0, freqProxPostingsArray.lastDocIDs, 0, n);
            System.arraycopy(this.lastDocCodes, 0, freqProxPostingsArray.lastDocCodes, 0, n);
            System.arraycopy(this.lastPositions, 0, freqProxPostingsArray.lastPositions, 0, n);
        }

        @Override
        int bytesPerPosting() {
            return 28;
        }
    }
}

