/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;

public abstract class LogMergePolicy
extends MergePolicy {
    public static final double LEVEL_LOG_SPAN = 0.75;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final double DEFAULT_NO_CFS_RATIO = 0.1;
    protected int mergeFactor = 10;
    protected long minMergeSize;
    protected long maxMergeSize;
    protected long maxMergeSizeForForcedMerge = Long.MAX_VALUE;
    protected int maxMergeDocs = Integer.MAX_VALUE;
    protected double noCFSRatio = 0.1;
    protected boolean calibrateSizeByDeletes = true;
    protected boolean useCompoundFile = true;

    protected boolean verbose() {
        IndexWriter indexWriter = (IndexWriter)this.writer.get();
        return indexWriter != null && indexWriter.verbose();
    }

    public double getNoCFSRatio() {
        return this.noCFSRatio;
    }

    public void setNoCFSRatio(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("noCFSRatio must be 0.0 to 1.0 inclusive; got " + d);
        }
        this.noCFSRatio = d;
    }

    protected void message(String string) {
        if (this.verbose()) {
            ((IndexWriter)this.writer.get()).message("LMP: " + string);
        }
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("mergeFactor cannot be less than 2");
        }
        this.mergeFactor = n;
    }

    @Override
    public boolean useCompoundFile(SegmentInfos segmentInfos, SegmentInfo segmentInfo) throws IOException {
        boolean bl;
        if (!this.useCompoundFile) {
            bl = false;
        } else if (this.noCFSRatio == 1.0) {
            bl = true;
        } else {
            long l = 0L;
            for (SegmentInfo segmentInfo2 : segmentInfos) {
                l += this.size(segmentInfo2);
            }
            bl = (double)this.size(segmentInfo) <= this.noCFSRatio * (double)l;
        }
        return bl;
    }

    public void setUseCompoundFile(boolean bl) {
        this.useCompoundFile = bl;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setCalibrateSizeByDeletes(boolean bl) {
        this.calibrateSizeByDeletes = bl;
    }

    public boolean getCalibrateSizeByDeletes() {
        return this.calibrateSizeByDeletes;
    }

    @Override
    public void close() {
    }

    protected abstract long size(SegmentInfo var1) throws IOException;

    protected long sizeDocs(SegmentInfo segmentInfo) throws IOException {
        if (this.calibrateSizeByDeletes) {
            int n = ((IndexWriter)this.writer.get()).numDeletedDocs(segmentInfo);
            assert (n <= segmentInfo.docCount);
            return (long)segmentInfo.docCount - (long)n;
        }
        return segmentInfo.docCount;
    }

    protected long sizeBytes(SegmentInfo segmentInfo) throws IOException {
        long l = segmentInfo.sizeInBytes(true);
        if (this.calibrateSizeByDeletes) {
            int n = ((IndexWriter)this.writer.get()).numDeletedDocs(segmentInfo);
            double d = segmentInfo.docCount <= 0 ? 0.0f : (float)n / (float)segmentInfo.docCount;
            assert (d <= 1.0);
            return segmentInfo.docCount <= 0 ? l : (long)((double)l * (1.0 - d));
        }
        return l;
    }

    protected boolean isMerged(SegmentInfos segmentInfos, int n, Map<SegmentInfo, Boolean> map) throws IOException {
        int n2 = segmentInfos.size();
        int n3 = 0;
        SegmentInfo segmentInfo = null;
        boolean bl = false;
        for (int i = 0; i < n2 && n3 <= n; ++i) {
            SegmentInfo segmentInfo2 = segmentInfos.info(i);
            Boolean bl2 = map.get(segmentInfo2);
            if (bl2 == null) continue;
            bl = bl2;
            ++n3;
            segmentInfo = segmentInfo2;
        }
        return n3 <= n && (n3 != 1 || !bl || this.isMerged(segmentInfo));
    }

    protected boolean isMerged(SegmentInfo segmentInfo) throws IOException {
        IndexWriter indexWriter = (IndexWriter)this.writer.get();
        assert (indexWriter != null);
        boolean bl = indexWriter.numDeletedDocs(segmentInfo) > 0;
        return !bl && !segmentInfo.hasSeparateNorms() && segmentInfo.dir == indexWriter.getDirectory() && (segmentInfo.getUseCompoundFile() == this.useCompoundFile || this.noCFSRatio < 1.0);
    }

    private MergePolicy.MergeSpecification findForcedMergesSizeLimit(SegmentInfos segmentInfos, int n, int n2) throws IOException {
        int n3;
        MergePolicy.MergeSpecification mergeSpecification = new MergePolicy.MergeSpecification();
        List<SegmentInfo> list = segmentInfos.asList();
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            SegmentInfo segmentInfo = segmentInfos.info(n3);
            if (this.size(segmentInfo) > this.maxMergeSizeForForcedMerge || this.sizeDocs(segmentInfo) > (long)this.maxMergeDocs) {
                if (this.verbose()) {
                    this.message("findForcedMergesSizeLimit: skip segment=" + segmentInfo + ": size is > maxMergeSize (" + this.maxMergeSizeForForcedMerge + ") or sizeDocs is > maxMergeDocs (" + this.maxMergeDocs + ")");
                }
                if (n2 - n3 - 1 > 1 || n3 != n2 - 1 && !this.isMerged(segmentInfos.info(n3 + 1))) {
                    mergeSpecification.add(new MergePolicy.OneMerge(list.subList(n3 + 1, n2)));
                }
                n2 = n3;
                continue;
            }
            if (n2 - n3 != this.mergeFactor) continue;
            mergeSpecification.add(new MergePolicy.OneMerge(list.subList(n3, n2)));
            n2 = n3;
        }
        if (!(n2 <= 0 || ++n3 + 1 >= n2 && this.isMerged(segmentInfos.info(n3)))) {
            mergeSpecification.add(new MergePolicy.OneMerge(list.subList(n3, n2)));
        }
        return mergeSpecification.merges.size() == 0 ? null : mergeSpecification;
    }

    private MergePolicy.MergeSpecification findForcedMergesMaxNumSegments(SegmentInfos segmentInfos, int n, int n2) throws IOException {
        MergePolicy.MergeSpecification mergeSpecification = new MergePolicy.MergeSpecification();
        List<SegmentInfo> list = segmentInfos.asList();
        while (n2 - n + 1 >= this.mergeFactor) {
            mergeSpecification.add(new MergePolicy.OneMerge(list.subList(n2 - this.mergeFactor, n2)));
            n2 -= this.mergeFactor;
        }
        if (0 == mergeSpecification.merges.size()) {
            if (n == 1) {
                if (n2 > 1 || !this.isMerged(segmentInfos.info(0))) {
                    mergeSpecification.add(new MergePolicy.OneMerge(list.subList(0, n2)));
                }
            } else if (n2 > n) {
                int n3 = n2 - n + 1;
                long l = 0L;
                int n4 = 0;
                for (int i = 0; i < n2 - n3 + 1; ++i) {
                    long l2 = 0L;
                    for (int j = 0; j < n3; ++j) {
                        l2 += this.size(segmentInfos.info(j + i));
                    }
                    if (i != 0 && (l2 >= 2L * this.size(segmentInfos.info(i - 1)) || l2 >= l)) continue;
                    n4 = i;
                    l = l2;
                }
                mergeSpecification.add(new MergePolicy.OneMerge(list.subList(n4, n4 + n3)));
            }
        }
        return mergeSpecification.merges.size() == 0 ? null : mergeSpecification;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int n, Map<SegmentInfo, Boolean> map) throws IOException {
        assert (n > 0);
        if (this.verbose()) {
            this.message("findForcedMerges: maxNumSegs=" + n + " segsToMerge=" + map);
        }
        if (this.isMerged(segmentInfos, n, map)) {
            if (this.verbose()) {
                this.message("already merged; skip");
            }
            return null;
        }
        int n2 = segmentInfos.size();
        while (n2 > 0) {
            SegmentInfo segmentInfo;
            if (map.get(segmentInfo = segmentInfos.info(--n2)) == null) continue;
            ++n2;
            break;
        }
        if (n2 == 0) {
            return null;
        }
        if (n == 1 && n2 == 1 && this.isMerged(segmentInfos.info(0))) {
            if (this.verbose()) {
                this.message("already 1 seg; skip");
            }
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            if (this.size(segmentInfo) <= this.maxMergeSizeForForcedMerge && this.sizeDocs(segmentInfo) <= (long)this.maxMergeDocs) continue;
            bl = true;
            break;
        }
        if (bl) {
            return this.findForcedMergesSizeLimit(segmentInfos, n, n2);
        }
        return this.findForcedMergesMaxNumSegments(segmentInfos, n, n2);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos) throws CorruptIndexException, IOException {
        List<SegmentInfo> list = segmentInfos.asList();
        int n = list.size();
        if (this.verbose()) {
            this.message("findForcedDeleteMerges: " + n + " segments");
        }
        MergePolicy.MergeSpecification mergeSpecification = new MergePolicy.MergeSpecification();
        int n2 = -1;
        IndexWriter indexWriter = (IndexWriter)this.writer.get();
        assert (indexWriter != null);
        for (int i = 0; i < n; ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            int n3 = indexWriter.numDeletedDocs(segmentInfo);
            if (n3 > 0) {
                if (this.verbose()) {
                    this.message("  segment " + segmentInfo.name + " has deletions");
                }
                if (n2 == -1) {
                    n2 = i;
                    continue;
                }
                if (i - n2 != this.mergeFactor) continue;
                if (this.verbose()) {
                    this.message("  add merge " + n2 + " to " + (i - 1) + " inclusive");
                }
                mergeSpecification.add(new MergePolicy.OneMerge(list.subList(n2, i)));
                n2 = i;
                continue;
            }
            if (n2 == -1) continue;
            if (this.verbose()) {
                this.message("  add merge " + n2 + " to " + (i - 1) + " inclusive");
            }
            mergeSpecification.add(new MergePolicy.OneMerge(list.subList(n2, i)));
            n2 = -1;
        }
        if (n2 != -1) {
            if (this.verbose()) {
                this.message("  add merge " + n2 + " to " + (n - 1) + " inclusive");
            }
            mergeSpecification.add(new MergePolicy.OneMerge(list.subList(n2, n)));
        }
        return mergeSpecification;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(SegmentInfos segmentInfos) throws IOException {
        Object object;
        int n = segmentInfos.size();
        if (this.verbose()) {
            this.message("findMerges: " + n + " segments");
        }
        ArrayList<SegmentInfoAndLevel> arrayList = new ArrayList<SegmentInfoAndLevel>();
        float f = (float)Math.log(this.mergeFactor);
        Collection<SegmentInfo> collection = ((IndexWriter)this.writer.get()).getMergingSegments();
        for (int i = 0; i < n; ++i) {
            String string;
            object = segmentInfos.info(i);
            long l = this.size((SegmentInfo)object);
            if (l < 1L) {
                l = 1L;
            }
            SegmentInfoAndLevel segmentInfoAndLevel = new SegmentInfoAndLevel((SegmentInfo)object, (float)Math.log(l) / f, i);
            arrayList.add(segmentInfoAndLevel);
            if (!this.verbose()) continue;
            long l2 = this.sizeBytes((SegmentInfo)object);
            String string2 = string = collection.contains(object) ? " [merging]" : "";
            if (l >= this.maxMergeSize) {
                string = string + " [skip: too large]";
            }
            this.message("seg=" + ((IndexWriter)this.writer.get()).segString((SegmentInfo)object) + " level=" + segmentInfoAndLevel.level + " size=" + String.format("%.3f MB", (double)(l2 / 1024L) / 1024.0) + string);
        }
        float f2 = this.minMergeSize <= 0L ? 0.0f : (float)(Math.log(this.minMergeSize) / (double)f);
        object = null;
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            float f3;
            float f4 = ((SegmentInfoAndLevel)arrayList.get((int)n3)).level;
            for (int i = 1 + n3; i < n2; ++i) {
                float f5 = ((SegmentInfoAndLevel)arrayList.get((int)i)).level;
                if (!(f5 > f4)) continue;
                f4 = f5;
            }
            if (f4 <= f2) {
                f3 = -1.0f;
            } else {
                f3 = (float)((double)f4 - 0.75);
                if (f3 < f2 && f4 >= f2) {
                    f3 = f2;
                }
            }
            for (n4 = n2 - 1; n4 >= n3 && !(((SegmentInfoAndLevel)arrayList.get((int)n4)).level >= f3); --n4) {
            }
            if (this.verbose()) {
                this.message("  level " + f3 + " to " + f4 + ": " + (1 + n4 - n3) + " segments");
            }
            int n5 = n3 + this.mergeFactor;
            while (n5 <= 1 + n4) {
                boolean bl = false;
                boolean bl2 = false;
                for (int i = n3; i < n5; ++i) {
                    SegmentInfo segmentInfo = ((SegmentInfoAndLevel)arrayList.get((int)i)).info;
                    bl |= this.size(segmentInfo) >= this.maxMergeSize || this.sizeDocs(segmentInfo) >= (long)this.maxMergeDocs;
                    if (!collection.contains(segmentInfo)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (!bl) {
                        if (object == null) {
                            object = new MergePolicy.MergeSpecification();
                        }
                        ArrayList<SegmentInfo> arrayList2 = new ArrayList<SegmentInfo>();
                        for (int i = n3; i < n5; ++i) {
                            arrayList2.add(((SegmentInfoAndLevel)arrayList.get((int)i)).info);
                            assert (segmentInfos.contains(((SegmentInfoAndLevel)arrayList.get((int)i)).info));
                        }
                        if (this.verbose()) {
                            this.message("  add merge=" + ((IndexWriter)this.writer.get()).segString(arrayList2) + " start=" + n3 + " end=" + n5);
                        }
                        ((MergePolicy.MergeSpecification)object).add(new MergePolicy.OneMerge(arrayList2));
                    } else if (this.verbose()) {
                        this.message("    " + n3 + " to " + n5 + ": contains segment over maxMergeSize or maxMergeDocs; skipping");
                    }
                }
                n3 = n5;
                n5 = n3 + this.mergeFactor;
            }
            n3 = 1 + n4;
        }
        return object;
    }

    public void setMaxMergeDocs(int n) {
        this.maxMergeDocs = n;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[" + this.getClass().getSimpleName() + ": ");
        stringBuilder.append("minMergeSize=").append(this.minMergeSize).append(", ");
        stringBuilder.append("mergeFactor=").append(this.mergeFactor).append(", ");
        stringBuilder.append("maxMergeSize=").append(this.maxMergeSize).append(", ");
        stringBuilder.append("maxMergeSizeForForcedMerge=").append(this.maxMergeSizeForForcedMerge).append(", ");
        stringBuilder.append("calibrateSizeByDeletes=").append(this.calibrateSizeByDeletes).append(", ");
        stringBuilder.append("maxMergeDocs=").append(this.maxMergeDocs).append(", ");
        stringBuilder.append("useCompoundFile=").append(this.useCompoundFile).append(", ");
        stringBuilder.append("noCFSRatio=").append(this.noCFSRatio);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static class SegmentInfoAndLevel
    implements Comparable<SegmentInfoAndLevel> {
        SegmentInfo info;
        float level;
        int index;

        public SegmentInfoAndLevel(SegmentInfo segmentInfo, float f, int n) {
            this.info = segmentInfo;
            this.level = f;
            this.index = n;
        }

        @Override
        public int compareTo(SegmentInfoAndLevel segmentInfoAndLevel) {
            if (this.level < segmentInfoAndLevel.level) {
                return 1;
            }
            if (this.level > segmentInfoAndLevel.level) {
                return -1;
            }
            return 0;
        }
    }
}

