/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.IndexInput;

abstract class MultiLevelSkipListReader {
    private int maxNumberOfSkipLevels;
    private int numberOfSkipLevels;
    private int numberOfLevelsToBuffer = 1;
    private int docCount;
    private boolean haveSkipped;
    private IndexInput[] skipStream;
    private long[] skipPointer;
    private int[] skipInterval;
    private int[] numSkipped;
    private int[] skipDoc;
    private int lastDoc;
    private long[] childPointer;
    private long lastChildPointer;
    private boolean inputIsBuffered;

    public MultiLevelSkipListReader(IndexInput indexInput, int n, int n2) {
        this.skipStream = new IndexInput[n];
        this.skipPointer = new long[n];
        this.childPointer = new long[n];
        this.numSkipped = new int[n];
        this.maxNumberOfSkipLevels = n;
        this.skipInterval = new int[n];
        this.skipStream[0] = indexInput;
        this.inputIsBuffered = indexInput instanceof BufferedIndexInput;
        this.skipInterval[0] = n2;
        for (int i = 1; i < n; ++i) {
            this.skipInterval[i] = this.skipInterval[i - 1] * n2;
        }
        this.skipDoc = new int[n];
    }

    int getDoc() {
        return this.lastDoc;
    }

    int skipTo(int n) throws IOException {
        int n2;
        if (!this.haveSkipped) {
            this.loadSkipLevels();
            this.haveSkipped = true;
        }
        for (n2 = 0; n2 < this.numberOfSkipLevels - 1 && n > this.skipDoc[n2 + 1]; ++n2) {
        }
        while (n2 >= 0) {
            if (n > this.skipDoc[n2]) {
                if (this.loadNextSkip(n2)) continue;
                continue;
            }
            if (n2 > 0 && this.lastChildPointer > this.skipStream[n2 - 1].getFilePointer()) {
                this.seekChild(n2 - 1);
            }
            --n2;
        }
        return this.numSkipped[0] - this.skipInterval[0] - 1;
    }

    private boolean loadNextSkip(int n) throws IOException {
        this.setLastSkipData(n);
        int n2 = n;
        this.numSkipped[n2] = this.numSkipped[n2] + this.skipInterval[n];
        if (this.numSkipped[n] > this.docCount) {
            this.skipDoc[n] = Integer.MAX_VALUE;
            if (this.numberOfSkipLevels > n) {
                this.numberOfSkipLevels = n;
            }
            return false;
        }
        int n3 = n;
        this.skipDoc[n3] = this.skipDoc[n3] + this.readSkipData(n, this.skipStream[n]);
        if (n != 0) {
            this.childPointer[n] = this.skipStream[n].readVLong() + this.skipPointer[n - 1];
        }
        return true;
    }

    protected void seekChild(int n) throws IOException {
        this.skipStream[n].seek(this.lastChildPointer);
        this.numSkipped[n] = this.numSkipped[n + 1] - this.skipInterval[n + 1];
        this.skipDoc[n] = this.lastDoc;
        if (n > 0) {
            this.childPointer[n] = this.skipStream[n].readVLong() + this.skipPointer[n - 1];
        }
    }

    void close() throws IOException {
        for (int i = 1; i < this.skipStream.length; ++i) {
            if (this.skipStream[i] == null) continue;
            this.skipStream[i].close();
        }
    }

    void init(long l, int n) {
        this.skipPointer[0] = l;
        this.docCount = n;
        Arrays.fill(this.skipDoc, 0);
        Arrays.fill(this.numSkipped, 0);
        Arrays.fill(this.childPointer, 0L);
        this.haveSkipped = false;
        for (int i = 1; i < this.numberOfSkipLevels; ++i) {
            this.skipStream[i] = null;
        }
    }

    private void loadSkipLevels() throws IOException {
        int n = this.numberOfSkipLevels = this.docCount == 0 ? 0 : (int)Math.floor(Math.log(this.docCount) / Math.log(this.skipInterval[0]));
        if (this.numberOfSkipLevels > this.maxNumberOfSkipLevels) {
            this.numberOfSkipLevels = this.maxNumberOfSkipLevels;
        }
        this.skipStream[0].seek(this.skipPointer[0]);
        int n2 = this.numberOfLevelsToBuffer;
        for (int i = this.numberOfSkipLevels - 1; i > 0; --i) {
            long l = this.skipStream[0].readVLong();
            this.skipPointer[i] = this.skipStream[0].getFilePointer();
            if (n2 > 0) {
                this.skipStream[i] = new SkipBuffer(this.skipStream[0], (int)l);
                --n2;
                continue;
            }
            this.skipStream[i] = (IndexInput)this.skipStream[0].clone();
            if (this.inputIsBuffered && l < 1024L) {
                ((BufferedIndexInput)this.skipStream[i]).setBufferSize((int)l);
            }
            this.skipStream[0].seek(this.skipStream[0].getFilePointer() + l);
        }
        this.skipPointer[0] = this.skipStream[0].getFilePointer();
    }

    protected abstract int readSkipData(int var1, IndexInput var2) throws IOException;

    protected void setLastSkipData(int n) {
        this.lastDoc = this.skipDoc[n];
        this.lastChildPointer = this.childPointer[n];
    }

    private static final class SkipBuffer
    extends IndexInput {
        private byte[] data;
        private long pointer;
        private int pos;

        SkipBuffer(IndexInput indexInput, int n) throws IOException {
            super("SkipBuffer on " + indexInput);
            this.data = new byte[n];
            this.pointer = indexInput.getFilePointer();
            indexInput.readBytes(this.data, 0, n);
        }

        @Override
        public void close() throws IOException {
            this.data = null;
        }

        @Override
        public long getFilePointer() {
            return this.pointer + (long)this.pos;
        }

        @Override
        public long length() {
            return this.data.length;
        }

        @Override
        public byte readByte() throws IOException {
            return this.data[this.pos++];
        }

        @Override
        public void readBytes(byte[] byArray, int n, int n2) throws IOException {
            System.arraycopy(this.data, this.pos, byArray, n, n2);
            this.pos += n2;
        }

        @Override
        public void seek(long l) throws IOException {
            this.pos = (int)(l - this.pointer);
        }
    }
}

