/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;

public class PositionBasedTermVectorMapper
extends TermVectorMapper {
    private Map<String, Map<Integer, TVPositionInfo>> fieldToTerms;
    private String currentField;
    private Map<Integer, TVPositionInfo> currentPositions;
    private boolean storeOffsets;

    public PositionBasedTermVectorMapper() {
        super(false, false);
    }

    public PositionBasedTermVectorMapper(boolean bl) {
        super(false, bl);
    }

    @Override
    public boolean isIgnoringPositions() {
        return false;
    }

    @Override
    public void map(String string, int n, TermVectorOffsetInfo[] termVectorOffsetInfoArray, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            Integer n2 = nArray[i];
            TVPositionInfo tVPositionInfo = this.currentPositions.get(n2);
            if (tVPositionInfo == null) {
                tVPositionInfo = new TVPositionInfo(nArray[i], this.storeOffsets);
                this.currentPositions.put(n2, tVPositionInfo);
            }
            tVPositionInfo.addTerm(string, termVectorOffsetInfoArray != null ? termVectorOffsetInfoArray[i] : null);
        }
    }

    @Override
    public void setExpectations(String string, int n, boolean bl, boolean bl2) {
        if (!bl2) {
            throw new RuntimeException("You must store positions in order to use this Mapper");
        }
        if (bl) {
            // empty if block
        }
        this.fieldToTerms = new HashMap<String, Map<Integer, TVPositionInfo>>(n);
        this.storeOffsets = bl;
        this.currentField = string;
        this.currentPositions = new HashMap<Integer, TVPositionInfo>();
        this.fieldToTerms.put(this.currentField, this.currentPositions);
    }

    public Map<String, Map<Integer, TVPositionInfo>> getFieldToTerms() {
        return this.fieldToTerms;
    }

    public static class TVPositionInfo {
        private int position;
        private List<String> terms;
        private List<TermVectorOffsetInfo> offsets;

        public TVPositionInfo(int n, boolean bl) {
            this.position = n;
            this.terms = new ArrayList<String>();
            if (bl) {
                this.offsets = new ArrayList<TermVectorOffsetInfo>();
            }
        }

        void addTerm(String string, TermVectorOffsetInfo termVectorOffsetInfo) {
            this.terms.add(string);
            if (this.offsets != null) {
                this.offsets.add(termVectorOffsetInfo);
            }
        }

        public int getPosition() {
            return this.position;
        }

        public List<String> getTerms() {
            return this.terms;
        }

        public List<TermVectorOffsetInfo> getOffsets() {
            return this.offsets;
        }
    }
}

