/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

class PrefixCodedTerms
implements Iterable<Term> {
    final RAMFile buffer;

    private PrefixCodedTerms(RAMFile rAMFile) {
        this.buffer = rAMFile;
    }

    public long getSizeInBytes() {
        return this.buffer.getSizeInBytes();
    }

    @Override
    public Iterator<Term> iterator() {
        return new PrefixCodedTermsIterator();
    }

    public static class Builder {
        private RAMFile buffer = new RAMFile();
        private RAMOutputStream output = new RAMOutputStream(this.buffer);
        private Term lastTerm = new Term("");
        private BytesRef lastBytes = new BytesRef();
        private BytesRef scratch = new BytesRef();

        public void add(Term term) {
            assert (this.lastTerm.equals(new Term("")) || term.compareTo(this.lastTerm) > 0);
            this.scratch.copy(term.text);
            try {
                int n = this.sharedPrefix(this.lastBytes, this.scratch);
                int n2 = this.scratch.length - n;
                if (term.field.equals(this.lastTerm.field)) {
                    this.output.writeVInt(n << 1);
                } else {
                    this.output.writeVInt(n << 1 | 1);
                    this.output.writeString(term.field);
                }
                this.output.writeVInt(n2);
                this.output.writeBytes(this.scratch.bytes, this.scratch.offset + n, n2);
                this.lastBytes.copy(this.scratch);
                this.lastTerm.text = term.text;
                this.lastTerm.field = term.field;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public PrefixCodedTerms finish() {
            try {
                this.output.close();
                return new PrefixCodedTerms(this.buffer);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private int sharedPrefix(BytesRef bytesRef, BytesRef bytesRef2) {
            int n = 0;
            int n2 = n + Math.min(bytesRef.length, bytesRef2.length);
            int n3 = 0;
            while (n < n2) {
                if (bytesRef.bytes[bytesRef.offset + n] != bytesRef2.bytes[bytesRef2.offset + n3]) {
                    return n;
                }
                ++n;
                ++n3;
            }
            return n;
        }
    }

    class PrefixCodedTermsIterator
    implements Iterator<Term> {
        final IndexInput input;
        String field = "";
        BytesRef bytes = new BytesRef();
        Term term = new Term(this.field, "");

        PrefixCodedTermsIterator() {
            try {
                this.input = new RAMInputStream("PrefixCodedTermsIterator", PrefixCodedTerms.this.buffer);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public boolean hasNext() {
            return this.input.getFilePointer() < this.input.length();
        }

        @Override
        public Term next() {
            assert (this.hasNext());
            try {
                int n = this.input.readVInt();
                if ((n & 1) != 0) {
                    this.field = StringHelper.intern(this.input.readString());
                }
                int n2 = n >>> 1;
                int n3 = this.input.readVInt();
                this.bytes.grow(n2 + n3);
                this.input.readBytes(this.bytes.bytes, n2, n3);
                this.bytes.length = n2 + n3;
                this.term.set(this.field, this.bytes.utf8ToString());
                return this.term;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

