/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.StoredFieldsWriterPerThread;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

final class StoredFieldsWriter {
    FieldsWriter fieldsWriter;
    final DocumentsWriter docWriter;
    final FieldInfos fieldInfos;
    int lastDocID;
    PerDoc[] docFreeList = new PerDoc[1];
    int freeCount;
    int allocCount;

    public StoredFieldsWriter(DocumentsWriter documentsWriter, FieldInfos fieldInfos) {
        this.docWriter = documentsWriter;
        this.fieldInfos = fieldInfos;
    }

    public StoredFieldsWriterPerThread addThread(DocumentsWriter.DocState docState) throws IOException {
        return new StoredFieldsWriterPerThread(docState, this);
    }

    public synchronized void flush(SegmentWriteState segmentWriteState) throws IOException {
        if (segmentWriteState.numDocs > this.lastDocID) {
            this.initFieldsWriter();
            this.fill(segmentWriteState.numDocs);
        }
        if (this.fieldsWriter != null) {
            this.fieldsWriter.close();
            this.fieldsWriter = null;
            this.lastDocID = 0;
            String string = IndexFileNames.segmentFileName(segmentWriteState.segmentName, "fdx");
            if (4L + (long)segmentWriteState.numDocs * 8L != segmentWriteState.directory.fileLength(string)) {
                throw new RuntimeException("after flush: fdx size mismatch: " + segmentWriteState.numDocs + " docs vs " + segmentWriteState.directory.fileLength(string) + " length in bytes of " + string + " file exists?=" + segmentWriteState.directory.fileExists(string));
            }
        }
    }

    private synchronized void initFieldsWriter() throws IOException {
        if (this.fieldsWriter == null) {
            this.fieldsWriter = new FieldsWriter(this.docWriter.directory, this.docWriter.getSegment(), this.fieldInfos);
            this.lastDocID = 0;
        }
    }

    synchronized PerDoc getPerDoc() {
        if (this.freeCount == 0) {
            ++this.allocCount;
            if (this.allocCount > this.docFreeList.length) {
                assert (this.allocCount == 1 + this.docFreeList.length);
                this.docFreeList = new PerDoc[ArrayUtil.oversize(this.allocCount, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            }
            return new PerDoc();
        }
        return this.docFreeList[--this.freeCount];
    }

    synchronized void abort() {
        if (this.fieldsWriter != null) {
            this.fieldsWriter.abort();
            this.fieldsWriter = null;
            this.lastDocID = 0;
        }
    }

    void fill(int n) throws IOException {
        while (this.lastDocID < n) {
            this.fieldsWriter.skipDocument();
            ++this.lastDocID;
        }
    }

    synchronized void finishDocument(PerDoc perDoc) throws IOException {
        assert (this.docWriter.writer.testPoint("StoredFieldsWriter.finishDocument start"));
        this.initFieldsWriter();
        this.fill(perDoc.docID);
        this.fieldsWriter.flushDocument(perDoc.numStoredFields, perDoc.fdt);
        ++this.lastDocID;
        perDoc.reset();
        this.free(perDoc);
        assert (this.docWriter.writer.testPoint("StoredFieldsWriter.finishDocument end"));
    }

    synchronized void free(PerDoc perDoc) {
        assert (this.freeCount < this.docFreeList.length);
        assert (0 == perDoc.numStoredFields);
        assert (0L == perDoc.fdt.length());
        assert (0L == perDoc.fdt.getFilePointer());
        this.docFreeList[this.freeCount++] = perDoc;
    }

    class PerDoc
    extends DocumentsWriter.DocWriter {
        final DocumentsWriter.PerDocBuffer buffer;
        RAMOutputStream fdt;
        int numStoredFields;

        PerDoc() {
            this.buffer = StoredFieldsWriter.this.docWriter.newPerDocBuffer();
            this.fdt = new RAMOutputStream(this.buffer);
        }

        void reset() {
            this.fdt.reset();
            this.buffer.recycle();
            this.numStoredFields = 0;
        }

        @Override
        void abort() {
            this.reset();
            StoredFieldsWriter.this.free(this);
        }

        @Override
        public long sizeInBytes() {
            return this.buffer.getSizeInBytes();
        }

        @Override
        public void finish() throws IOException {
            StoredFieldsWriter.this.finishDocument(this);
        }
    }
}

