/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.TermVectorsTermsWriter;
import org.apache.lucene.index.TermVectorsTermsWriterPerField;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashConsumerPerThread;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.TermsHashPerThread;
import org.apache.lucene.util.UnicodeUtil;

final class TermVectorsTermsWriterPerThread
extends TermsHashConsumerPerThread {
    final TermVectorsTermsWriter termsWriter;
    final TermsHashPerThread termsHashPerThread;
    final DocumentsWriter.DocState docState;
    TermVectorsTermsWriter.PerDoc doc;
    final ByteSliceReader vectorSliceReader = new ByteSliceReader();
    final UnicodeUtil.UTF8Result[] utf8Results = new UnicodeUtil.UTF8Result[]{new UnicodeUtil.UTF8Result(), new UnicodeUtil.UTF8Result()};
    String lastVectorFieldName;

    public TermVectorsTermsWriterPerThread(TermsHashPerThread termsHashPerThread, TermVectorsTermsWriter termVectorsTermsWriter) {
        this.termsWriter = termVectorsTermsWriter;
        this.termsHashPerThread = termsHashPerThread;
        this.docState = termsHashPerThread.docState;
    }

    @Override
    public void startDocument() {
        assert (this.clearLastVectorFieldName());
        if (this.doc != null) {
            this.doc.reset();
            this.doc.docID = this.docState.docID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentsWriter.DocWriter finishDocument() {
        try {
            TermVectorsTermsWriter.PerDoc perDoc = this.doc;
            return perDoc;
        }
        finally {
            this.doc = null;
        }
    }

    @Override
    public TermsHashConsumerPerField addField(TermsHashPerField termsHashPerField, FieldInfo fieldInfo) {
        return new TermVectorsTermsWriterPerField(termsHashPerField, this, fieldInfo);
    }

    @Override
    public void abort() {
        if (this.doc != null) {
            this.doc.abort();
            this.doc = null;
        }
    }

    final boolean clearLastVectorFieldName() {
        this.lastVectorFieldName = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean vectorFieldsInOrder(FieldInfo fieldInfo) {
        try {
            if (this.lastVectorFieldName != null) {
                boolean bl = this.lastVectorFieldName.compareTo(fieldInfo.name) < 0;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lastVectorFieldName = fieldInfo.name;
        }
    }
}

