/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public abstract class CachingCollector
extends Collector {
    private static final int MAX_ARRAY_SIZE = 524288;
    private static final int INITIAL_ARRAY_SIZE = 128;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    protected final Collector other;
    protected final int maxDocsToCache;
    protected final List<SegStart> cachedSegs = new ArrayList<SegStart>();
    protected final List<int[]> cachedDocs;
    private IndexReader lastReader;
    protected int[] curDocs;
    protected int upto;
    protected int base;
    protected int lastDocBase;

    public static CachingCollector create(final boolean bl, boolean bl2, double d) {
        Collector collector = new Collector(){

            @Override
            public boolean acceptsDocsOutOfOrder() {
                return bl;
            }

            @Override
            public void setScorer(Scorer scorer) throws IOException {
            }

            @Override
            public void collect(int n) throws IOException {
            }

            @Override
            public void setNextReader(IndexReader indexReader, int n) throws IOException {
            }
        };
        return CachingCollector.create(collector, bl2, d);
    }

    public static CachingCollector create(Collector collector, boolean bl, double d) {
        return bl ? new ScoreCachingCollector(collector, d) : new NoScoreCachingCollector(collector, d);
    }

    public static CachingCollector create(Collector collector, boolean bl, int n) {
        return bl ? new ScoreCachingCollector(collector, n) : new NoScoreCachingCollector(collector, n);
    }

    private CachingCollector(Collector collector, double d, boolean bl) {
        this.other = collector;
        this.cachedDocs = new ArrayList<int[]>();
        this.curDocs = new int[128];
        this.cachedDocs.add(this.curDocs);
        int n = 4;
        if (bl) {
            n += 4;
        }
        this.maxDocsToCache = (int)(d * 1024.0 * 1024.0 / (double)n);
    }

    private CachingCollector(Collector collector, int n) {
        this.other = collector;
        this.cachedDocs = new ArrayList<int[]>();
        this.curDocs = new int[128];
        this.cachedDocs.add(this.curDocs);
        this.maxDocsToCache = n;
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return this.other.acceptsDocsOutOfOrder();
    }

    public boolean isCached() {
        return this.curDocs != null;
    }

    @Override
    public void setNextReader(IndexReader indexReader, int n) throws IOException {
        this.other.setNextReader(indexReader, n);
        if (this.lastReader != null) {
            this.cachedSegs.add(new SegStart(this.lastReader, this.lastDocBase, this.base + this.upto));
        }
        this.lastDocBase = n;
        this.lastReader = indexReader;
    }

    void replayInit(Collector collector) {
        if (!this.isCached()) {
            throw new IllegalStateException("cannot replay: cache was cleared because too much RAM was required");
        }
        if (!collector.acceptsDocsOutOfOrder() && this.other.acceptsDocsOutOfOrder()) {
            throw new IllegalArgumentException("cannot replay: given collector does not support out-of-order collection, while the wrapped collector does. Therefore cached documents may be out-of-order.");
        }
        if (this.lastReader != null) {
            this.cachedSegs.add(new SegStart(this.lastReader, this.lastDocBase, this.base + this.upto));
            this.lastReader = null;
        }
    }

    public abstract void replay(Collector var1) throws IOException;

    private static final class NoScoreCachingCollector
    extends CachingCollector {
        NoScoreCachingCollector(Collector collector, double d) {
            super(collector, d, false);
        }

        NoScoreCachingCollector(Collector collector, int n) {
            super(collector, n);
        }

        @Override
        public void collect(int n) throws IOException {
            if (this.curDocs == null) {
                this.other.collect(n);
                return;
            }
            if (this.upto == this.curDocs.length) {
                this.base += this.upto;
                int n2 = 8 * this.curDocs.length;
                if (n2 > 524288) {
                    n2 = 524288;
                }
                if (this.base + n2 > this.maxDocsToCache && (n2 = this.maxDocsToCache - this.base) <= 0) {
                    this.curDocs = null;
                    this.cachedSegs.clear();
                    this.cachedDocs.clear();
                    this.other.collect(n);
                    return;
                }
                this.curDocs = new int[n2];
                this.cachedDocs.add(this.curDocs);
                this.upto = 0;
            }
            this.curDocs[this.upto] = n;
            ++this.upto;
            this.other.collect(n);
        }

        @Override
        public void replay(Collector collector) throws IOException {
            this.replayInit(collector);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            this.curDocs = EMPTY_INT_ARRAY;
            for (SegStart segStart : this.cachedSegs) {
                collector.setNextReader(segStart.reader, segStart.base);
                while (n2 + n < segStart.end) {
                    if (n == this.curDocs.length) {
                        n2 += this.curDocs.length;
                        this.curDocs = (int[])this.cachedDocs.get(n3);
                        ++n3;
                        n = 0;
                    }
                    collector.collect(this.curDocs[n++]);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.other.setScorer(scorer);
        }

        public String toString() {
            if (this.isCached()) {
                return "CachingCollector (" + (this.base + this.upto) + " docs cached)";
            }
            return "CachingCollector (cache was cleared)";
        }
    }

    private static final class ScoreCachingCollector
    extends CachingCollector {
        private final CachedScorer cachedScorer = new CachedScorer();
        private final List<float[]> cachedScores = new ArrayList<float[]>();
        private Scorer scorer;
        private float[] curScores = new float[128];

        ScoreCachingCollector(Collector collector, double d) {
            super(collector, d, true);
            this.cachedScores.add(this.curScores);
        }

        ScoreCachingCollector(Collector collector, int n) {
            super(collector, n);
            this.cachedScores.add(this.curScores);
        }

        @Override
        public void collect(int n) throws IOException {
            if (this.curDocs == null) {
                this.cachedScorer.score = this.scorer.score();
                this.cachedScorer.doc = n;
                this.other.collect(n);
                return;
            }
            if (this.upto == this.curDocs.length) {
                this.base += this.upto;
                int n2 = 8 * this.curDocs.length;
                if (n2 > 524288) {
                    n2 = 524288;
                }
                if (this.base + n2 > this.maxDocsToCache && (n2 = this.maxDocsToCache - this.base) <= 0) {
                    this.curDocs = null;
                    this.curScores = null;
                    this.cachedSegs.clear();
                    this.cachedDocs.clear();
                    this.cachedScores.clear();
                    this.cachedScorer.score = this.scorer.score();
                    this.cachedScorer.doc = n;
                    this.other.collect(n);
                    return;
                }
                this.curDocs = new int[n2];
                this.cachedDocs.add(this.curDocs);
                this.curScores = new float[n2];
                this.cachedScores.add(this.curScores);
                this.upto = 0;
            }
            this.curDocs[this.upto] = n;
            this.cachedScorer.score = this.curScores[this.upto] = this.scorer.score();
            ++this.upto;
            this.cachedScorer.doc = n;
            this.other.collect(n);
        }

        @Override
        public void replay(Collector collector) throws IOException {
            this.replayInit(collector);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            this.curDocs = EMPTY_INT_ARRAY;
            for (SegStart segStart : this.cachedSegs) {
                collector.setNextReader(segStart.reader, segStart.base);
                collector.setScorer(this.cachedScorer);
                while (n2 + n < segStart.end) {
                    if (n == this.curDocs.length) {
                        n2 += this.curDocs.length;
                        this.curDocs = (int[])this.cachedDocs.get(n3);
                        this.curScores = this.cachedScores.get(n3);
                        ++n3;
                        n = 0;
                    }
                    this.cachedScorer.score = this.curScores[n];
                    this.cachedScorer.doc = this.curDocs[n];
                    collector.collect(this.curDocs[n++]);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            this.other.setScorer(this.cachedScorer);
        }

        public String toString() {
            if (this.isCached()) {
                return "CachingCollector (" + (this.base + this.upto) + " docs & scores cached)";
            }
            return "CachingCollector (cache was cleared)";
        }
    }

    private static final class CachedScorer
    extends Scorer {
        int doc;
        float score;

        private CachedScorer() {
            super((Weight)null);
        }

        @Override
        public final float score() {
            return this.score;
        }

        @Override
        public final int advance(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int docID() {
            return this.doc;
        }

        @Override
        public final float freq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int nextDoc() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SegStart {
        public final IndexReader reader;
        public final int base;
        public final int end;

        public SegStart(IndexReader indexReader, int n, int n2) {
            this.reader = indexReader;
            this.base = n;
            this.end = n2;
        }
    }
}

