/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

class DisjunctionMaxScorer
extends Scorer {
    private final Scorer[] subScorers;
    private int numScorers;
    private final float tieBreakerMultiplier;
    private int doc = -1;
    private float scoreSum;
    private float scoreMax;

    public DisjunctionMaxScorer(Weight weight, float f, Similarity similarity, Scorer[] scorerArray, int n) throws IOException {
        super(similarity, weight);
        this.tieBreakerMultiplier = f;
        this.subScorers = scorerArray;
        this.numScorers = n;
        this.heapify();
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.numScorers == 0) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        while (this.subScorers[0].docID() == this.doc) {
            if (this.subScorers[0].nextDoc() != Integer.MAX_VALUE) {
                this.heapAdjust(0);
                continue;
            }
            this.heapRemoveRoot();
            if (this.numScorers != 0) continue;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.subScorers[0].docID();
        return this.doc;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public float score() throws IOException {
        int n = this.subScorers[0].docID();
        this.scoreSum = this.scoreMax = this.subScorers[0].score();
        int n2 = this.numScorers;
        this.scoreAll(1, n2, n);
        this.scoreAll(2, n2, n);
        return this.scoreMax + (this.scoreSum - this.scoreMax) * this.tieBreakerMultiplier;
    }

    private void scoreAll(int n, int n2, int n3) throws IOException {
        if (n < n2 && this.subScorers[n].docID() == n3) {
            float f = this.subScorers[n].score();
            this.scoreSum += f;
            this.scoreMax = Math.max(this.scoreMax, f);
            this.scoreAll((n << 1) + 1, n2, n3);
            this.scoreAll((n << 1) + 2, n2, n3);
        }
    }

    @Override
    public int advance(int n) throws IOException {
        if (this.numScorers == 0) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        while (this.subScorers[0].docID() < n) {
            if (this.subScorers[0].advance(n) != Integer.MAX_VALUE) {
                this.heapAdjust(0);
                continue;
            }
            this.heapRemoveRoot();
            if (this.numScorers != 0) continue;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.subScorers[0].docID();
        return this.doc;
    }

    private void heapify() {
        for (int i = (this.numScorers >> 1) - 1; i >= 0; --i) {
            this.heapAdjust(i);
        }
    }

    private void heapAdjust(int n) {
        Scorer scorer = this.subScorers[n];
        int n2 = scorer.docID();
        int n3 = n;
        while (n3 <= (this.numScorers >> 1) - 1) {
            int n4 = (n3 << 1) + 1;
            Scorer scorer2 = this.subScorers[n4];
            int n5 = scorer2.docID();
            int n6 = Integer.MAX_VALUE;
            int n7 = (n3 << 1) + 2;
            Scorer scorer3 = null;
            if (n7 < this.numScorers) {
                scorer3 = this.subScorers[n7];
                n6 = scorer3.docID();
            }
            if (n5 < n2) {
                if (n6 < n5) {
                    this.subScorers[n3] = scorer3;
                    this.subScorers[n7] = scorer;
                    n3 = n7;
                    continue;
                }
                this.subScorers[n3] = scorer2;
                this.subScorers[n4] = scorer;
                n3 = n4;
                continue;
            }
            if (n6 < n2) {
                this.subScorers[n3] = scorer3;
                this.subScorers[n7] = scorer;
                n3 = n7;
                continue;
            }
            return;
        }
    }

    private void heapRemoveRoot() {
        if (this.numScorers == 1) {
            this.subScorers[0] = null;
            this.numScorers = 0;
        } else {
            this.subScorers[0] = this.subScorers[this.numScorers - 1];
            this.subScorers[this.numScorers - 1] = null;
            --this.numScorers;
            this.heapAdjust(0);
        }
    }
}

