/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.NumericUtils;

public abstract class FieldCacheRangeFilter<T>
extends Filter {
    final String field;
    final FieldCache.Parser parser;
    final T lowerVal;
    final T upperVal;
    final boolean includeLower;
    final boolean includeUpper;

    private FieldCacheRangeFilter(String string, FieldCache.Parser parser, T t, T t2, boolean bl, boolean bl2) {
        this.field = string;
        this.parser = parser;
        this.lowerVal = t;
        this.upperVal = t2;
        this.includeLower = bl;
        this.includeUpper = bl2;
    }

    @Override
    public abstract DocIdSet getDocIdSet(IndexReader var1) throws IOException;

    public static FieldCacheRangeFilter<String> newStringRange(String string, String string2, String string3, boolean bl, boolean bl2) {
        return new FieldCacheRangeFilter<String>(string, null, string2, string3, bl, bl2){

            @Override
            public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
                int n;
                int n2;
                final FieldCache.StringIndex stringIndex = FieldCache.DEFAULT.getStringIndex(indexReader, this.field);
                int n3 = stringIndex.binarySearchLookup((String)this.lowerVal);
                int n4 = stringIndex.binarySearchLookup((String)this.upperVal);
                if (n3 == 0) {
                    assert (this.lowerVal == null);
                    n2 = 1;
                } else {
                    n2 = this.includeLower && n3 > 0 ? n3 : (n3 > 0 ? n3 + 1 : Math.max(1, -n3 - 1));
                }
                if (n4 == 0) {
                    assert (this.upperVal == null);
                    n = Integer.MAX_VALUE;
                } else {
                    n = this.includeUpper && n4 > 0 ? n4 : (n4 > 0 ? n4 - 1 : -n4 - 2);
                }
                if (n <= 0 || n2 > n) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                assert (n2 > 0 && n > 0);
                return new FieldCacheDocIdSet(indexReader, false){

                    @Override
                    final boolean matchDoc(int n3) {
                        return stringIndex.order[n3] >= n2 && stringIndex.order[n3] <= n;
                    }
                };
            }
        };
    }

    public static FieldCacheRangeFilter<Byte> newByteRange(String string, Byte by, Byte by2, boolean bl, boolean bl2) {
        return FieldCacheRangeFilter.newByteRange(string, null, by, by2, bl, bl2);
    }

    public static FieldCacheRangeFilter<Byte> newByteRange(String string, FieldCache.ByteParser byteParser, Byte by, Byte by2, boolean bl, boolean bl2) {
        return new FieldCacheRangeFilter<Byte>(string, (FieldCache.Parser)byteParser, by, by2, bl, bl2){

            @Override
            public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
                byte by;
                byte by2;
                int n;
                if (this.lowerVal != null) {
                    n = ((Byte)this.lowerVal).byteValue();
                    if (!this.includeLower && n == 127) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    by2 = (byte)(this.includeLower ? n : n + 1);
                } else {
                    by2 = -128;
                }
                if (this.upperVal != null) {
                    n = ((Byte)this.upperVal).byteValue();
                    if (!this.includeUpper && n == -128) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    by = (byte)(this.includeUpper ? n : n - 1);
                } else {
                    by = 127;
                }
                if (by2 > by) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final byte[] byArray = FieldCache.DEFAULT.getBytes(indexReader, this.field, (FieldCache.ByteParser)this.parser);
                return new FieldCacheDocIdSet(indexReader, by2 <= 0 && by >= 0){

                    @Override
                    boolean matchDoc(int n) {
                        return byArray[n] >= by2 && byArray[n] <= by;
                    }
                };
            }
        };
    }

    public static FieldCacheRangeFilter<Short> newShortRange(String string, Short s, Short s2, boolean bl, boolean bl2) {
        return FieldCacheRangeFilter.newShortRange(string, null, s, s2, bl, bl2);
    }

    public static FieldCacheRangeFilter<Short> newShortRange(String string, FieldCache.ShortParser shortParser, Short s, Short s2, boolean bl, boolean bl2) {
        return new FieldCacheRangeFilter<Short>(string, (FieldCache.Parser)shortParser, s, s2, bl, bl2){

            @Override
            public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
                short s;
                short s2;
                int n;
                if (this.lowerVal != null) {
                    n = ((Short)this.lowerVal).shortValue();
                    if (!this.includeLower && n == Short.MAX_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    s2 = (short)(this.includeLower ? n : n + 1);
                } else {
                    s2 = Short.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    n = ((Short)this.upperVal).shortValue();
                    if (!this.includeUpper && n == Short.MIN_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    s = (short)(this.includeUpper ? n : n - 1);
                } else {
                    s = Short.MAX_VALUE;
                }
                if (s2 > s) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final short[] sArray = FieldCache.DEFAULT.getShorts(indexReader, this.field, (FieldCache.ShortParser)this.parser);
                return new FieldCacheDocIdSet(indexReader, s2 <= 0 && s >= 0){

                    @Override
                    boolean matchDoc(int n) {
                        return sArray[n] >= s2 && sArray[n] <= s;
                    }
                };
            }
        };
    }

    public static FieldCacheRangeFilter<Integer> newIntRange(String string, Integer n, Integer n2, boolean bl, boolean bl2) {
        return FieldCacheRangeFilter.newIntRange(string, null, n, n2, bl, bl2);
    }

    public static FieldCacheRangeFilter<Integer> newIntRange(String string, FieldCache.IntParser intParser, Integer n, Integer n2, boolean bl, boolean bl2) {
        return new FieldCacheRangeFilter<Integer>(string, (FieldCache.Parser)intParser, n, n2, bl, bl2){

            @Override
            public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
                int n;
                int n2;
                int n3;
                if (this.lowerVal != null) {
                    n3 = (Integer)this.lowerVal;
                    if (!this.includeLower && n3 == Integer.MAX_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    n2 = this.includeLower ? n3 : n3 + 1;
                } else {
                    n2 = Integer.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    n3 = (Integer)this.upperVal;
                    if (!this.includeUpper && n3 == Integer.MIN_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    n = this.includeUpper ? n3 : n3 - 1;
                } else {
                    n = Integer.MAX_VALUE;
                }
                if (n2 > n) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final int[] nArray = FieldCache.DEFAULT.getInts(indexReader, this.field, (FieldCache.IntParser)this.parser);
                return new FieldCacheDocIdSet(indexReader, n2 <= 0 && n >= 0){

                    @Override
                    boolean matchDoc(int n3) {
                        return nArray[n3] >= n2 && nArray[n3] <= n;
                    }
                };
            }
        };
    }

    public static FieldCacheRangeFilter<Long> newLongRange(String string, Long l, Long l2, boolean bl, boolean bl2) {
        return FieldCacheRangeFilter.newLongRange(string, null, l, l2, bl, bl2);
    }

    public static FieldCacheRangeFilter<Long> newLongRange(String string, FieldCache.LongParser longParser, Long l, Long l2, boolean bl, boolean bl2) {
        return new FieldCacheRangeFilter<Long>(string, (FieldCache.Parser)longParser, l, l2, bl, bl2){

            @Override
            public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
                long l;
                long l2;
                long l3;
                if (this.lowerVal != null) {
                    l3 = (Long)this.lowerVal;
                    if (!this.includeLower && l3 == Long.MAX_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    l2 = this.includeLower ? l3 : l3 + 1L;
                } else {
                    l2 = Long.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    l3 = (Long)this.upperVal;
                    if (!this.includeUpper && l3 == Long.MIN_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    l = this.includeUpper ? l3 : l3 - 1L;
                } else {
                    l = Long.MAX_VALUE;
                }
                if (l2 > l) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final long[] lArray = FieldCache.DEFAULT.getLongs(indexReader, this.field, (FieldCache.LongParser)this.parser);
                return new FieldCacheDocIdSet(indexReader, l2 <= 0L && l >= 0L){

                    @Override
                    boolean matchDoc(int n) {
                        return lArray[n] >= l2 && lArray[n] <= l;
                    }
                };
            }
        };
    }

    public static FieldCacheRangeFilter<Float> newFloatRange(String string, Float f, Float f2, boolean bl, boolean bl2) {
        return FieldCacheRangeFilter.newFloatRange(string, null, f, f2, bl, bl2);
    }

    public static FieldCacheRangeFilter<Float> newFloatRange(String string, FieldCache.FloatParser floatParser, Float f, Float f2, boolean bl, boolean bl2) {
        return new FieldCacheRangeFilter<Float>(string, (FieldCache.Parser)floatParser, f, f2, bl, bl2){

            @Override
            public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
                float f;
                float f2;
                int n;
                float f3;
                if (this.lowerVal != null) {
                    f3 = ((Float)this.lowerVal).floatValue();
                    if (!this.includeUpper && f3 > 0.0f && Float.isInfinite(f3)) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    n = NumericUtils.floatToSortableInt(f3);
                    f2 = NumericUtils.sortableIntToFloat(this.includeLower ? n : n + 1);
                } else {
                    f2 = Float.NEGATIVE_INFINITY;
                }
                if (this.upperVal != null) {
                    f3 = ((Float)this.upperVal).floatValue();
                    if (!this.includeUpper && f3 < 0.0f && Float.isInfinite(f3)) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    n = NumericUtils.floatToSortableInt(f3);
                    f = NumericUtils.sortableIntToFloat(this.includeUpper ? n : n - 1);
                } else {
                    f = Float.POSITIVE_INFINITY;
                }
                if (f2 > f) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final float[] fArray = FieldCache.DEFAULT.getFloats(indexReader, this.field, (FieldCache.FloatParser)this.parser);
                return new FieldCacheDocIdSet(indexReader, f2 <= 0.0f && f >= 0.0f){

                    @Override
                    boolean matchDoc(int n) {
                        return fArray[n] >= f2 && fArray[n] <= f;
                    }
                };
            }
        };
    }

    public static FieldCacheRangeFilter<Double> newDoubleRange(String string, Double d, Double d2, boolean bl, boolean bl2) {
        return FieldCacheRangeFilter.newDoubleRange(string, null, d, d2, bl, bl2);
    }

    public static FieldCacheRangeFilter<Double> newDoubleRange(String string, FieldCache.DoubleParser doubleParser, Double d, Double d2, boolean bl, boolean bl2) {
        return new FieldCacheRangeFilter<Double>(string, (FieldCache.Parser)doubleParser, d, d2, bl, bl2){

            @Override
            public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
                double d;
                double d2;
                long l;
                double d3;
                if (this.lowerVal != null) {
                    d3 = (Double)this.lowerVal;
                    if (!this.includeUpper && d3 > 0.0 && Double.isInfinite(d3)) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    l = NumericUtils.doubleToSortableLong(d3);
                    d2 = NumericUtils.sortableLongToDouble(this.includeLower ? l : l + 1L);
                } else {
                    d2 = Double.NEGATIVE_INFINITY;
                }
                if (this.upperVal != null) {
                    d3 = (Double)this.upperVal;
                    if (!this.includeUpper && d3 < 0.0 && Double.isInfinite(d3)) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    l = NumericUtils.doubleToSortableLong(d3);
                    d = NumericUtils.sortableLongToDouble(this.includeUpper ? l : l - 1L);
                } else {
                    d = Double.POSITIVE_INFINITY;
                }
                if (d2 > d) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final double[] dArray = FieldCache.DEFAULT.getDoubles(indexReader, this.field, (FieldCache.DoubleParser)this.parser);
                return new FieldCacheDocIdSet(indexReader, d2 <= 0.0 && d >= 0.0){

                    @Override
                    boolean matchDoc(int n) {
                        return dArray[n] >= d2 && dArray[n] <= d;
                    }
                };
            }
        };
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.field).append(":");
        return stringBuilder.append(this.includeLower ? (char)'[' : '{').append(this.lowerVal == null ? "*" : this.lowerVal.toString()).append(" TO ").append(this.upperVal == null ? "*" : this.upperVal.toString()).append(this.includeUpper ? (char)']' : '}').toString();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FieldCacheRangeFilter)) {
            return false;
        }
        FieldCacheRangeFilter fieldCacheRangeFilter = (FieldCacheRangeFilter)object;
        if (!this.field.equals(fieldCacheRangeFilter.field) || this.includeLower != fieldCacheRangeFilter.includeLower || this.includeUpper != fieldCacheRangeFilter.includeUpper) {
            return false;
        }
        if (this.lowerVal != null ? !this.lowerVal.equals(fieldCacheRangeFilter.lowerVal) : fieldCacheRangeFilter.lowerVal != null) {
            return false;
        }
        if (this.upperVal != null ? !this.upperVal.equals(fieldCacheRangeFilter.upperVal) : fieldCacheRangeFilter.upperVal != null) {
            return false;
        }
        return !(this.parser != null ? !this.parser.equals(fieldCacheRangeFilter.parser) : fieldCacheRangeFilter.parser != null);
    }

    public final int hashCode() {
        int n = this.field.hashCode();
        n ^= this.lowerVal != null ? this.lowerVal.hashCode() : 550356204;
        n = n << 1 | n >>> 31;
        n ^= this.upperVal != null ? this.upperVal.hashCode() : -1674416163;
        n ^= this.parser != null ? this.parser.hashCode() : -1572457324;
        return n ^= (this.includeLower ? 1549299360 : -365038026) ^ (this.includeUpper ? 1721088258 : 1948649653);
    }

    public String getField() {
        return this.field;
    }

    public boolean includesLower() {
        return this.includeLower;
    }

    public boolean includesUpper() {
        return this.includeUpper;
    }

    public T getLowerVal() {
        return this.lowerVal;
    }

    public T getUpperVal() {
        return this.upperVal;
    }

    public FieldCache.Parser getParser() {
        return this.parser;
    }

    static abstract class FieldCacheDocIdSet
    extends DocIdSet {
        private final IndexReader reader;
        private boolean mayUseTermDocs;

        FieldCacheDocIdSet(IndexReader indexReader, boolean bl) {
            this.reader = indexReader;
            this.mayUseTermDocs = bl;
        }

        abstract boolean matchDoc(int var1) throws ArrayIndexOutOfBoundsException;

        @Override
        public boolean isCacheable() {
            return !this.mayUseTermDocs || !this.reader.hasDeletions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DocIdSetIterator iterator() throws IOException {
            TermDocs termDocs;
            IndexReader indexReader = this.reader;
            synchronized (indexReader) {
                termDocs = this.isCacheable() ? null : this.reader.termDocs(null);
            }
            if (termDocs != null) {
                return new DocIdSetIterator(){
                    private int doc = -1;

                    @Override
                    public int docID() {
                        return this.doc;
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        do {
                            if (termDocs.next()) continue;
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        } while (!FieldCacheDocIdSet.this.matchDoc(this.doc = termDocs.doc()));
                        return this.doc;
                    }

                    @Override
                    public int advance(int n) throws IOException {
                        if (!termDocs.skipTo(n)) {
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        while (!FieldCacheDocIdSet.this.matchDoc(this.doc = termDocs.doc())) {
                            if (termDocs.next()) continue;
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        return this.doc;
                    }
                };
            }
            return new DocIdSetIterator(){
                private int doc = -1;

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public int nextDoc() {
                    try {
                        do {
                            ++this.doc;
                        } while (!FieldCacheDocIdSet.this.matchDoc(this.doc));
                        return this.doc;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                }

                @Override
                public int advance(int n) {
                    try {
                        this.doc = n;
                        while (!FieldCacheDocIdSet.this.matchDoc(this.doc)) {
                            ++this.doc;
                        }
                        return this.doc;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                }
            };
        }
    }
}

