/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;

public abstract class FilteredDocIdSetIterator
extends DocIdSetIterator {
    protected DocIdSetIterator _innerIter;
    private int doc;

    public FilteredDocIdSetIterator(DocIdSetIterator docIdSetIterator) {
        if (docIdSetIterator == null) {
            throw new IllegalArgumentException("null iterator");
        }
        this._innerIter = docIdSetIterator;
        this.doc = -1;
    }

    protected abstract boolean match(int var1) throws IOException;

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() throws IOException {
        while ((this.doc = this._innerIter.nextDoc()) != Integer.MAX_VALUE) {
            if (!this.match(this.doc)) continue;
            return this.doc;
        }
        return this.doc;
    }

    @Override
    public int advance(int n) throws IOException {
        this.doc = this._innerIter.advance(n);
        if (this.doc != Integer.MAX_VALUE) {
            if (this.match(this.doc)) {
                return this.doc;
            }
            while ((this.doc = this._innerIter.nextDoc()) != Integer.MAX_VALUE) {
                if (!this.match(this.doc)) continue;
                return this.doc;
            }
            return this.doc;
        }
        return this.doc;
    }
}

