/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.PriorityQueue;

final class HitQueue
extends PriorityQueue<ScoreDoc> {
    private boolean prePopulate;

    HitQueue(int n, boolean bl) {
        this.prePopulate = bl;
        this.initialize(n);
    }

    @Override
    protected ScoreDoc getSentinelObject() {
        return !this.prePopulate ? null : new ScoreDoc(Integer.MAX_VALUE, Float.NEGATIVE_INFINITY);
    }

    @Override
    protected final boolean lessThan(ScoreDoc scoreDoc, ScoreDoc scoreDoc2) {
        if (scoreDoc.score == scoreDoc2.score) {
            return scoreDoc.doc > scoreDoc2.doc;
        }
        return scoreDoc.score < scoreDoc2.score;
    }
}

