/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ReaderUtil;
import org.apache.lucene.util.ThreadInterruptedException;

public class IndexSearcher
extends Searcher {
    IndexReader reader;
    private boolean closeReader;
    protected final IndexReader[] subReaders;
    protected final int[] docStarts;
    private final ExecutorService executor;
    protected final IndexSearcher[] subSearchers;
    private final int docBase;
    private boolean fieldSortDoTrackScores;
    private boolean fieldSortDoMaxScore;

    @Deprecated
    public IndexSearcher(Directory directory) throws CorruptIndexException, IOException {
        this(IndexReader.open(directory, true), true, null);
    }

    @Deprecated
    public IndexSearcher(Directory directory, boolean bl) throws CorruptIndexException, IOException {
        this(IndexReader.open(directory, bl), true, null);
    }

    public IndexSearcher(IndexReader indexReader) {
        this(indexReader, false, null);
    }

    public IndexSearcher(IndexReader indexReader, ExecutorService executorService) {
        this(indexReader, false, executorService);
    }

    public IndexSearcher(IndexReader indexReader, IndexReader[] indexReaderArray, int[] nArray) {
        this(indexReader, indexReaderArray, nArray, null);
    }

    private IndexSearcher(IndexReader indexReader, int n) {
        this.reader = indexReader;
        this.executor = null;
        this.closeReader = false;
        this.docBase = n;
        this.subReaders = new IndexReader[]{indexReader};
        this.docStarts = new int[]{0};
        this.subSearchers = null;
    }

    public IndexSearcher(IndexReader indexReader, IndexReader[] indexReaderArray, int[] nArray, ExecutorService executorService) {
        this.reader = indexReader;
        this.subReaders = indexReaderArray;
        this.docStarts = nArray;
        if (executorService == null) {
            this.subSearchers = null;
        } else {
            this.subSearchers = new IndexSearcher[indexReaderArray.length];
            for (int i = 0; i < indexReaderArray.length; ++i) {
                this.subSearchers[i] = new IndexSearcher(indexReaderArray[i], nArray[i]);
            }
        }
        this.closeReader = false;
        this.executor = executorService;
        this.docBase = 0;
    }

    private IndexSearcher(IndexReader indexReader, boolean bl, ExecutorService executorService) {
        int n;
        this.reader = indexReader;
        this.executor = executorService;
        this.closeReader = bl;
        ArrayList<IndexReader> arrayList = new ArrayList<IndexReader>();
        this.gatherSubReaders(arrayList, this.reader);
        this.subReaders = arrayList.toArray(new IndexReader[arrayList.size()]);
        this.docStarts = new int[this.subReaders.length];
        int n2 = 0;
        for (n = 0; n < this.subReaders.length; ++n) {
            this.docStarts[n] = n2;
            n2 += this.subReaders[n].maxDoc();
        }
        if (executorService == null) {
            this.subSearchers = null;
        } else {
            this.subSearchers = new IndexSearcher[this.subReaders.length];
            for (n = 0; n < this.subReaders.length; ++n) {
                this.subSearchers[n] = new IndexSearcher(this.subReaders[n], this.docStarts[n]);
            }
        }
        this.docBase = 0;
    }

    protected void gatherSubReaders(List<IndexReader> list, IndexReader indexReader) {
        ReaderUtil.gatherSubReaders(list, indexReader);
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public IndexReader[] getSubReaders() {
        return this.subReaders;
    }

    @Override
    public int maxDoc() {
        return this.reader.maxDoc();
    }

    @Override
    public int docFreq(final Term term) throws IOException {
        int n;
        if (this.executor == null) {
            return this.reader.docFreq(term);
        }
        ExecutionHelper<Integer> executionHelper = new ExecutionHelper<Integer>(this.executor);
        for (n = 0; n < this.subReaders.length; ++n) {
            final IndexSearcher indexSearcher = this.subSearchers[n];
            executionHelper.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws IOException {
                    return indexSearcher.docFreq(term);
                }
            });
        }
        n = 0;
        for (Integer n2 : executionHelper) {
            n += n2.intValue();
        }
        return n;
    }

    @Override
    public Document doc(int n) throws CorruptIndexException, IOException {
        return this.reader.document(n);
    }

    @Override
    public Document doc(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        return this.reader.document(n, fieldSelector);
    }

    @Override
    public void setSimilarity(Similarity similarity) {
        super.setSimilarity(similarity);
    }

    @Override
    public Similarity getSimilarity() {
        return super.getSimilarity();
    }

    @Override
    public void close() throws IOException {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public TopDocs searchAfter(ScoreDoc scoreDoc, Query query, int n) throws IOException {
        return this.searchAfter(scoreDoc, query, null, n);
    }

    public TopDocs searchAfter(ScoreDoc scoreDoc, Query query, Filter filter, int n) throws IOException {
        return this.search(this.createNormalizedWeight(query), filter, scoreDoc, n);
    }

    @Override
    public TopDocs search(Query query, int n) throws IOException {
        return this.search(query, null, n);
    }

    @Override
    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        return this.search(this.createNormalizedWeight(query), filter, n);
    }

    @Override
    public void search(Query query, Filter filter, Collector collector) throws IOException {
        this.search(this.createNormalizedWeight(query), filter, collector);
    }

    @Override
    public void search(Query query, Collector collector) throws IOException {
        this.search(this.createNormalizedWeight(query), null, collector);
    }

    @Override
    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        return this.search(this.createNormalizedWeight(query), filter, n, sort);
    }

    @Override
    public TopFieldDocs search(Query query, int n, Sort sort) throws IOException {
        return this.search(this.createNormalizedWeight(query), null, n, sort);
    }

    @Override
    public TopDocs search(Weight weight, Filter filter, int n) throws IOException {
        return this.search(weight, filter, null, n);
    }

    protected TopDocs search(Weight weight, Filter filter, ScoreDoc scoreDoc, int n) throws IOException {
        int n2;
        if (this.executor == null) {
            int n3 = this.reader.maxDoc();
            if (n3 == 0) {
                n3 = 1;
            }
            n = Math.min(n, n3);
            TopScoreDocCollector topScoreDocCollector = TopScoreDocCollector.create(n, scoreDoc, !weight.scoresDocsOutOfOrder());
            this.search(weight, filter, (Collector)topScoreDocCollector);
            return topScoreDocCollector.topDocs();
        }
        HitQueue hitQueue = new HitQueue(n, false);
        ReentrantLock reentrantLock = new ReentrantLock();
        ExecutionHelper<TopDocs> executionHelper = new ExecutionHelper<TopDocs>(this.executor);
        for (n2 = 0; n2 < this.subReaders.length; ++n2) {
            executionHelper.submit(new MultiSearcherCallableNoSort(reentrantLock, this.subSearchers[n2], weight, filter, scoreDoc, n, hitQueue));
        }
        n2 = 0;
        float f = Float.NEGATIVE_INFINITY;
        for (TopDocs topDocs : executionHelper) {
            if (topDocs.totalHits == 0) continue;
            n2 += topDocs.totalHits;
            f = Math.max(f, topDocs.getMaxScore());
        }
        ScoreDoc[] scoreDocArray = new ScoreDoc[hitQueue.size()];
        for (int i = hitQueue.size() - 1; i >= 0; --i) {
            scoreDocArray[i] = (ScoreDoc)hitQueue.pop();
        }
        return new TopDocs(n2, scoreDocArray, f);
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) throws IOException {
        return this.search(weight, filter, n, sort, true);
    }

    protected TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort, boolean bl) throws IOException {
        int n2;
        if (sort == null) {
            throw new NullPointerException();
        }
        if (this.executor == null) {
            int n3 = this.reader.maxDoc();
            if (n3 == 0) {
                n3 = 1;
            }
            n = Math.min(n, n3);
            TopFieldCollector topFieldCollector = TopFieldCollector.create(sort, n, bl, this.fieldSortDoTrackScores, this.fieldSortDoMaxScore, !weight.scoresDocsOutOfOrder());
            this.search(weight, filter, (Collector)topFieldCollector);
            return (TopFieldDocs)topFieldCollector.topDocs();
        }
        TopFieldCollector topFieldCollector = TopFieldCollector.create(sort, n, bl, this.fieldSortDoTrackScores, this.fieldSortDoMaxScore, false);
        ReentrantLock reentrantLock = new ReentrantLock();
        ExecutionHelper<TopFieldDocs> executionHelper = new ExecutionHelper<TopFieldDocs>(this.executor);
        for (n2 = 0; n2 < this.subReaders.length; ++n2) {
            executionHelper.submit(new MultiSearcherCallableWithSort(reentrantLock, this.subSearchers[n2], weight, filter, n, topFieldCollector, sort));
        }
        n2 = 0;
        float f = Float.NEGATIVE_INFINITY;
        for (TopFieldDocs topFieldDocs : executionHelper) {
            if (topFieldDocs.totalHits == 0) continue;
            n2 += topFieldDocs.totalHits;
            f = Math.max(f, topFieldDocs.getMaxScore());
        }
        TopFieldDocs topFieldDocs = (TopFieldDocs)topFieldCollector.topDocs();
        return new TopFieldDocs(n2, topFieldDocs.scoreDocs, topFieldDocs.fields, topFieldDocs.getMaxScore());
    }

    @Override
    public void search(Weight weight, Filter filter, Collector collector) throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            Scorer scorer;
            collector.setNextReader(this.subReaders[i], this.docBase + this.docStarts[i]);
            Scorer scorer2 = filter == null ? weight.scorer(this.subReaders[i], !collector.acceptsDocsOutOfOrder(), true) : (scorer = FilteredQuery.getFilteredScorer(this.subReaders[i], this.getSimilarity(), weight, weight, filter));
            if (scorer == null) continue;
            scorer.score(collector);
        }
    }

    @Override
    public Query rewrite(Query query) throws IOException {
        Query query2 = query;
        Query query3 = query2.rewrite(this.reader);
        while (query3 != query2) {
            query2 = query3;
            query3 = query2.rewrite(this.reader);
        }
        return query2;
    }

    @Override
    public Explanation explain(Query query, int n) throws IOException {
        return this.explain(this.createNormalizedWeight(query), n);
    }

    @Override
    public Explanation explain(Weight weight, int n) throws IOException {
        int n2 = ReaderUtil.subIndex(n, this.docStarts);
        int n3 = n - this.docStarts[n2];
        return weight.explain(this.subReaders[n2], n3);
    }

    public void setDefaultFieldSortScoring(boolean bl, boolean bl2) {
        this.fieldSortDoTrackScores = bl;
        this.fieldSortDoMaxScore = bl2;
        if (this.subSearchers != null) {
            for (IndexSearcher indexSearcher : this.subSearchers) {
                indexSearcher.setDefaultFieldSortScoring(bl, bl2);
            }
        }
    }

    @Override
    public Weight createNormalizedWeight(Query query) throws IOException {
        return super.createNormalizedWeight(query);
    }

    public String toString() {
        return "IndexSearcher(" + this.reader + ")";
    }

    private static final class ExecutionHelper<T>
    implements Iterator<T>,
    Iterable<T> {
        private final CompletionService<T> service;
        private int numTasks;

        ExecutionHelper(Executor executor) {
            this.service = new ExecutorCompletionService<T>(executor);
        }

        @Override
        public boolean hasNext() {
            return this.numTasks > 0;
        }

        public void submit(Callable<T> callable) {
            this.service.submit(callable);
            ++this.numTasks;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                T t = this.service.take().get();
                return t;
            }
            catch (InterruptedException interruptedException) {
                throw new ThreadInterruptedException(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException);
            }
            finally {
                --this.numTasks;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }

    private static final class MultiSearcherCallableWithSort
    implements Callable<TopFieldDocs> {
        private final Lock lock;
        private final IndexSearcher searchable;
        private final Weight weight;
        private final Filter filter;
        private final int nDocs;
        private final TopFieldCollector hq;
        private final Sort sort;
        private final FakeScorer fakeScorer = new FakeScorer();

        public MultiSearcherCallableWithSort(Lock lock, IndexSearcher indexSearcher, Weight weight, Filter filter, int n, TopFieldCollector topFieldCollector, Sort sort) {
            this.lock = lock;
            this.searchable = indexSearcher;
            this.weight = weight;
            this.filter = filter;
            this.nDocs = n;
            this.hq = topFieldCollector;
            this.sort = sort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TopFieldDocs call() throws IOException {
            TopFieldDocs topFieldDocs = this.searchable.search(this.weight, this.filter, this.nDocs, this.sort);
            for (int i = 0; i < topFieldDocs.fields.length; ++i) {
                if (topFieldDocs.fields[i].getType() != 1) continue;
                for (int j = 0; j < topFieldDocs.scoreDocs.length; ++j) {
                    FieldDoc fieldDoc = (FieldDoc)topFieldDocs.scoreDocs[j];
                    fieldDoc.fields[i] = (int)((Integer)fieldDoc.fields[i]);
                }
                break;
            }
            this.lock.lock();
            try {
                this.hq.setNextReader(this.searchable.getIndexReader(), this.searchable.docBase);
                this.hq.setScorer(this.fakeScorer);
                for (ScoreDoc scoreDoc : topFieldDocs.scoreDocs) {
                    int n;
                    this.fakeScorer.doc = n = scoreDoc.doc - this.searchable.docBase;
                    this.fakeScorer.score = scoreDoc.score;
                    this.hq.collect(n);
                }
            }
            finally {
                this.lock.unlock();
            }
            return topFieldDocs;
        }

        private final class FakeScorer
        extends Scorer {
            float score;
            int doc;

            public FakeScorer() {
                super(null, null);
            }

            @Override
            public int advance(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public float freq() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int nextDoc() {
                throw new UnsupportedOperationException();
            }

            @Override
            public float score() {
                return this.score;
            }
        }
    }

    private static final class MultiSearcherCallableNoSort
    implements Callable<TopDocs> {
        private final Lock lock;
        private final IndexSearcher searchable;
        private final Weight weight;
        private final Filter filter;
        private final ScoreDoc after;
        private final int nDocs;
        private final HitQueue hq;

        public MultiSearcherCallableNoSort(Lock lock, IndexSearcher indexSearcher, Weight weight, Filter filter, ScoreDoc scoreDoc, int n, HitQueue hitQueue) {
            this.lock = lock;
            this.searchable = indexSearcher;
            this.weight = weight;
            this.filter = filter;
            this.after = scoreDoc;
            this.nDocs = n;
            this.hq = hitQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TopDocs call() throws IOException {
            TopDocs topDocs = this.after == null ? this.searchable.search(this.weight, this.filter, this.nDocs) : this.searchable.search(this.weight, this.filter, this.after, this.nDocs);
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            this.lock.lock();
            try {
                for (int i = 0; i < scoreDocArray.length; ++i) {
                    ScoreDoc scoreDoc = scoreDocArray[i];
                    if (scoreDoc != this.hq.insertWithOverflow(scoreDoc)) continue;
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
            return topDocs;
        }
    }
}

