/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.SearcherWarmer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ThreadInterruptedException;

public class NRTManager
implements Closeable {
    private static final long MAX_SEARCHER_GEN = Long.MAX_VALUE;
    private final IndexWriter writer;
    private final SearcherManagerRef withoutDeletes;
    private final SearcherManagerRef withDeletes;
    private final AtomicLong indexingGen;
    private final List<WaitingListener> waitingListeners = new CopyOnWriteArrayList<WaitingListener>();
    private final ReentrantLock reopenLock = new ReentrantLock();
    private final Condition newGeneration = this.reopenLock.newCondition();

    public NRTManager(IndexWriter indexWriter, SearcherWarmer searcherWarmer) throws IOException {
        this(indexWriter, null, searcherWarmer, true);
    }

    public NRTManager(IndexWriter indexWriter, ExecutorService executorService, SearcherWarmer searcherWarmer) throws IOException {
        this(indexWriter, executorService, searcherWarmer, true);
    }

    public NRTManager(IndexWriter indexWriter, ExecutorService executorService, SearcherWarmer searcherWarmer, boolean bl) throws IOException {
        this.writer = indexWriter;
        if (bl) {
            this.withoutDeletes = this.withDeletes = new SearcherManagerRef(true, 0L, new SearcherManager(indexWriter, true, searcherWarmer, executorService));
        } else {
            this.withDeletes = new SearcherManagerRef(true, 0L, new SearcherManager(indexWriter, true, searcherWarmer, executorService));
            this.withoutDeletes = new SearcherManagerRef(false, 0L, new SearcherManager(indexWriter, false, searcherWarmer, executorService));
        }
        this.indexingGen = new AtomicLong(1L);
    }

    public void addWaitingListener(WaitingListener waitingListener) {
        this.waitingListeners.add(waitingListener);
    }

    public void removeWaitingListener(WaitingListener waitingListener) {
        this.waitingListeners.remove(waitingListener);
    }

    public long updateDocument(Term term, Document document, Analyzer analyzer) throws IOException {
        this.writer.updateDocument(term, document, analyzer);
        return this.indexingGen.get();
    }

    public long updateDocument(Term term, Document document) throws IOException {
        this.writer.updateDocument(term, document);
        return this.indexingGen.get();
    }

    public long updateDocuments(Term term, Collection<Document> collection, Analyzer analyzer) throws IOException {
        this.writer.updateDocuments(term, collection, analyzer);
        return this.indexingGen.get();
    }

    public long updateDocuments(Term term, Collection<Document> collection) throws IOException {
        this.writer.updateDocuments(term, collection);
        return this.indexingGen.get();
    }

    public long deleteDocuments(Term term) throws IOException {
        this.writer.deleteDocuments(term);
        return this.indexingGen.get();
    }

    public long deleteDocuments(Term ... termArray) throws IOException {
        this.writer.deleteDocuments(termArray);
        return this.indexingGen.get();
    }

    public long deleteDocuments(Query query) throws IOException {
        this.writer.deleteDocuments(query);
        return this.indexingGen.get();
    }

    public long deleteDocuments(Query ... queryArray) throws IOException {
        this.writer.deleteDocuments(queryArray);
        return this.indexingGen.get();
    }

    public long deleteAll() throws IOException {
        this.writer.deleteAll();
        return this.indexingGen.get();
    }

    public long addDocument(Document document, Analyzer analyzer) throws IOException {
        this.writer.addDocument(document, analyzer);
        return this.indexingGen.get();
    }

    public long addDocuments(Collection<Document> collection, Analyzer analyzer) throws IOException {
        this.writer.addDocuments(collection, analyzer);
        return this.indexingGen.get();
    }

    public long addDocument(Document document) throws IOException {
        this.writer.addDocument(document);
        return this.indexingGen.get();
    }

    public long addDocuments(Collection<Document> collection) throws IOException {
        this.writer.addDocuments(collection);
        return this.indexingGen.get();
    }

    public long addIndexes(Directory ... directoryArray) throws CorruptIndexException, IOException {
        this.writer.addIndexes(directoryArray);
        return this.indexingGen.get();
    }

    public long addIndexes(IndexReader ... indexReaderArray) throws CorruptIndexException, IOException {
        this.writer.addIndexes(indexReaderArray);
        return this.indexingGen.get();
    }

    public SearcherManager waitForGeneration(long l, boolean bl) {
        return this.waitForGeneration(l, bl, -1L, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearcherManager waitForGeneration(long l, boolean bl, long l2, TimeUnit timeUnit) {
        try {
            long l3 = this.indexingGen.get();
            if (l > l3) {
                throw new IllegalArgumentException("targetGen=" + l + " was never returned by this NRTManager instance (current gen=" + l3 + ")");
            }
            this.reopenLock.lockInterruptibly();
            try {
                if (l <= this.getCurrentSearchingGen(bl)) return this.getSearcherManager(bl);
                for (WaitingListener waitingListener : this.waitingListeners) {
                    waitingListener.waiting(bl, l);
                }
                do {
                    if (l <= this.getCurrentSearchingGen(bl)) return this.getSearcherManager(bl);
                } while (this.waitOnGenCondition(l2, timeUnit));
                SearcherManager searcherManager = this.getSearcherManager(bl);
                return searcherManager;
            }
            finally {
                this.reopenLock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException(interruptedException);
        }
    }

    private boolean waitOnGenCondition(long l, TimeUnit timeUnit) throws InterruptedException {
        assert (this.reopenLock.isHeldByCurrentThread());
        if (l < 0L) {
            this.newGeneration.await();
            return true;
        }
        return this.newGeneration.await(l, timeUnit);
    }

    public long getCurrentSearchingGen(boolean bl) {
        if (bl) {
            return this.withDeletes.generation;
        }
        return Math.max(this.withoutDeletes.generation, this.withDeletes.generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeReopen(boolean bl) throws IOException {
        if (this.reopenLock.tryLock()) {
            try {
                SearcherManagerRef searcherManagerRef = bl ? this.withDeletes : this.withoutDeletes;
                long l = this.indexingGen.getAndIncrement();
                boolean bl2 = false;
                if (searcherManagerRef.generation == Long.MAX_VALUE) {
                    this.newGeneration.signalAll();
                    boolean bl3 = false;
                    return bl3;
                }
                bl2 = searcherManagerRef.manager.isSearcherCurrent();
                if (!bl2) {
                    bl2 = searcherManagerRef.manager.maybeReopen();
                }
                if (bl2) {
                    searcherManagerRef.generation = l;
                    this.newGeneration.signalAll();
                }
                boolean bl4 = bl2;
                return bl4;
            }
            finally {
                this.reopenLock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.reopenLock.lock();
        try {
            try {
                IOUtils.close(this.withDeletes, this.withoutDeletes);
            }
            finally {
                this.newGeneration.signalAll();
            }
        }
        finally {
            this.reopenLock.unlock();
            assert (this.withDeletes.generation == Long.MAX_VALUE && this.withoutDeletes.generation == Long.MAX_VALUE);
        }
    }

    public SearcherManager getSearcherManager(boolean bl) {
        if (bl) {
            return this.withDeletes.manager;
        }
        if (this.withDeletes.generation > this.withoutDeletes.generation) {
            return this.withDeletes.manager;
        }
        return this.withoutDeletes.manager;
    }

    static final class SearcherManagerRef
    implements Closeable {
        final boolean applyDeletes;
        volatile long generation;
        final SearcherManager manager;

        SearcherManagerRef(boolean bl, long l, SearcherManager searcherManager) {
            this.applyDeletes = bl;
            this.generation = l;
            this.manager = searcherManager;
        }

        @Override
        public void close() throws IOException {
            this.generation = Long.MAX_VALUE;
            this.manager.close();
        }
    }

    public static interface WaitingListener {
        public void waiting(boolean var1, long var2);
    }
}

