/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.ToStringUtils;

public final class NumericRangeQuery<T extends Number>
extends MultiTermQuery {
    String field;
    final int precisionStep;
    final NumericField.DataType dataType;
    final T min;
    final T max;
    final boolean minInclusive;
    final boolean maxInclusive;
    static final long LONG_NEGATIVE_INFINITY = NumericUtils.doubleToSortableLong(Double.NEGATIVE_INFINITY);
    static final long LONG_POSITIVE_INFINITY = NumericUtils.doubleToSortableLong(Double.POSITIVE_INFINITY);
    static final int INT_NEGATIVE_INFINITY = NumericUtils.floatToSortableInt(Float.NEGATIVE_INFINITY);
    static final int INT_POSITIVE_INFINITY = NumericUtils.floatToSortableInt(Float.POSITIVE_INFINITY);

    private NumericRangeQuery(String string, int n, NumericField.DataType dataType, T t, T t2, boolean bl, boolean bl2) {
        if (n < 1) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        this.field = StringHelper.intern(string);
        this.precisionStep = n;
        this.dataType = dataType;
        this.min = t;
        this.max = t2;
        this.minInclusive = bl;
        this.maxInclusive = bl2;
        switch (dataType) {
            case LONG: 
            case DOUBLE: {
                this.setRewriteMethod(n > 6 ? CONSTANT_SCORE_FILTER_REWRITE : CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
                break;
            }
            case INT: 
            case FLOAT: {
                this.setRewriteMethod(n > 8 ? CONSTANT_SCORE_FILTER_REWRITE : CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid numeric DataType");
            }
        }
        if (t != null && t.equals(t2)) {
            this.setRewriteMethod(CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE);
        }
    }

    public static NumericRangeQuery<Long> newLongRange(String string, int n, Long l, Long l2, boolean bl, boolean bl2) {
        return new NumericRangeQuery<Long>(string, n, NumericField.DataType.LONG, l, l2, bl, bl2);
    }

    public static NumericRangeQuery<Long> newLongRange(String string, Long l, Long l2, boolean bl, boolean bl2) {
        return new NumericRangeQuery<Long>(string, 4, NumericField.DataType.LONG, l, l2, bl, bl2);
    }

    public static NumericRangeQuery<Integer> newIntRange(String string, int n, Integer n2, Integer n3, boolean bl, boolean bl2) {
        return new NumericRangeQuery<Integer>(string, n, NumericField.DataType.INT, n2, n3, bl, bl2);
    }

    public static NumericRangeQuery<Integer> newIntRange(String string, Integer n, Integer n2, boolean bl, boolean bl2) {
        return new NumericRangeQuery<Integer>(string, 4, NumericField.DataType.INT, n, n2, bl, bl2);
    }

    public static NumericRangeQuery<Double> newDoubleRange(String string, int n, Double d, Double d2, boolean bl, boolean bl2) {
        return new NumericRangeQuery<Double>(string, n, NumericField.DataType.DOUBLE, d, d2, bl, bl2);
    }

    public static NumericRangeQuery<Double> newDoubleRange(String string, Double d, Double d2, boolean bl, boolean bl2) {
        return new NumericRangeQuery<Double>(string, 4, NumericField.DataType.DOUBLE, d, d2, bl, bl2);
    }

    public static NumericRangeQuery<Float> newFloatRange(String string, int n, Float f, Float f2, boolean bl, boolean bl2) {
        return new NumericRangeQuery<Float>(string, n, NumericField.DataType.FLOAT, f, f2, bl, bl2);
    }

    public static NumericRangeQuery<Float> newFloatRange(String string, Float f, Float f2, boolean bl, boolean bl2) {
        return new NumericRangeQuery<Float>(string, 4, NumericField.DataType.FLOAT, f, f2, bl, bl2);
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader indexReader) throws IOException {
        return new NumericRangeTermEnum(indexReader);
    }

    public String getField() {
        return this.field;
    }

    public boolean includesMin() {
        return this.minInclusive;
    }

    public boolean includesMax() {
        return this.maxInclusive;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public int getPrecisionStep() {
        return this.precisionStep;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.field.equals(string)) {
            stringBuilder.append(this.field).append(':');
        }
        return stringBuilder.append(this.minInclusive ? (char)'[' : '{').append(this.min == null ? "*" : this.min.toString()).append(" TO ").append(this.max == null ? "*" : this.max.toString()).append(this.maxInclusive ? (char)']' : '}').append(ToStringUtils.boost(this.getBoost())).toString();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof NumericRangeQuery) {
            NumericRangeQuery numericRangeQuery = (NumericRangeQuery)object;
            return this.field == numericRangeQuery.field && (numericRangeQuery.min == null ? this.min == null : numericRangeQuery.min.equals(this.min)) && (numericRangeQuery.max == null ? this.max == null : numericRangeQuery.max.equals(this.max)) && this.minInclusive == numericRangeQuery.minInclusive && this.maxInclusive == numericRangeQuery.maxInclusive && this.precisionStep == numericRangeQuery.precisionStep;
        }
        return false;
    }

    @Override
    public final int hashCode() {
        int n = super.hashCode();
        n += this.field.hashCode() ^ 1164311910 + this.precisionStep ^ 0x64365465;
        if (this.min != null) {
            n += this.min.hashCode() ^ 0x14FA55FB;
        }
        if (this.max != null) {
            n += this.max.hashCode() ^ 0x733FA5FE;
        }
        return n + (Boolean.valueOf(this.minInclusive).hashCode() ^ 0x14FA55FB) + (Boolean.valueOf(this.maxInclusive).hashCode() ^ 0x733FA5FE);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.field = StringHelper.intern(this.field);
    }

    private final class NumericRangeTermEnum
    extends FilteredTermEnum {
        private final IndexReader reader;
        private final LinkedList<String> rangeBounds = new LinkedList();
        private final Term termTemplate;
        private String currentUpperBound;

        NumericRangeTermEnum(IndexReader indexReader) throws IOException {
            this.termTemplate = new Term(NumericRangeQuery.this.field);
            this.currentUpperBound = null;
            this.reader = indexReader;
            switch (NumericRangeQuery.this.dataType) {
                case LONG: 
                case DOUBLE: {
                    long l;
                    long l2;
                    if (NumericRangeQuery.this.dataType == NumericField.DataType.LONG) {
                        l2 = NumericRangeQuery.this.min == null ? Long.MIN_VALUE : ((Number)NumericRangeQuery.this.min).longValue();
                    } else {
                        assert (NumericRangeQuery.this.dataType == NumericField.DataType.DOUBLE);
                        long l3 = l2 = NumericRangeQuery.this.min == null ? LONG_NEGATIVE_INFINITY : NumericUtils.doubleToSortableLong(((Number)NumericRangeQuery.this.min).doubleValue());
                    }
                    if (!NumericRangeQuery.this.minInclusive && NumericRangeQuery.this.min != null) {
                        if (l2 == Long.MAX_VALUE) break;
                        ++l2;
                    }
                    if (NumericRangeQuery.this.dataType == NumericField.DataType.LONG) {
                        l = NumericRangeQuery.this.max == null ? Long.MAX_VALUE : ((Number)NumericRangeQuery.this.max).longValue();
                    } else {
                        assert (NumericRangeQuery.this.dataType == NumericField.DataType.DOUBLE);
                        long l4 = l = NumericRangeQuery.this.max == null ? LONG_POSITIVE_INFINITY : NumericUtils.doubleToSortableLong(((Number)NumericRangeQuery.this.max).doubleValue());
                    }
                    if (!NumericRangeQuery.this.maxInclusive && NumericRangeQuery.this.max != null) {
                        if (l == Long.MIN_VALUE) break;
                        --l;
                    }
                    NumericUtils.splitLongRange(new NumericUtils.LongRangeBuilder(){

                        @Override
                        public final void addRange(String string, String string2) {
                            NumericRangeTermEnum.this.rangeBounds.add(string);
                            NumericRangeTermEnum.this.rangeBounds.add(string2);
                        }
                    }, NumericRangeQuery.this.precisionStep, l2, l);
                    break;
                }
                case INT: 
                case FLOAT: {
                    int n;
                    int n2;
                    if (NumericRangeQuery.this.dataType == NumericField.DataType.INT) {
                        n2 = NumericRangeQuery.this.min == null ? Integer.MIN_VALUE : ((Number)NumericRangeQuery.this.min).intValue();
                    } else {
                        assert (NumericRangeQuery.this.dataType == NumericField.DataType.FLOAT);
                        int n3 = n2 = NumericRangeQuery.this.min == null ? INT_NEGATIVE_INFINITY : NumericUtils.floatToSortableInt(((Number)NumericRangeQuery.this.min).floatValue());
                    }
                    if (!NumericRangeQuery.this.minInclusive && NumericRangeQuery.this.min != null) {
                        if (n2 == Integer.MAX_VALUE) break;
                        ++n2;
                    }
                    if (NumericRangeQuery.this.dataType == NumericField.DataType.INT) {
                        n = NumericRangeQuery.this.max == null ? Integer.MAX_VALUE : ((Number)NumericRangeQuery.this.max).intValue();
                    } else {
                        assert (NumericRangeQuery.this.dataType == NumericField.DataType.FLOAT);
                        int n4 = n = NumericRangeQuery.this.max == null ? INT_POSITIVE_INFINITY : NumericUtils.floatToSortableInt(((Number)NumericRangeQuery.this.max).floatValue());
                    }
                    if (!NumericRangeQuery.this.maxInclusive && NumericRangeQuery.this.max != null) {
                        if (n == Integer.MIN_VALUE) break;
                        --n;
                    }
                    NumericUtils.splitIntRange(new NumericUtils.IntRangeBuilder(){

                        @Override
                        public final void addRange(String string, String string2) {
                            NumericRangeTermEnum.this.rangeBounds.add(string);
                            NumericRangeTermEnum.this.rangeBounds.add(string2);
                        }
                    }, NumericRangeQuery.this.precisionStep, n2, n);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid numeric DataType");
                }
            }
            this.next();
        }

        @Override
        public float difference() {
            return 1.0f;
        }

        @Override
        protected boolean endEnum() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        protected void setEnum(TermEnum termEnum) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        protected boolean termCompare(Term term) {
            return term.field() == NumericRangeQuery.this.field && term.text().compareTo(this.currentUpperBound) <= 0;
        }

        @Override
        public boolean next() throws IOException {
            if (this.currentTerm != null) {
                assert (this.actualEnum != null);
                if (this.actualEnum.next()) {
                    this.currentTerm = this.actualEnum.term();
                    if (this.termCompare(this.currentTerm)) {
                        return true;
                    }
                }
            }
            this.currentTerm = null;
            while (this.rangeBounds.size() >= 2) {
                assert (this.rangeBounds.size() % 2 == 0);
                if (this.actualEnum != null) {
                    this.actualEnum.close();
                    this.actualEnum = null;
                }
                String string = this.rangeBounds.removeFirst();
                this.currentUpperBound = this.rangeBounds.removeFirst();
                this.actualEnum = this.reader.terms(this.termTemplate.createTerm(string));
                this.currentTerm = this.actualEnum.term();
                if (this.currentTerm != null && this.termCompare(this.currentTerm)) {
                    return true;
                }
                this.currentTerm = null;
            }
            assert (this.rangeBounds.size() == 0 && this.currentTerm == null);
            return false;
        }

        @Override
        public void close() throws IOException {
            this.rangeBounds.clear();
            this.currentUpperBound = null;
            super.close();
        }
    }
}

